/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.editors.geoplace.format;

import ancestris.modules.editors.geoplace.format.StringTransferHandler;
import genj.gedcom.PropertyPlace;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.TransferHandler;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class PlaceFormatConverterPanel
extends JPanel {
    private String[] fromFormat = null;
    private JTextField[] fromFields = null;
    private String toPlaceFormat = null;
    private String[] toFormat = null;
    private JTextField[] toFields = null;
    private boolean isValidated = false;
    private final StringTransferHandler sth = new StringTransferHandler(this);
    private JButton jButton1;
    private JLabel jLabel4;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane3;
    private JLabel leftTitle;
    private JLabel rightTitle;
    private JLabel textTitle;

    public PlaceFormatConverterPanel(String fromPlaceFormat, String toPlaceFormat, String initMap) {
        this.initComponents();
        DragMouseAdapter listener = new DragMouseAdapter();
        this.fromFormat = PropertyPlace.getFormat((String)fromPlaceFormat);
        this.fromFields = new JTextField[this.fromFormat.length];
        this.jPanel1.setLayout(new GridLayout(0, 1));
        for (int i = 0; i < this.fromFormat.length; ++i) {
            this.fromFormat[i] = this.fromFormat[i].trim();
            this.fromFields[i] = new JTextField(this.fromFormat[i]);
            this.jPanel1.add(this.fromFields[i]);
            this.fromFields[i].setTransferHandler(this.sth);
            this.fromFields[i].setDragEnabled(true);
            this.fromFields[i].addMouseListener(listener);
            this.fromFields[i].setEditable(false);
            this.fromFields[i].setDropTarget(null);
        }
        this.initToFields(toPlaceFormat);
        this.setConversionMapFromString(initMap);
    }

    public final void initToFields(String toPlaceFormat) {
        if (toPlaceFormat == null) {
            return;
        }
        if (this.toPlaceFormat != null && this.toPlaceFormat.equals(toPlaceFormat)) {
            return;
        }
        if (this.toPlaceFormat != null) {
            this.isValidated = false;
            this.jPanel2.removeAll();
            for (JTextField fromField : this.fromFields) {
                fromField.setEnabled(true);
            }
        }
        this.toPlaceFormat = toPlaceFormat;
        this.toFormat = PropertyPlace.getFormat((String)toPlaceFormat);
        this.toFields = new JTextField[this.toFormat.length];
        this.jPanel2.setLayout(new GridLayout(0, 2));
        for (int i = 0; i < this.toFormat.length; ++i) {
            this.toFormat[i] = this.toFormat[i].trim();
            this.jPanel2.add(new JLabel(this.toFormat[i]));
            this.toFields[i] = new JTextField("");
            this.jPanel2.add(this.toFields[i]);
            this.toFields[i].setTransferHandler(this.sth);
            this.toFields[i].setEditable(false);
            this.toFields[i].setDragEnabled(false);
        }
    }

    public void setTextTitle(String text) {
        this.textTitle.setText(text);
    }

    public void setLeftTitle(String text) {
        this.leftTitle.setText(text);
    }

    public void setRightTitle(String text) {
        this.rightTitle.setText(text);
    }

    private void initComponents() {
        this.jScrollPane3 = new JScrollPane();
        this.jPanel3 = new JPanel();
        this.textTitle = new JLabel();
        this.leftTitle = new JLabel();
        this.rightTitle = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jPanel1 = new JPanel();
        this.jScrollPane2 = new JScrollPane();
        this.jPanel2 = new JPanel();
        this.jLabel4 = new JLabel();
        this.jButton1 = new JButton();
        this.setBorder(null);
        this.setPreferredSize(new Dimension(570, 470));
        this.jScrollPane3.setBorder(null);
        this.jScrollPane3.setViewportBorder(null);
        this.jPanel3.setBorder(null);
        this.jPanel3.setPreferredSize(new Dimension(560, 460));
        this.textTitle.setFont(new Font("DejaVu Sans", 1, 12));
        Mnemonics.setLocalizedText((JLabel)this.textTitle, (String)NbBundle.getMessage(PlaceFormatConverterPanel.class, (String)"PlaceFormatConverterPanel.textTitle.text"));
        this.leftTitle.setFont(new Font("DejaVu Sans", 1, 12));
        Mnemonics.setLocalizedText((JLabel)this.leftTitle, (String)NbBundle.getMessage(PlaceFormatConverterPanel.class, (String)"PlaceFormatConverterPanel.leftTitle.text"));
        this.rightTitle.setFont(new Font("DejaVu Sans", 1, 12));
        Mnemonics.setLocalizedText((JLabel)this.rightTitle, (String)NbBundle.getMessage(PlaceFormatConverterPanel.class, (String)"PlaceFormatConverterPanel.rightTitle.text"));
        this.jScrollPane1.setBorder(null);
        this.jScrollPane1.setViewportBorder(null);
        this.jPanel1.setBorder(null);
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 292, Short.MAX_VALUE));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 290, Short.MAX_VALUE));
        this.jScrollPane1.setViewportView(this.jPanel1);
        this.jScrollPane2.setBorder(null);
        this.jScrollPane2.setViewportBorder(null);
        this.jPanel2.setBorder(null);
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 393, Short.MAX_VALUE));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 290, Short.MAX_VALUE));
        this.jScrollPane2.setViewportView(this.jPanel2);
        Mnemonics.setLocalizedText((JLabel)this.jLabel4, (String)NbBundle.getMessage(PlaceFormatConverterPanel.class, (String)"PlaceFormatConverterPanel.jLabel4.text"));
        this.jButton1.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/editors/geoplace/resources/Erase.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.jButton1, (String)NbBundle.getMessage(PlaceFormatConverterPanel.class, (String)"PlaceFormatConverterPanel.jButton1.text"));
        this.jButton1.setToolTipText(NbBundle.getMessage(PlaceFormatConverterPanel.class, (String)"PlaceFormatConverterPanel.jButton1.toolTipText"));
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PlaceFormatConverterPanel.this.jButton1ActionPerformed(evt);
            }
        });
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addGap(12, 12, 12).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.textTitle, -2, 0, Short.MAX_VALUE).addGroup(jPanel3Layout.createSequentialGroup().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.leftTitle).addComponent(this.jScrollPane1, -1, 211, Short.MAX_VALUE)).addGap(36, 36, 36).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.rightTitle).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jButton1)).addGroup(jPanel3Layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.jScrollPane2, -2, 285, -2))).addGap(20, 20, 20)).addComponent(this.jLabel4, -1, 552, Short.MAX_VALUE)).addContainerGap()));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addComponent(this.textTitle, -2, 28, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel4, -2, -1, -2).addGap(18, 18, 18).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jButton1, -1, -1, Short.MAX_VALUE).addComponent(this.rightTitle, -1, -1, Short.MAX_VALUE).addComponent(this.leftTitle, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jScrollPane1).addComponent(this.jScrollPane2)).addContainerGap(37, Short.MAX_VALUE)));
        this.jScrollPane3.setViewportView(this.jPanel3);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane3, -1, 570, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane3, -1, 470, Short.MAX_VALUE));
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        int i;
        for (i = 0; i < this.fromFormat.length; ++i) {
            this.fromFields[i].setEnabled(true);
        }
        for (i = 0; i < this.toFormat.length; ++i) {
            this.toFields[i].setText("");
        }
    }

    void updateDisplay() {
        boolean found = false;
        for (int i = 0; i < this.fromFields.length; ++i) {
            String fromStr = this.fromFields[i].getText();
            found = false;
            for (JTextField toField : this.toFields) {
                String toStr = toField.getText();
                if (!toStr.equals(fromStr)) continue;
                found = true;
                break;
            }
            if (found) continue;
            this.fromFields[i].setEnabled(true);
        }
    }

    public void setValidatedMap(boolean b, String displayedFormat) {
        if (displayedFormat != null && displayedFormat.isEmpty()) {
            return;
        }
        if (displayedFormat == null) {
            this.isValidated = b;
            return;
        }
        if (this.isValidated && this.toPlaceFormat.equals(displayedFormat)) {
            return;
        }
    }

    public boolean isValidatedMap() {
        return this.isValidated;
    }

    public boolean isMapComplete() {
        boolean emptyFields = true;
        for (JTextField toField : this.toFields) {
            if (toField.getText().isEmpty()) continue;
            emptyFields = false;
        }
        if (emptyFields) {
            this.isValidated = false;
            return false;
        }
        boolean found = false;
        for (int i = 0; i < this.fromFields.length; ++i) {
            String fromStr = this.fromFields[i].getText();
            found = false;
            for (JTextField toField : this.toFields) {
                String toStr = toField.getText();
                if (!toStr.equals(fromStr)) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    public String getConversionMapAsString() {
        String ret = "";
        String sep = ",";
        int index = -1;
        for (int i = 0; i < this.toFormat.length; ++i) {
            if (i == this.toFormat.length - 1) {
                sep = "";
            }
            for (int j = 0; j < this.fromFormat.length; ++j) {
                if (!this.fromFormat[j].equals(this.toFields[i].getText())) continue;
                index = j;
            }
            ret = index != -1 ? ret + index + sep : ret + "" + sep;
            index = -1;
        }
        return ret;
    }

    public void setConversionMapFromString(String mapStr) {
        if (mapStr == null || mapStr.trim().isEmpty()) {
            return;
        }
        String[] map = PropertyPlace.getFormat((String)mapStr);
        for (int i = 0; i < this.toFormat.length && i < map.length; ++i) {
            if (map[i].trim().isEmpty()) continue;
            int j = Integer.valueOf(map[i]);
            this.toFields[i].setText(this.fromFields[j].getText());
            this.fromFields[j].setEnabled(false);
        }
    }

    public class DragMouseAdapter
    extends MouseAdapter {
        @Override
        public void mousePressed(MouseEvent e) {
            JComponent c = (JComponent)e.getSource();
            TransferHandler handler = c.getTransferHandler();
            handler.exportAsDrag(c, e, 1);
        }
    }
}

