/*
 * Decompiled with CFR 0.152.
 */
package ancestris.reports.sosa;

import ancestris.core.TextOptions;
import ancestris.gedcom.privacy.PrivacyPolicy;
import ancestris.util.EventUsage;
import genj.fo.Document;
import genj.gedcom.Entity;
import genj.gedcom.Fam;
import genj.gedcom.Gedcom;
import genj.gedcom.Indi;
import genj.gedcom.Property;
import genj.gedcom.PropertyDate;
import genj.gedcom.PropertySource;
import genj.gedcom.Source;
import genj.gedcom.TagPath;
import genj.report.Report;
import java.awt.GraphicsEnvironment;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.openide.util.NbBundle;

public class ReportSosa
extends Report {
    private final String[] fonts = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
    private static final int SOSA_REPORT = 0;
    private static final int TABLE_REPORT = 1;
    private static final int LINEAGE_REPORT = 2;
    private static final int AGNATIC_REPORT = 3;
    public int reportType = 0;
    public String[] reportTypes = new String[]{this.translate("SosaReport"), this.translate("TableReport"), this.translate("LineageReport"), this.translate("AgnaticReport")};
    private static final int ONE_LINE = 0;
    private static final int ONE_EVT_PER_LINE = 1;
    public int reportFormat = 0;
    public String[] reportFormats = new String[]{this.translate("IndiPerLine"), this.translate("EventPerLine")};
    private static final int ORIENTATION_LANDSCAPE = 1;
    private static final int[] fontSizes = new int[]{4, 6, 8, 10, 12, 14, 16};
    private static final int[] sectionSizes = new int[]{0, 1, 2, 3, 4, 5, 6};
    public int reportOrientation = 1;
    public String[] reportOrientations = new String[]{this.translate("OrientationPO"), this.translate("OrientationLA")};
    public int reportFont = 0;
    public String[] reportFonts = this.fonts;
    public int reportFontSize = 4;
    public String[] reportFontSizes = new String[]{this.translate("FontSizeXXS"), this.translate("FontSizeXS"), this.translate("FontSizeS"), this.translate("FontSizeM"), this.translate("FontSizeL"), this.translate("FontSizeXL"), this.translate("FontSizeXXL")};
    public boolean displayBullet = true;
    public BigInteger startSosa = BigInteger.ONE;
    public int privateGen = 0;
    public int reportMinGenerations = 1;
    public int reportMaxGenerations = 999;
    public boolean showEventName = true;
    public boolean reportIndiNumber = true;
    public boolean showAllPlaceJurisdictions = false;
    private static final int SRC_NO = 0;
    private static final int SRC_TITLE_NO_TEXT = 1;
    private static final int SRC_TITLE_GEN_NO_TEXT = 2;
    private static final int SRC_TITLE_END_NO_TEXT = 3;
    private static final int SRC_TITLE_TEXT = 4;
    private static final int SRC_TITLE_TEXT_GEN = 5;
    private static final int SRC_TITLE_TEXT_END = 6;
    private static final int SRC_TITLE_GEN_TEXT_GEN = 7;
    private static final int SRC_TITLE_END_TEXT_END = 8;
    public int displaySource = 1;
    public String[] displaySources = new String[]{this.translate("src_no"), this.translate("src_title_no_text"), this.translate("src_title_gen_no_text"), this.translate("src_title_end_no_text"), this.translate("src_title_text"), this.translate("src_title_text_gen"), this.translate("src_title_text_end"), this.translate("src_title_gen_text_gen"), this.translate("src_title_end_text_end")};
    public boolean displayEmpty = false;
    public boolean prefixEvent = false;
    public String prefixSource = "Src:";
    private static String format_one_line = "";
    private static String format_multi_lines = "";
    private static String source_title_color = "";
    private static String source_text_color = "";
    private static final int COLOR_BLACK = 0;
    private static final int COLOR_GREY = 1;
    private static final int COLOR_PURPLE = 2;
    private static final int COLOR_INDIGO = 3;
    private static final int COLOR_BLUE = 4;
    private static final int COLOR_GREEN = 5;
    private static final int COLOR_YELLOW = 6;
    private static final int COLOR_ORANGE = 7;
    private static final int COLOR_RED = 8;
    public int srcColor = 4;
    public String[] srcColors = new String[]{this.translate("Black"), this.translate("Grey"), this.translate("Purple"), this.translate("Indigo"), this.translate("Blue"), this.translate("Green"), this.translate("Yellow"), this.translate("Orange"), this.translate("Red")};
    public int srcTextColor = 1;
    public String[] srcTextColors = new String[]{this.translate("Black"), this.translate("Grey"), this.translate("Purple"), this.translate("Indigo"), this.translate("Blue"), this.translate("Green"), this.translate("Yellow"), this.translate("Orange"), this.translate("Red")};
    private static final SortedSet<Source> GLOBAL_SRC_LIST = new TreeSet<Source>();
    private static final Map<Source, List<String>> GLOBAL_SRC_NOTES = new TreeMap<Source, List<String>>();
    private static final String NOTE = ".:NOTE";
    private static final String DATATEXT = ".:DATA:TEXT";
    private static final String DATADATE = ".:DATA:DATE";
    private boolean srcLinkSrc = false;
    private boolean srcLinkGenSrc = false;
    private boolean srcTitle = false;
    private boolean srcAtGen = false;
    private boolean srcAtEnd = false;
    private boolean srcTextAtEvent = false;
    private boolean srcTextAtGen = false;
    private boolean srcTextAtEnd = false;
    private boolean srcDisplay = false;
    private static final String EVENTS_DELIMITER = ", ";
    private static final String BITS_DELIMITER = "$#@";
    private static final String LOCAL_DELIMITER = "#localproperty#";
    private static boolean firstEventsDelimiter = true;

    public Document start(Indi indi) {
        Recursion recursion;
        PrivacyPolicy policy = PrivacyPolicy.getDefault();
        this.InitVariables();
        source_title_color = this.assignColor(this.srcColor);
        format_one_line = "font-style=italic,color=" + source_title_color;
        format_multi_lines = "margin-left=0px,font-style=italic,color=" + source_title_color;
        source_text_color = this.assignColor(this.srcTextColor);
        if (this.startSosa.equals(BigInteger.ZERO)) {
            this.startSosa = BigInteger.ONE;
        }
        switch (this.reportType) {
            case 3: {
                recursion = new Agnatic();
                break;
            }
            case 0: {
                recursion = new Sosa();
                break;
            }
            case 2: {
                recursion = new Lineage();
                break;
            }
            case 1: {
                recursion = new Table();
                break;
            }
            default: {
                throw new IllegalArgumentException("no such report type");
            }
        }
        String title = recursion.getTitle(indi);
        Document doc = new Document(title, this.fonts[this.reportFont], fontSizes[this.reportFontSize], 0, sectionSizes[this.reportFontSize], this.reportOrientation);
        doc.startSection(title, 2);
        recursion.start(indi, policy, doc);
        return doc;
    }

    void InitVariables() {
        if (this.reportType == 1) {
            this.displayBullet = true;
            if (this.displaySource == 2) {
                this.displaySource = 3;
            }
            if (this.displaySource == 5) {
                this.displaySource = 6;
            }
            if (this.displaySource == 7) {
                this.displaySource = 8;
            }
        }
        this.srcLinkSrc = false;
        this.srcLinkGenSrc = false;
        this.srcTitle = false;
        this.srcAtGen = false;
        this.srcAtEnd = false;
        this.srcTextAtEvent = false;
        this.srcTextAtGen = false;
        this.srcTextAtEnd = false;
        this.srcDisplay = false;
        switch (this.displaySource) {
            case 0: {
                break;
            }
            case 1: {
                this.srcTitle = true;
                this.srcDisplay = true;
                break;
            }
            case 2: {
                this.srcLinkGenSrc = true;
                this.srcAtGen = true;
                this.srcDisplay = true;
                break;
            }
            case 4: {
                this.srcLinkGenSrc = true;
                this.srcTitle = true;
                this.srcTextAtEvent = true;
                this.srcDisplay = true;
                break;
            }
            case 5: {
                this.srcLinkGenSrc = true;
                this.srcTitle = true;
                this.srcTextAtGen = true;
                this.srcDisplay = true;
                break;
            }
            case 7: {
                this.srcLinkGenSrc = true;
                this.srcAtGen = true;
                this.srcTextAtGen = true;
                this.srcDisplay = true;
                break;
            }
            case 3: {
                this.srcLinkSrc = true;
                this.srcAtEnd = true;
                this.srcDisplay = true;
                break;
            }
            case 6: {
                this.srcLinkSrc = true;
                this.srcTitle = true;
                this.srcTextAtEnd = true;
                this.srcDisplay = true;
                break;
            }
            case 8: {
                this.srcLinkSrc = true;
                this.srcAtEnd = true;
                this.srcTextAtEnd = true;
                this.srcDisplay = true;
                break;
            }
        }
    }

    String assignColor(int srcColor) {
        String cs;
        switch (srcColor) {
            case 0: {
                cs = "#000000";
                break;
            }
            case 1: {
                cs = "#707070";
                break;
            }
            case 2: {
                cs = "#ff60ff";
                break;
            }
            case 3: {
                cs = "#8560ff";
                break;
            }
            case 4: {
                cs = "#6060ff";
                break;
            }
            case 5: {
                cs = "#00a71c";
                break;
            }
            case 6: {
                cs = "#d1de00";
                break;
            }
            case 7: {
                cs = "#ffb260";
                break;
            }
            case 8: {
                cs = "#ff6060";
                break;
            }
            default: {
                cs = "#000000";
            }
        }
        return cs;
    }

    void writeEvents(Document doc, int gen, List<EventWrapper> events, boolean isIndented, String format) {
        String indent = "";
        if (isIndented) {
            indent = "start-indent=" + (gen * 20 + 10) + "pt";
        }
        firstEventsDelimiter = true;
        if (this.reportFormat == 1 && this.displayBullet && this.reportType != 1) {
            doc.startList(format + EVENTS_DELIMITER + indent);
        }
        for (EventWrapper event : events) {
            String description = event.description;
            List<Source> sources = event.sources;
            boolean noSrc = false;
            String preSrc = " ";
            if (sources == null || sources.isEmpty()) {
                noSrc = true;
            }
            if (this.prefixEvent) {
                preSrc = " (" + event.tag + ") ";
            }
            this.writeStartNextItem(doc, this.reportFormat, this.displayBullet, !description.isEmpty(), indent);
            this.writeDescription(doc, description);
            if (!noSrc && this.srcDisplay) {
                for (Source source : sources) {
                    String sId = source.getId();
                    if (this.srcTitle) {
                        if (!this.isValidText(source)) {
                            sId = "none";
                        }
                        this.writeStartNextParagraph(doc, this.reportFormat, indent);
                        this.writeSourceWithEvent(doc, this.reportFormat, noSrc, this.prefixSource, preSrc + source.getTitle() + " (" + source.getId() + ")", gen, sId);
                    } else {
                        this.writeSourceWithEvent(doc, this.reportFormat, noSrc, " (" + this.prefixSource + preSrc + " " + source.getId() + ")", "", gen, sId);
                    }
                    if (!this.srcTextAtEvent || !this.isValidText(source)) continue;
                    this.writeSourceNotes(doc, source, format, event.tag);
                }
            }
            if (!noSrc || !this.srcDisplay || !this.displayEmpty) continue;
            if (this.displayBullet && description.length() == 0 && this.reportType != 1) {
                this.writeStartNextItem(doc, this.reportFormat, this.displayBullet, true, indent);
            } else if (this.displayBullet) {
                this.writeStartNextParagraph(doc, this.reportFormat, "");
            } else {
                this.writeStartNextParagraph(doc, this.reportFormat, indent);
            }
            this.writeSourceWithEvent(doc, this.reportFormat, noSrc, this.prefixSource, preSrc + this.translate("noSource"), 0, "");
        }
        if (this.reportFormat == 1 && this.displayBullet && this.reportType != 1) {
            doc.endList();
        }
    }

    void writeStartNextItem(Document doc, int format, boolean bullet, boolean isDescription, String style) {
        if (this.reportType == 1) {
            doc.nextTableCell();
            return;
        }
        if (!isDescription) {
            return;
        }
        if (format == 1) {
            if (bullet) {
                doc.nextListItem();
            } else {
                doc.nextParagraph(style);
            }
        } else if (firstEventsDelimiter) {
            firstEventsDelimiter = false;
            doc.addText("");
        } else {
            doc.addText(EVENTS_DELIMITER);
        }
    }

    void writeStartNextParagraph(Document doc, int format, String style) {
        if (format == 1) {
            doc.nextParagraph(style);
        } else if (firstEventsDelimiter) {
            firstEventsDelimiter = false;
            doc.addText("");
        } else {
            doc.addText(EVENTS_DELIMITER);
        }
    }

    void writeDescription(Document doc, String text) {
        if (!text.isEmpty()) {
            String end = text;
            int i = text.indexOf(BITS_DELIMITER);
            boolean normal = true;
            while (i != -1) {
                if (i != -1) {
                    normal = !normal;
                    String beg = end.substring(0, i);
                    end = end.substring(i + BITS_DELIMITER.length());
                    doc.addText(beg, normal ? "font-style=normal, color=#000000" : "font-weight=bold, font-style=normal, color=#000000");
                }
                i = end.indexOf(BITS_DELIMITER);
            }
            doc.addText(end, "font-style=normal, color=#000000");
        }
    }

    void writeSourceWithEvent(Document doc, int format, boolean noSrcFound, String linkToSourceText, String sourceTitle, int gen, String id) {
        String formatText = format == 1 ? format_multi_lines : format_one_line;
        if (noSrcFound) {
            doc.addText(linkToSourceText + sourceTitle, formatText);
            return;
        }
        if (this.srcTitle) {
            linkToSourceText = sourceTitle;
        }
        if (this.srcLinkSrc) {
            doc.addLink(linkToSourceText, "0-" + id, formatText);
        } else if (this.srcLinkGenSrc) {
            doc.addLink(linkToSourceText, gen + 1 + "-" + id, formatText);
        } else {
            doc.addText(linkToSourceText, formatText);
        }
    }

    boolean isValidText(Source source) {
        List<String> listOfNotes = GLOBAL_SRC_NOTES.get(source);
        return !listOfNotes.isEmpty();
    }

    boolean isAlreadyIn(List<String> listOfStr, String strNote) {
        return listOfStr.stream().anyMatch(str -> str.contains(strNote));
    }

    void writeSourceNotes(Document doc, Source source, String format, String tag) {
        List<String> listOfNotes = GLOBAL_SRC_NOTES.get(source);
        format = format + ",margin-left=8px,font-style=italic,color=" + source_text_color;
        for (String strNote : listOfNotes) {
            if (this.srcTextAtEvent && !strNote.contains(LOCAL_DELIMITER + tag + LOCAL_DELIMITER)) continue;
            strNote = strNote.replaceAll("#localproperty#.*#localproperty#", "");
            doc.nextParagraph(format);
            int i = strNote.indexOf(BITS_DELIMITER);
            if (i != -1) {
                String end = strNote.substring(i + BITS_DELIMITER.length());
                doc.addText(end, "font-style=normal, color=" + source_text_color);
                continue;
            }
            doc.addText(strNote);
        }
    }

    void writeSourceList(Document doc, int gen, boolean isTitle, boolean isText) {
        if (GLOBAL_SRC_LIST.isEmpty()) {
            return;
        }
        ArrayList<String> noTextSources = new ArrayList<String>();
        String format = "space-after=6pt";
        if (this.reportType == 0) {
            if (gen == -1) {
                doc.nextPage();
            }
            doc.nextParagraph("margin-left=0px,text-decoration=underline,space-before=20pt");
            if (gen == -1) {
                doc.addText("________________________________________________");
                doc.nextParagraph();
            }
            doc.addText(this.translate("sourceList"));
            doc.nextParagraph();
        }
        if (this.reportType == 2 || this.reportType == 3 || this.reportType == 1) {
            doc.nextPage();
            doc.nextParagraph("space-before=10pt");
            doc.addText("________________________________________________");
            doc.nextParagraph("space-after=10pt,space-before=10pt,text-decoration=underline");
            doc.addText(this.translate("sourceList"));
            doc.nextParagraph(format);
        }
        for (Source source : GLOBAL_SRC_LIST) {
            String sId = source.getId();
            String sTitle = source.getTitle();
            if (isTitle || isText) {
                doc.nextParagraph(format);
                doc.addAnchor(gen + 1 + "-" + sId);
                doc.addText(sTitle + " (" + sId + ")", "color=" + source_title_color);
                if (!isText || !this.isValidText(source)) continue;
                this.writeSourceNotes(doc, source, format, "");
                continue;
            }
            noTextSources.add(sId);
        }
        if (noTextSources.size() > 0) {
            doc.nextParagraph("space-after=0pt");
            doc.addAnchor(gen + 1 + "-none");
            for (String n : noTextSources) {
                doc.addText("(" + n + ") ");
            }
            doc.nextParagraph(format);
            doc.addText(this.translate("noText"));
            doc.nextParagraph(format);
        }
        GLOBAL_SRC_LIST.clear();
        GLOBAL_SRC_NOTES.clear();
    }

    protected class EventWrapper {
        public Integer julianday = 0;
        public Integer order = 0;
        public Property property = null;
        public String tag = "";
        public String description = "";
        List<Source> sources = null;

        public EventWrapper(Property property, String description, List<Source> sources, int order) {
            this.property = property;
            if (property != null) {
                this.tag = property.getTag();
                try {
                    this.julianday = ((PropertyDate)property.getProperty("DATE")).getStart().getJulianDay();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (description == null) {
                description = "";
            }
            this.description = description;
            this.sources = sources;
            this.order = order;
        }

        private int compareTo(EventWrapper e2) {
            int ret = this.julianday.compareTo(e2.julianday);
            if (ret == 0) {
                return this.order.compareTo(e2.order);
            }
            return ret;
        }
    }

    class Table
    extends BreadthFirst {
        String[] header;
        int[] widths;

        Table() {
            this.header = new String[]{"#", Gedcom.getReportName((String)"NAME"), Gedcom.getReportName((String)"BIRT"), Gedcom.getReportName((String)"BAPM"), Gedcom.getReportName((String)"MARR"), Gedcom.getReportName((String)"DEAT"), Gedcom.getReportName((String)"BURI"), Gedcom.getReportName((String)"OCCU"), Gedcom.getReportName((String)"RESI")};
            this.widths = new int[]{3, 22, 12, 10, 10, 10, 10, 10, 10};
        }

        @Override
        String getTitle(Indi root) {
            return ReportSosa.this.translate("title.sosa", new Object[]{root.getName()});
        }

        @Override
        void formatStart(Indi root, Document doc) {
            int i;
            doc.startTable("genj:csv=true,width=100%");
            for (i = 0; i < this.header.length; ++i) {
                doc.addTableColumn("column-width=" + this.widths[i] + "%");
            }
            doc.nextTableRow("background-color=#f0f0f0");
            for (i = 0; i < this.header.length; ++i) {
                if (i > 0) {
                    doc.nextTableCell("background-color=#f0f0f0");
                }
                doc.addText(this.header[i], "font-weight=bold");
            }
        }

        @Override
        void formatGeneration(int gen, Document doc) {
        }

        @Override
        void formatIndi(Indi indi, Fam fam, int gen, BigInteger sosa, PrivacyPolicy policy, Document doc) {
            if (gen < ReportSosa.this.reportMinGenerations - 1) {
                return;
            }
            List<EventWrapper> events = this.getEvents(indi, fam, policy, false, true);
            HashMap<String, ArrayList<EventWrapper>> eventMap = new HashMap<String, ArrayList<EventWrapper>>();
            for (EventWrapper event : events) {
                ArrayList<EventWrapper> tagList = (ArrayList<EventWrapper>)eventMap.get(event.tag);
                if (tagList == null) {
                    tagList = new ArrayList<EventWrapper>();
                    eventMap.put(event.tag, tagList);
                }
                tagList.add(event);
            }
            events.clear();
            HashMap eventUsages = new HashMap();
            EventUsage.init(eventUsages);
            List birtList = (List)eventMap.get("BIRT");
            if (birtList == null) {
                EventWrapper newEvent = new EventWrapper(null, "", null, ((EventUsage)eventUsages.get("BIRT")).getOrder());
                newEvent.tag = "BIRT";
                events.add(newEvent);
            } else {
                events.add(this.mergeEvents(birtList));
            }
            List bapmList = (List)eventMap.get("BAPM");
            List chrList = (List)eventMap.get("CHR");
            if (bapmList == null && chrList == null) {
                EventWrapper newEvent = new EventWrapper(null, "", null, ((EventUsage)eventUsages.get("BAPM")).getOrder());
                newEvent.tag = "BAPM";
                events.add(newEvent);
            } else {
                ArrayList<EventWrapper> bapmEvents = new ArrayList<EventWrapper>();
                if (bapmList != null) {
                    bapmEvents.addAll(bapmList);
                }
                if (chrList != null) {
                    bapmEvents.addAll(chrList);
                }
                events.add(this.mergeEvents(bapmEvents));
            }
            List marrList = (List)eventMap.get("MARR");
            if (marrList == null) {
                EventWrapper newEvent = new EventWrapper(null, "", null, ((EventUsage)eventUsages.get("MARR")).getOrder());
                newEvent.tag = "MARR";
                events.add(newEvent);
            } else {
                events.add(this.mergeEvents(marrList));
            }
            List deathList = (List)eventMap.get("DEAT");
            if (deathList == null) {
                EventWrapper newEvent = new EventWrapper(null, "", null, ((EventUsage)eventUsages.get("DEAT")).getOrder());
                newEvent.tag = "DEAT";
                events.add(newEvent);
            } else {
                events.add(this.mergeEvents(deathList));
            }
            List buriList = (List)eventMap.get("BURI");
            if (buriList == null) {
                EventWrapper newEvent = new EventWrapper(null, "", null, ((EventUsage)eventUsages.get("BURI")).getOrder());
                newEvent.tag = "BURI";
                events.add(newEvent);
            } else {
                events.add(this.mergeEvents(buriList));
            }
            List occuList = (List)eventMap.get("OCCU");
            if (occuList == null) {
                EventWrapper newEvent = new EventWrapper(null, "", null, ((EventUsage)eventUsages.get("OCCU")).getOrder());
                newEvent.tag = "OCCU";
                events.add(newEvent);
            } else {
                events.add(this.mergeEvents(occuList));
            }
            List resiList = (List)eventMap.get("RESI");
            if (resiList == null) {
                EventWrapper newEvent = new EventWrapper(null, "", null, ((EventUsage)eventUsages.get("RESI")).getOrder());
                newEvent.tag = "RESI";
                events.add(newEvent);
            } else {
                events.add(this.mergeEvents(resiList));
            }
            doc.nextTableRow();
            doc.addText("" + sosa);
            doc.nextTableCell();
            doc.addText(this.getName(indi, BigInteger.ZERO, policy));
            if (!events.isEmpty()) {
                ReportSosa.this.writeEvents(doc, gen, events, false, "margin-left=15px");
            }
        }

        private EventWrapper mergeEvents(List<EventWrapper> eventList) {
            EventWrapper result = eventList.get(0);
            for (EventWrapper event : eventList) {
                if (result.equals(event)) continue;
                result.description = result.description + ", $#@" + event.description;
            }
            return result;
        }

        @Override
        void formatEnd(Document doc) {
            doc.endTable();
            if (ReportSosa.this.srcDisplay && (ReportSosa.this.srcAtEnd || ReportSosa.this.srcTextAtEnd)) {
                ReportSosa.this.writeSourceList(doc, -1, ReportSosa.this.srcAtEnd, ReportSosa.this.srcTextAtEnd);
            }
        }
    }

    class Agnatic
    extends DepthFirst {
        Agnatic() {
        }

        @Override
        void recursion(Indi indi, Fam fam, int gen, BigInteger sosa, PrivacyPolicy policy, Document doc) {
            if (gen > ReportSosa.this.reportMaxGenerations) {
                return;
            }
            this.formatIndi(indi, fam, gen, sosa, gen < ReportSosa.this.privateGen ? PrivacyPolicy.getDefault().getAllPrivate() : PrivacyPolicy.getDefault().getAllPublic(), doc);
            Fam famc = indi.getFamilyWhereBiologicalChild();
            if (famc == null) {
                return;
            }
            Indi father = famc.getHusband();
            if (father != null) {
                this.recursion(father, famc, gen + 1, sosa.shiftLeft(1), policy, doc);
            }
        }

        @Override
        String getTitle(Indi root) {
            return ReportSosa.this.translate("title.agnatic", new Object[]{root.getName()});
        }

        @Override
        void formatStart(Indi indi, Document doc) {
        }

        @Override
        void formatIndi(Indi indi, Fam fam, int gen, BigInteger sosa, PrivacyPolicy policy, Document doc) {
            if (gen < ReportSosa.this.reportMinGenerations - 1) {
                return;
            }
            if (gen > 1 && fam != null && fam.getHusband() != indi) {
                return;
            }
            doc.nextParagraph("space-after=10pt,space-before=10pt,start-indent=" + gen * 20 + "pt");
            doc.addText(this.getName(indi, sosa, policy) + " ", "font-weight=bold");
            doc.nextParagraph("start-indent=" + (gen * 20 + 10) + "pt");
            List<EventWrapper> events = this.getEvents(indi, fam, policy, true, false);
            if (!events.isEmpty()) {
                ReportSosa.this.writeEvents(doc, gen, events, true, "");
            }
        }

        @Override
        void formatEnd(Document doc) {
            if (ReportSosa.this.srcDisplay && (ReportSosa.this.srcAtEnd || ReportSosa.this.srcTextAtEnd)) {
                ReportSosa.this.writeSourceList(doc, -1, ReportSosa.this.srcAtEnd, ReportSosa.this.srcTextAtEnd);
            }
        }
    }

    class Lineage
    extends DepthFirst {
        Lineage() {
        }

        @Override
        String getTitle(Indi root) {
            return ReportSosa.this.translate("title.lineage", new Object[]{root.getName()});
        }

        @Override
        void formatStart(Indi indi, Document doc) {
        }

        @Override
        void formatIndi(Indi indi, Fam fam, int gen, BigInteger sosa, PrivacyPolicy policy, Document doc) {
            if (gen < ReportSosa.this.reportMinGenerations - 1) {
                return;
            }
            doc.nextParagraph("space-after=10pt,space-before=10pt,start-indent=" + gen * 20 + "pt");
            doc.addText(this.getName(indi, sosa, policy) + " ", "font-weight=bold");
            doc.nextParagraph("start-indent=" + (gen * 20 + 10) + "pt");
            List<EventWrapper> events = this.getEvents(indi, fam, policy, true, false);
            if (!events.isEmpty()) {
                ReportSosa.this.writeEvents(doc, gen, events, true, "");
            }
        }

        @Override
        void formatEnd(Document doc) {
            if (ReportSosa.this.srcDisplay && (ReportSosa.this.srcAtEnd || ReportSosa.this.srcTextAtEnd)) {
                ReportSosa.this.writeSourceList(doc, -1, ReportSosa.this.srcAtEnd, ReportSosa.this.srcTextAtEnd);
            }
        }
    }

    class Sosa
    extends BreadthFirst {
        Sosa() {
        }

        @Override
        String getTitle(Indi root) {
            return ReportSosa.this.translate("title.sosa", new Object[]{root.getName()});
        }

        @Override
        void formatStart(Indi root, Document doc) {
        }

        @Override
        void formatGeneration(int gen, Document doc) {
            if (gen < ReportSosa.this.reportMinGenerations - 1) {
                return;
            }
            doc.nextParagraph("color=#ffffff");
            doc.addText(".");
            doc.nextParagraph("font-size=18pt,background-color=#f0f0f0,border-after-width=0.5pt");
            doc.addText(ReportSosa.this.translate("Generation") + " " + (gen + 1));
        }

        @Override
        void formatIndi(Indi indi, Fam fam, int gen, BigInteger sosa, PrivacyPolicy policy, Document doc) {
            if (gen < ReportSosa.this.reportMinGenerations - 1) {
                return;
            }
            doc.nextParagraph("font-weight=bold");
            doc.addText(this.getName(indi, sosa, policy));
            List<EventWrapper> events = this.getEvents(indi, fam, policy, true, false);
            if (!events.isEmpty()) {
                doc.nextParagraph("margin-left=15px");
                ReportSosa.this.writeEvents(doc, gen, events, false, "margin-left=15px");
            }
        }

        @Override
        void formatEnd(Document doc) {
            if (ReportSosa.this.srcDisplay && (ReportSosa.this.srcAtEnd || ReportSosa.this.srcTextAtEnd)) {
                ReportSosa.this.writeSourceList(doc, -1, ReportSosa.this.srcAtEnd, ReportSosa.this.srcTextAtEnd);
            }
        }
    }

    abstract class BreadthFirst
    extends Recursion {
        BreadthFirst() {
        }

        @Override
        void start(Indi indi, PrivacyPolicy policy, Document doc) {
            this.formatStart(indi, doc);
            ArrayList<Object> list = new ArrayList<Object>(3);
            list.add(ReportSosa.this.startSosa);
            list.add(indi);
            list.add(null);
            this.recursion(list, 0, policy, doc);
            this.formatEnd(doc);
        }

        void recursion(List<Object> generation, int gen, PrivacyPolicy policy, Document doc) {
            if (gen > ReportSosa.this.reportMaxGenerations) {
                return;
            }
            this.formatGeneration(gen, doc);
            ArrayList<Object> nextGeneration = new ArrayList<Object>();
            int i = 0;
            while (i < generation.size()) {
                BigInteger sosa = (BigInteger)generation.get(i++);
                Indi indi = (Indi)generation.get(i++);
                Fam fam = (Fam)generation.get(i++);
                Fam famc = indi.getFamilyWhereBiologicalChild();
                if (famc != null) {
                    Indi mother;
                    Indi father = famc.getHusband();
                    if (father != null) {
                        nextGeneration.add(sosa.shiftLeft(1));
                        nextGeneration.add(father);
                        nextGeneration.add(famc);
                    }
                    if ((mother = famc.getWife()) != null) {
                        nextGeneration.add(sosa.shiftLeft(1).add(BigInteger.ONE));
                        nextGeneration.add(mother);
                        nextGeneration.add(famc);
                    }
                }
                this.formatIndi(indi, fam, gen, sosa, gen < ReportSosa.this.privateGen ? PrivacyPolicy.getDefault().getAllPrivate() : PrivacyPolicy.getDefault().getAllPublic(), doc);
                if (!ReportSosa.this.srcTextAtEvent) continue;
                GLOBAL_SRC_LIST.clear();
                GLOBAL_SRC_NOTES.clear();
            }
            if (ReportSosa.this.srcDisplay && (ReportSosa.this.srcAtGen || ReportSosa.this.srcTextAtGen)) {
                if (gen >= ReportSosa.this.reportMinGenerations - 1) {
                    ReportSosa.this.writeSourceList(doc, gen, ReportSosa.this.srcAtGen, ReportSosa.this.srcTextAtGen);
                } else {
                    GLOBAL_SRC_LIST.clear();
                }
            }
            if (!nextGeneration.isEmpty()) {
                this.recursion(nextGeneration, gen + 1, policy, doc);
            }
        }

        abstract void formatGeneration(int var1, Document var2);
    }

    abstract class DepthFirst
    extends Recursion {
        DepthFirst() {
        }

        @Override
        void start(Indi indi, PrivacyPolicy policy, Document doc) {
            this.formatStart(indi, doc);
            this.recursion(indi, null, 0, ReportSosa.this.startSosa, policy, doc);
            this.formatEnd(doc);
        }

        void recursion(Indi indi, Fam fam, int gen, BigInteger sosa, PrivacyPolicy policy, Document doc) {
            if (gen > ReportSosa.this.reportMaxGenerations) {
                return;
            }
            this.formatIndi(indi, fam, gen, sosa, gen < ReportSosa.this.privateGen ? PrivacyPolicy.getDefault().getAllPrivate() : PrivacyPolicy.getDefault().getAllPublic(), doc);
            Fam famc = indi.getFamilyWhereBiologicalChild();
            if (famc == null) {
                return;
            }
            Indi father = famc.getHusband();
            Indi mother = famc.getWife();
            if (father == null && mother == null) {
                return;
            }
            if (father != null) {
                this.recursion(father, famc, gen + 1, sosa.shiftLeft(1), policy, doc);
            }
            if (mother != null) {
                this.recursion(mother, famc, gen + 1, sosa.shiftLeft(1).add(BigInteger.ONE), policy, doc);
            }
        }
    }

    abstract class Recursion {
        Recursion() {
        }

        abstract void start(Indi var1, PrivacyPolicy var2, Document var3);

        abstract String getTitle(Indi var1);

        abstract void formatStart(Indi var1, Document var2);

        abstract void formatIndi(Indi var1, Fam var2, int var3, BigInteger var4, PrivacyPolicy var5, Document var6);

        abstract void formatEnd(Document var1);

        String getProperty(Property prop, String prefix, boolean date, boolean place, PrivacyPolicy policy) {
            String value = prop.getValue().trim();
            Property pType = prop.getProperty("TYPE");
            if (pType != null && !pType.getValue().trim().isEmpty()) {
                if (!value.isEmpty()) {
                    value = value + " - ";
                }
                value = value + pType.getValue().trim();
            }
            value = " " + value;
            String format = (ReportSosa.this.showEventName ? Gedcom.getReportName((String)prop.getTag()) : prefix) + ReportSosa.BITS_DELIMITER + value + (date ? "{ $D}" : "") + (place && ReportSosa.this.showAllPlaceJurisdictions ? "{ $P}" : "") + (place && !ReportSosa.this.showAllPlaceJurisdictions ? "{ $p}" : "");
            if (prop.getTag().equals("RESI") && place && prop.getProperty("PLAC") == null) {
                Property pCity = prop.getPropertyByPath(".:ADDR:CITY");
                Property pCtry = prop.getPropertyByPath(".:ADDR:CTRY");
                String city = pCity != null ? pCity.getValue().trim() : "";
                String ctry = pCtry != null ? pCtry.getValue().trim() : "";
                String delim = "";
                if (!city.isEmpty() && !ctry.isEmpty()) {
                    delim = ReportSosa.EVENTS_DELIMITER;
                }
                if (!(city = city + delim + ctry).isEmpty()) {
                    format = format + " " + city;
                }
            }
            return prop.format(format, policy, true, true).trim();
        }

        List<Source> getSources(Entity entity, String tagPath) {
            ArrayList<Source> src = new ArrayList<Source>();
            for (Property p : entity.getProperties(new TagPath(tagPath))) {
                String sNote;
                Property sProp;
                String sourceText;
                if (p == null || p.toString().trim().isEmpty() || !(p instanceof PropertySource)) continue;
                PropertySource propSrc = (PropertySource)p;
                Source source = (Source)propSrc.getTargetEntity();
                src.add(source);
                GLOBAL_SRC_LIST.add(source);
                ArrayList<String> listOfNotes = (ArrayList<String>)GLOBAL_SRC_NOTES.get(source);
                ArrayList<String> listTmp = new ArrayList<String>();
                if (listOfNotes == null) {
                    listOfNotes = new ArrayList<String>();
                    GLOBAL_SRC_NOTES.put(source, listOfNotes);
                }
                if (listOfNotes.contains(entity.getDisplayTitle())) continue;
                String sText = source.getText();
                if (sText != null && !sText.trim().isEmpty() && !listOfNotes.contains(sourceText = "$#@#localproperty#" + propSrc.getParent().getTag() + ReportSosa.LOCAL_DELIMITER + " " + sText)) {
                    listTmp.add(sourceText);
                }
                if ((sProp = source.getPropertyByPath(ReportSosa.NOTE)) != null && (sNote = sProp.getValue()) != null && !sNote.trim().isEmpty()) {
                    listTmp.add(ReportSosa.BITS_DELIMITER + NbBundle.getMessage(this.getClass(), (String)"noteEntity") + ": " + sNote);
                }
                sNote = "";
                Property sProp2 = propSrc.getPropertyByPath(ReportSosa.NOTE);
                if (sProp2 != null) {
                    sNote = sProp2.getValue();
                }
                if (sNote != null && !sNote.trim().isEmpty() && !ReportSosa.this.isAlreadyIn(listOfNotes, sNote)) {
                    String pName = "";
                    if (!ReportSosa.this.srcTextAtEvent) {
                        pName = " (" + propSrc.getParent().getPropertyName() + ")";
                    }
                    listTmp.add("$#@#localproperty#" + propSrc.getParent().getTag() + ReportSosa.LOCAL_DELIMITER + NbBundle.getMessage(this.getClass(), (String)"noteCitation") + pName + ": " + sNote);
                }
                sNote = "";
                String sDate = "";
                sProp2 = propSrc.getPropertyByPath(ReportSosa.DATATEXT);
                if (sProp2 != null) {
                    sNote = sProp2.getValue();
                }
                if ((sProp2 = propSrc.getPropertyByPath(ReportSosa.DATADATE)) != null && !sProp2.getValue().isEmpty()) {
                    sDate = " " + sProp2.getValue();
                }
                if (sNote != null && !sNote.trim().isEmpty() && !ReportSosa.this.isAlreadyIn(listOfNotes, sNote)) {
                    String text = sDate.isEmpty() ? sNote : NbBundle.getMessage(this.getClass(), (String)"dataCitation") + sDate + ": " + sNote;
                    String pName = "";
                    if (!ReportSosa.this.srcTextAtEvent) {
                        pName = "(" + propSrc.getParent().getPropertyName() + ")";
                    }
                    listTmp.add("$#@#localproperty#" + propSrc.getParent().getTag() + ReportSosa.LOCAL_DELIMITER + pName + " " + text);
                }
                if (listTmp.isEmpty()) continue;
                if (ReportSosa.this.srcTextAtGen || ReportSosa.this.srcTextAtEnd) {
                    listOfNotes.add(entity.getDisplayTitle());
                }
                listOfNotes.addAll(listTmp);
            }
            return src;
        }

        String getName(Indi indi, BigInteger sosa, PrivacyPolicy privacy) {
            if (ReportSosa.this.reportIndiNumber) {
                return privacy.getDisplayValue((Property)indi, "NAME") + " (" + indi.getId() + ")" + (sosa.compareTo(BigInteger.ZERO) > 0 ? " - " + sosa : "");
            }
            return privacy.getDisplayValue((Property)indi, "NAME") + (sosa.compareTo(BigInteger.ZERO) > 0 ? " - " + sosa : "");
        }

        protected List<EventWrapper> getEvents(Indi indi, Fam fams, PrivacyPolicy privacy, boolean usePrefixes, boolean returnEmpties) {
            Fam[] families;
            String description;
            List<Object> sources;
            ArrayList<EventWrapper> ret = new ArrayList<EventWrapper>();
            HashMap eventUsages = new HashMap();
            EventUsage.init(eventUsages);
            if (ReportSosa.this.srcDisplay) {
                sources = this.getSources((Entity)indi, "INDI:SOUR");
                if (ReportSosa.this.displayEmpty || !sources.isEmpty()) {
                    ret.add(new EventWrapper(null, "", sources, 0));
                }
            }
            for (String tag : EventUsage.getTags(eventUsages, (String)"INDI")) {
                Property[] eventProps;
                for (Property property : eventProps = indi.getProperties(tag, false)) {
                    description = this.getProperty(property, usePrefixes ? this.getSymbol(tag, "") : "", true, true, privacy);
                    sources = ReportSosa.this.srcDisplay ? this.getSources((Entity)indi, "INDI:" + tag + ":SOUR") : null;
                    ret.add(new EventWrapper(property, description, sources, ((EventUsage)eventUsages.get(tag)).getOrder()));
                }
            }
            for (Fam fam : families = indi.getFamiliesWhereSpouse()) {
                for (String string : EventUsage.getTags(eventUsages, (String)"FAM")) {
                    Property[] eventProps;
                    for (Property prop : eventProps = fam.getProperties(string)) {
                        String spouseName = "";
                        description = this.getProperty(prop, usePrefixes ? this.getSymbol(string, "MARR") : "", true, true, privacy);
                        Indi otherSpouse = fam.getOtherSpouse(indi);
                        if (otherSpouse != null) {
                            spouseName = privacy.isPrivate((Property)otherSpouse) ? privacy.getPrivateMask() : otherSpouse.getName();
                        }
                        String prefix = (usePrefixes ? this.getSymbol(string, "MARR") + " " : "") + spouseName;
                        sources = ReportSosa.this.srcDisplay ? this.getSources((Entity)fam, "FAM:" + string + ":SOUR") : null;
                        ret.add(new EventWrapper(prop, description + " " + prefix, sources, ((EventUsage)eventUsages.get(string)).getOrder()));
                    }
                }
            }
            ret.sort((e1, e2) -> ((EventWrapper)e1).compareTo((EventWrapper)e2));
            return ret;
        }

        private String getSymbol(String tag, String altTag) {
            altTag = altTag.isEmpty() ? "-" : TextOptions.getInstance().getSymbol(altTag, "");
            return TextOptions.getInstance().getSymbol(tag, altTag);
        }
    }
}

