/*
 * Decompiled with CFR 0.152.
 */
package ancestris.reports.foryed;

import ancestris.core.TextOptions;
import ancestris.reports.foryed.Events;
import ancestris.reports.foryed.Filter;
import ancestris.reports.foryed.Gender;
import ancestris.reports.foryed.Images;
import ancestris.reports.foryed.Links;
import genj.gedcom.Entity;
import genj.gedcom.Fam;
import genj.gedcom.Gedcom;
import genj.gedcom.Indi;
import genj.gedcom.Property;
import genj.gedcom.PropertyEvent;
import genj.gedcom.time.Delta;
import genj.gedcom.time.PointInTime;
import genj.report.Report;
import genj.util.EnvironmentChecker;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ReportForYEd
extends Report {
    private static final Logger LOGGER = Logger.getLogger(ReportForYEd.class.getName());
    public boolean showOccupation;
    public Events events;
    public Images images;
    public Links links;
    public Filter filter;
    public Gender gender;
    private String xmlLinkContainer;
    private String xmlPopupContainer;
    private String xmlFamily;
    private String xmlIndi;
    private String xmlEdge;
    private String xmlHead;
    private String xmlTail;
    private static final String[] INDI_COLORS = ReportForYEd.createIndiColors();
    private static final TextOptions TEXT_OPTIONS = TextOptions.getInstance();
    private int edgeCount;
    private File reportFile;
    private static final PointInTime pit = new PointInTime(1, 1, 2200);

    public ReportForYEd() {
        block15: {
            this.showOccupation = true;
            this.events = new Events();
            this.images = new Images(this.translate("imageSnippetDefault"), this.translate("imageSnippetDefault"));
            this.links = new Links(this.translate("indiUrlDefault"), this.translate("familyUrlDefault"), this);
            this.filter = new Filter();
            this.gender = new Gender();
            this.xmlLinkContainer = this.getString("LinkContainer");
            this.xmlPopupContainer = this.getString("PopUpContainer");
            this.xmlFamily = this.getString("FamilyNode");
            this.xmlIndi = this.getString("IndiNode");
            this.xmlEdge = this.getString("Edge");
            this.xmlHead = this.getString("XmlHead");
            this.xmlTail = this.getString("XmlTail");
            this.edgeCount = 0;
            try {
                File xmlProperties;
                File dir = new File(EnvironmentChecker.getProperty((String)"user.home.ancestris/report", (String)"?", (String)"Looking for user directory"));
                if (!dir.exists()) {
                    dir.mkdirs();
                }
                if ((xmlProperties = new File(dir.getAbsolutePath() + "/ReportForYed.properties")).exists()) break block15;
                xmlProperties.createNewFile();
                StringBuilder sb = new StringBuilder();
                sb.append("XmlHead=").append(this.xmlHead).append('\n');
                sb.append("XmlIndi=").append(this.xmlIndi).append('\n');
                sb.append("XmlFamily=").append(this.xmlFamily).append('\n');
                sb.append("XmlEdge=").append(this.xmlEdge).append('\n');
                sb.append("XmlLinkContainer=").append(this.xmlLinkContainer).append('\n');
                sb.append("XmlPopupContainer=").append(this.xmlPopupContainer).append('\n');
                sb.append("XmlTail=").append(this.xmlTail).append('\n');
                try (FileOutputStream fw = new FileOutputStream(xmlProperties);){
                    fw.write(sb.toString().getBytes(Charset.forName("UTF-8")));
                    fw.flush();
                }
            }
            catch (IOException e) {
                LOGGER.log(Level.INFO, "Unable to work with ReportForYed.properties");
            }
        }
    }

    public String getXmlLinkContainer() {
        return this.xmlLinkContainer;
    }

    private void updateXmlContent() {
        File xmlProperties = new File(EnvironmentChecker.getProperty((String)"user.home.ancestris/report/ReportForYed.properties", (String)"?", (String)"Looking for user directory"));
        try (FileInputStream fr = new FileInputStream(xmlProperties);){
            Properties newValues = new Properties();
            newValues.load(fr);
            if (newValues.containsKey("XmlHead")) {
                this.xmlHead = newValues.getProperty("XmlHead");
            }
            if (newValues.containsKey("XmlIndi")) {
                this.xmlIndi = newValues.getProperty("XmlIndi");
            }
            if (newValues.containsKey("XmlFamily")) {
                this.xmlFamily = newValues.getProperty("XmlFamily");
            }
            if (newValues.containsKey("XmlEdge")) {
                this.xmlEdge = newValues.getProperty("XmlEdge");
            }
            if (newValues.containsKey("XmlLinkContainer")) {
                this.xmlLinkContainer = newValues.getProperty("XmlLinkContainer");
            }
            if (newValues.containsKey("XmlPopupContainer")) {
                this.xmlPopupContainer = newValues.getProperty("XmlPopupContainer");
            }
            if (newValues.containsKey("XmlTail")) {
                this.xmlTail = newValues.getProperty("XmlTail");
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.INFO, "Unable to work with ReportForYed.properties");
        }
    }

    public void start(Gedcom gedcom) throws IOException {
        String value;
        this.updateXmlContent();
        if (!this.filter.active) {
            this.generateReport(gedcom.getFamilies(), gedcom.getIndis());
            return;
        }
        HashSet<Indi> indis = new HashSet<Indi>();
        HashSet<Fam> fams = new HashSet<Fam>();
        for (Fam fam : gedcom.getFamilies()) {
            value = fam.getPropertyValue(this.filter.tag);
            if (value == null || !value.contains(this.filter.content)) continue;
            fams.add(fam);
            indis.add(fam.getHusband());
            indis.add(fam.getWife());
            if (this.filter.descendants) {
                this.collectDecendants(indis, fams, fam.getHusband());
                this.collectDecendants(indis, fams, fam.getWife());
            }
            if (!this.filter.ancestors) continue;
            this.collectAncestors(indis, fams, fam.getHusband());
            this.collectAncestors(indis, fams, fam.getWife());
        }
        for (Indi indi : gedcom.getIndis()) {
            value = indi.getPropertyValue(this.filter.tag);
            if (value == null || !value.contains(this.filter.content)) continue;
            indis.add(indi);
            for (Fam fam : indi.getFamiliesWhereSpouse()) {
                fams.add(fam);
            }
            if (this.filter.descendants) {
                this.collectDecendants(indis, fams, indi);
            }
            if (!this.filter.descendants) continue;
            this.collectAncestors(indis, fams, indi);
        }
        indis.remove(null);
        this.generateReport(fams, indis);
    }

    public void start(Indi indi) throws IOException {
        HashSet<Indi> indis = new HashSet<Indi>();
        HashSet<Fam> fams = new HashSet<Fam>();
        this.buildCollections(indi, indis, fams);
        this.generateReport(fams, indis);
    }

    public void start(Fam fam) throws IOException {
        HashSet<Indi> indis = new HashSet<Indi>();
        HashSet<Fam> fams = new HashSet<Fam>();
        this.buildCollections(fam.getHusband(), indis, fams);
        this.buildCollections(fam.getWife(), indis, fams);
        this.generateReport(fams, indis);
    }

    private void buildCollections(Indi indi, Collection<Indi> indis, Collection<Fam> fams) throws FileNotFoundException, IOException {
        this.collectAncestors(indis, fams, indi);
        this.collectDecendants(indis, fams, indi);
    }

    private void collectAncestors(Collection<Indi> indis, Collection<Fam> fams, Indi indi) {
        if (indi == null) {
            return;
        }
        indis.add(indi);
        for (Fam fam : indi.getFamiliesWhereChild()) {
            fams.add(fam);
            this.collectAncestors(indis, fams, fam.getHusband());
            this.collectAncestors(indis, fams, fam.getWife());
        }
    }

    private void collectDecendants(Collection<Indi> indis, Collection<Fam> fams, Indi indi) {
        if (indi == null) {
            return;
        }
        indis.add(indi);
        for (Fam fam : indi.getFamiliesWhereSpouse()) {
            indis.add(fam.getHusband());
            indis.add(fam.getWife());
            fams.add(fam);
            for (Indi child : fam.getChildren()) {
                this.collectDecendants(indis, fams, child);
            }
        }
    }

    private void generateReport(Collection<Fam> families, Collection<Indi> indis) throws FileNotFoundException, IOException {
        this.println(MessageFormat.format("{0} persons {1} families", indis.size(), families.size()));
        List<Indi> sortedIndis = this.sortByAge(indis);
        try (Writer out = this.createWriter();){
            if (out == null) {
                return;
            }
            this.println("creating: " + this.reportFile.getAbsoluteFile());
            out.write(this.xmlHead + "\n");
            for (Indi indi : sortedIndis) {
                out.write(this.createNode(indi) + "\n");
            }
            for (Fam fam : families) {
                out.write(this.createNode(fam) + "\n");
            }
            for (Indi indi : sortedIndis) {
                out.write(this.createIndiToFam(indi, families) + "\n");
                out.write(this.createFamToIndi(indi, families) + "\n");
            }
            out.write(this.xmlTail + "\n");
            out.flush();
        }
        this.println("ready");
    }

    private List<Indi> sortByAge(Collection<Indi> indis) {
        ArrayList<Indi> sortedIndis = new ArrayList<Indi>(indis);
        Collections.sort(sortedIndis, (i1, i2) -> {
            Delta p2;
            Delta p1 = i1.getAge(pit);
            if (p1 == (p2 = i2.getAge(pit))) {
                return 0;
            }
            if (p1 == null) {
                return 1;
            }
            if (p2 == null) {
                return -1;
            }
            return -p1.compareTo(p2);
        });
        return sortedIndis;
    }

    private static String[] createIndiColors() {
        String[] result = new String[3];
        result[1] = "#CCCCFF";
        result[2] = "#FF99CC";
        result[0] = "#CCCCCC";
        return result;
    }

    private String createIndiToFam(Indi indi, Collection<Fam> families) {
        String s = "";
        for (Fam fam : indi.getFamiliesWhereSpouse()) {
            if (!families.contains(fam)) continue;
            s = s + MessageFormat.format(this.xmlEdge, this.edgeCount++, indi.getId(), fam.getId());
        }
        return s;
    }

    private String createFamToIndi(Indi indi, Collection<Fam> families) {
        String s = "";
        for (Fam fam : indi.getFamiliesWhereChild()) {
            if (!families.contains(fam)) continue;
            s = s + MessageFormat.format(this.xmlEdge, this.edgeCount++, fam.getId(), indi.getId());
        }
        return s;
    }

    private String createNode(Fam family) {
        String id = family.getId();
        String label = this.createLabel(family);
        String height = label.contains("<html>") ? "42.0" : "27.0";
        return MessageFormat.format(this.xmlFamily, id, this.escape(label), this.links.format(id, this.links.family), this.createPopUpContainer(label), height);
    }

    private String createNode(Indi indi) {
        String id = indi.getId();
        String label = this.createLabel(indi);
        return MessageFormat.format(this.xmlIndi, id, this.escape(label), this.links.format(id, this.links.indi), INDI_COLORS[indi.getSex()], this.createPopUpContainer(label));
    }

    private String createLabel(Fam family) {
        String image = this.images.format((Entity)family, this.images.famImage);
        String mariage = this.events.format(TEXT_OPTIONS.getMarriageSymbol(), (PropertyEvent)family.getProperty("MARR"));
        String divorce = this.events.format(TEXT_OPTIONS.getDivorceSymbol(), (PropertyEvent)family.getProperty("DIV"));
        if (mariage.equals("") && divorce.equals("") && image == null) {
            return "";
        }
        String format = image != null ? "<html><table><tr><td><p>{0}<br>{1}</p></td><td>{2}</td></tr></table></body></html>" : (divorce.equals("") || mariage.equals("") ? "{0}{1}" : "<html><body>{0}<br>{1}</body></html>");
        return this.wrap(format, mariage, divorce, image);
    }

    private String createLabel(Indi indi) {
        String image = this.images.format((Entity)indi, this.images.indiImage);
        String sex = this.gender.format(indi);
        String name = indi.getPropertyDisplayValue("NAME");
        String occu = indi.getPropertyDisplayValue("OCCU");
        Property naiss = indi.getProperty("BIRT");
        if (naiss == null && TextOptions.getInstance().isUseChr()) {
            naiss = indi.getProperty("CHR");
        }
        String birth = this.events.format(TEXT_OPTIONS.getBirthSymbol(), (PropertyEvent)naiss);
        Property mort = indi.getProperty("DEAT");
        if (mort == null && TextOptions.getInstance().isUseBuri()) {
            mort = indi.getProperty("BURI");
        }
        String death = this.events.format(TEXT_OPTIONS.getDeathSymbol(), (PropertyEvent)mort);
        String format = image != null ? "<html><table><tr><td>{5}<p>{0}<br>{1}<br>{2}<br>{3}</p></td><td>{4}</td></tr></table></body></html>" : (this.showOccupation && occu != null && !occu.trim().equals("") ? "<html><body>{5}<p>{0}<br>{1}<br>{2}<br>{3}</p></body></html>" : (!birth.equals("") || !death.equals("") ? "<html><body>{5}<p>{0}<br>{1}<br>{2}</p></body></html>" : (!sex.equals("") ? "<html><body>{5}<p>{0}</p></body></html>" : "{0}")));
        return this.wrap(format, name, birth, death, occu, image, sex);
    }

    private String wrap(String format, Object ... args) {
        return MessageFormat.format(format, args).replaceAll("'", "\"");
    }

    private String escape(String content) {
        return content.replaceAll("&", "&amp;").replaceAll(">", "&gt;").replaceAll("<", "&lt;");
    }

    private String createPopUpContainer(String content) {
        if (content == null) {
            return "";
        }
        return MessageFormat.format(this.xmlPopupContainer, content);
    }

    private String getString(String key) {
        return this.getResources().getString(key);
    }

    private Writer createWriter() throws FileNotFoundException {
        String extension = "graphml";
        this.reportFile = this.getFileFromUser(this.translate("name"), this.translate("save"), true, "graphml");
        if (this.reportFile == null) {
            return null;
        }
        if (!this.reportFile.getName().toLowerCase().endsWith(".graphml")) {
            this.reportFile = new File(this.reportFile.getPath() + "." + "graphml");
        }
        FileOutputStream fileOutputStream = new FileOutputStream(this.reportFile);
        OutputStreamWriter streamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, Charset.forName("UTF8"));
        return new BufferedWriter(streamWriter);
    }
}

