/*
 * Decompiled with CFR 0.152.
 */
package ancestris.reports.calendar;

import ancestris.core.actions.AbstractAncestrisAction;
import genj.gedcom.Fam;
import genj.gedcom.Gedcom;
import genj.gedcom.Indi;
import genj.gedcom.Property;
import genj.gedcom.PropertyDate;
import genj.gedcom.PropertyPlace;
import genj.gedcom.TagPath;
import genj.gedcom.time.Delta;
import genj.gedcom.time.PointInTime;
import genj.report.Report;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import org.openide.util.Exceptions;

public class ReportCalendar
extends Report {
    private static final TagPath PATH_INDIDEATPLAC = new TagPath("INDI:DEAT:PLAC");
    public boolean output_births = true;
    public boolean output_deaths = true;
    public int assume_dead = 100;
    public boolean dead_birthdays = false;
    public int anniversary = 0;
    public String[] anniversarys = new String[]{this.translate("both_alive"), this.translate("one_alive"), this.translate("all"), this.translate("none")};
    public boolean divorce = true;
    public int year_mode = 0;
    public String[] year_modes = new String[]{this.translate("upcoming"), this.translate("generic")};
    public int hour_mode = 0;
    public String[] hour_modes = new String[]{"HH:mm", "hh:mm a", "hh-mm a", "HH-mm", "HH.mm", "hh;mm a", "HH:mm:ss", "hh:mm:ss a", "hh-mm-ss a", "HH-mm-ss", "HH.mm.ss", "hh;mm;ss a"};
    public int date_long_mode = 0;
    public String[] date_long_modes = new String[]{"dd MMMM yyyy", "dd/MM/yyyy", "MM/dd/yyyy", "MMMM dd yyyy"};
    public int max_names = 0;
    public String[] max_namess = new String[]{this.translate("nolimit"), "1", "2", "3"};
    public boolean showIDs = true;
    public boolean outputconsole = true;
    public boolean outputcsv = true;
    private static final DateTimeFormatter DATE_FORMAT = DateTimeFormatter.ofPattern("yyyyMMdd");
    private static final DateTimeFormatter HOUR_FORMAT = DateTimeFormatter.ofPattern("HHmmss");
    private static final DateTimeFormatter DATETIME_FORMATTER = DateTimeFormatter.ofPattern("yyyyMMdd'T'HHmmss");
    private final List<Event> events = new ArrayList<Event>();

    public void start(Gedcom gedcom) {
        this.report(gedcom, null);
    }

    public void start(Indi[] indis) {
        this.report(indis[0].getGedcom(), Arrays.asList(indis));
    }

    private void report(Gedcom gedcom, Collection<Indi> individuals) {
        Collection families;
        File file = this.getFileFromUser("Choose calendar file", AbstractAncestrisAction.TXT_OK, true, "ics");
        if (file == null) {
            return;
        }
        if (individuals == null || individuals.isEmpty()) {
            individuals = gedcom.getEntities("INDI");
            families = gedcom.getEntities("FAM");
        } else {
            families = this.getFamiliesFromIndis(individuals);
        }
        this.events.clear();
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8);){
            this.outputHeader(writer);
            for (Indi indi : individuals) {
                if (this.output_births) {
                    this.outputBirthday(writer, indi);
                }
                if (!this.output_deaths) continue;
                this.outputDeathAnniv(writer, indi);
            }
            for (Fam fam : families) {
                if (this.anniversary == 3) continue;
                this.outputWeddingAnniv(writer, fam);
            }
            this.outputFooter(writer);
            ((Writer)writer).close();
        }
        catch (IOException e2) {
            throw new RuntimeException(e2);
        }
        if (this.outputconsole || this.outputcsv) {
            Collections.sort(this.events, (o1, o2) -> {
                Event e1 = (Event)o1;
                Event e2 = (Event)o2;
                return e1.date.compareTo(e2.date);
            });
        }
        if (this.outputconsole) {
            this.events.forEach(e -> this.println(e));
            this.println();
            this.println("========================================");
            this.println();
        }
        this.log(this.translate("report_done") + " " + file.getAbsolutePath());
        if (this.outputcsv) {
            File filecsv = new File(file.getAbsolutePath().replace(".ics", ".csv"));
            this.csvExport(filecsv);
            this.log(this.translate("report_done") + " " + filecsv.getAbsolutePath());
        }
    }

    private Collection<Fam> getFamiliesFromIndis(Collection<Indi> individuals) {
        HashSet<Fam> fams = new HashSet<Fam>();
        for (Indi indi : individuals) {
            fams.addAll(Arrays.asList(indi.getFamiliesWhereChild()));
            fams.addAll(Arrays.asList(indi.getFamiliesWhereSpouse()));
        }
        return fams;
    }

    private void outputHeader(Writer writer) throws IOException {
        writer.write("BEGIN:VCALENDAR\r\nVERSION:2.0\r\nPRODID:Ancestris-ReportCalendar\r\n");
        this.println();
        this.println("===== " + this.translate("name") + " =====");
        this.println();
    }

    private void outputFooter(Writer writer) throws IOException {
        writer.write("END:VCALENDAR\r\n");
    }

    public void csvExport(File file) {
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8);){
            this.events.forEach(e -> {
                try {
                    writer.write(e.toString());
                    writer.write("\n");
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            });
        }
        catch (FileNotFoundException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private void outputBirthday(Writer writer, Indi indi) throws IOException {
        String birAnniv = this.translate("birthday");
        Event event = this.getDate(indi.getBirthDateOption());
        if (event == null) {
            return;
        }
        event.time = this.getTime(indi.getBirthDateOption());
        event.categorie = birAnniv;
        PropertyPlace pp = indi.getBirthPlaceOption();
        if (pp != null) {
            event.place = pp.getCity();
        }
        if (!this.dead_birthdays && !this.isAlive(indi, event.date)) {
            return;
        }
        event.firstnames = this.getFirstNames(indi);
        event.lastname = indi.getLastName() + (this.showIDs ? " (" + indi.getId() + ")" : "");
        event.type = this.translate("birth");
        event.summary = birAnniv + " : " + this.getIndiNameId(indi);
        String anniv = birAnniv + " : " + event.count + " " + this.translate("years") + "\\n\r\n ";
        if (this.year_mode == 1) {
            anniv = "";
        }
        event.description = this.getIndiNameId(indi) + "\\n\r\n " + anniv + this.translate("birth") + " : " + event.origine.format(DateTimeFormatter.ofPattern(this.date_long_modes[this.date_long_mode])) + this.getPlace(event);
        this.outputEvent(writer, event);
        this.events.add(event);
    }

    private void outputDeathAnniv(Writer writer, Indi indi) throws IOException {
        String deaAnniv = this.translate("death_anniversary");
        Event event = this.getDate(indi.getDeathDateOption());
        if (event == null) {
            return;
        }
        event.time = this.getTime(indi.getDeathDateOption());
        event.categorie = deaAnniv;
        PropertyPlace pp = indi.getDeathPlaceOption();
        if (pp != null) {
            event.place = pp.getCity();
        }
        event.firstnames = this.getFirstNames(indi);
        event.lastname = indi.getLastName() + (this.showIDs ? " (" + indi.getId() + ")" : "");
        event.type = this.translate("death");
        event.summary = deaAnniv + " : " + this.getIndiNameId(indi);
        String anniv = deaAnniv + " : " + event.count + " " + this.translate("years") + "\\n\r\n ";
        if (this.year_mode == 1) {
            anniv = "";
        }
        event.description = this.getIndiNameId(indi) + "\\n\r\n " + anniv + this.translate("death") + " : " + event.origine.format(DateTimeFormatter.ofPattern(this.date_long_modes[this.date_long_mode])) + this.getPlace(event);
        this.outputEvent(writer, event);
        this.events.add(event);
    }

    private void outputWeddingAnniv(Writer writer, Fam fam) throws IOException {
        String wedAnniv = this.translate("wedding_anniversary");
        Event event = this.getDate(fam.getMarriageDate());
        if (event == null) {
            return;
        }
        event.time = this.getTime(fam.getMarriageDate());
        event.categorie = wedAnniv;
        Property div = fam.getProperty("DIV");
        if (div != null && this.divorce) {
            return;
        }
        Indi wife = fam.getWife();
        Indi husband = fam.getHusband();
        boolean wifeDead = false;
        boolean husbandDead = false;
        if (wife != null) {
            boolean bl = wifeDead = !this.isAlive(wife, event.date);
        }
        if (husband != null) {
            boolean bl = husbandDead = !this.isAlive(husband, event.date);
        }
        if ((this.anniversary == 0 || this.anniversary == 1) && event.count > this.assume_dead - 15) {
            return;
        }
        if (this.anniversary == 0 && (wifeDead || husbandDead)) {
            return;
        }
        if (this.anniversary == 1 && wifeDead && husbandDead) {
            return;
        }
        PropertyPlace pp = fam.getMarriagePlace();
        if (pp != null) {
            event.place = pp.getCity();
        }
        event.firstnames = this.getFamFirstNames(fam);
        event.lastname = this.getFamLastNames(fam) + (this.showIDs ? " (" + fam.getId() + ")" : "");
        event.type = this.translate("wedding");
        event.summary = wedAnniv + " : " + this.getFamName(fam);
        String anniv = wedAnniv + " : " + event.count + " " + this.translate("years") + "\\n\r\n ";
        if (this.year_mode == 1) {
            anniv = "";
        }
        event.description = this.getFamName(fam) + "\\n\r\n " + anniv + this.translate("wedding") + " : " + event.origine.format(DateTimeFormatter.ofPattern(this.date_long_modes[this.date_long_mode])) + this.getPlace(event);
        this.outputEvent(writer, event);
        this.events.add(event);
    }

    private void outputEvent(Writer writer, Event event) throws IOException {
        if (this.year_mode == 0) {
            event.summary = event.count + " " + event.summary;
        }
        event.summary = event.summary.replace(",", "\\,");
        writer.write("BEGIN:VEVENT\r\n");
        try {
            MessageDigest salt = MessageDigest.getInstance("SHA-256");
            salt.update(UUID.randomUUID().toString().getBytes("UTF-8"));
            String digest = this.encodeHexString(salt.digest());
            writer.write("UID:" + digest + "\r\n");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        writer.write("DTSTAMP:" + LocalDateTime.now().format(DATETIME_FORMATTER) + "\r\n");
        writer.write("CATEGORIES:" + event.categorie + "\r\n");
        if (!"".equals(event.time)) {
            writer.write("DTSTART:" + DATE_FORMAT.format(event.date) + event.time + "\r\n");
            writer.write("DURATION:PT15M\r\n");
        } else {
            writer.write("DTSTART:" + DATE_FORMAT.format(event.date) + "\r\n");
        }
        writer.write("SUMMARY:" + event.summary + "\r\n");
        writer.write("DESCRIPTION:" + event.description + "\r\n");
        if (!"".equals(event.place)) {
            writer.write("LOCATION:" + event.place + "\r\n");
        }
        if (this.year_mode == 1) {
            writer.write("RRULE:FREQ=YEARLY\r\n");
        }
        writer.write("END:VEVENT\r\n");
    }

    private String encodeHexString(byte[] byteArray) {
        StringBuilder hexStringBuilder = new StringBuilder();
        for (int i = 0; i < byteArray.length; ++i) {
            hexStringBuilder.append(this.byteToHex(byteArray[i]));
        }
        return hexStringBuilder.toString();
    }

    private String byteToHex(byte num) {
        char[] hexDigits = new char[]{Character.forDigit(num >> 4 & 0xF, 16), Character.forDigit(num & 0xF, 16)};
        return new String(hexDigits);
    }

    private Event getDate(PropertyDate date) {
        if (date == null) {
            return null;
        }
        if (date.getFormat() != PropertyDate.DATE) {
            return null;
        }
        if (!date.getStart().isComplete()) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        Calendar now = Calendar.getInstance();
        PointInTime pit = date.getStart();
        cal.set(now.get(1), pit.getMonth(), pit.getDay() + 1);
        if (cal.before(now)) {
            cal.roll(1, true);
        }
        int count = cal.get(1) - date.getStart().getYear();
        LocalDate local = cal.getTime().toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        LocalDate origine = LocalDate.of(date.getStart().getYear(), date.getStart().getMonth() + 1, date.getStart().getDay() + 1);
        return new Event(local, origine, count);
    }

    private String getTime(PropertyDate pdate) {
        String time;
        Property[] ptime = pdate.getParent().getProperties("_TIME");
        if (ptime.length == 0) {
            return "";
        }
        try {
            DateTimeFormatter dtf = DateTimeFormatter.ofPattern(this.hour_modes[this.hour_mode]);
            LocalTime ldt = LocalTime.parse(ptime[0].getValue(), dtf);
            time = ldt.format(HOUR_FORMAT);
        }
        catch (DateTimeParseException e) {
            return "";
        }
        if ("".equals(time)) {
            return "";
        }
        return "T" + time;
    }

    private String getPlace(Event event) {
        if ("".equals(event.place)) {
            return "";
        }
        return " ( " + event.place + " )";
    }

    private String getIndiNameId(Indi indi) {
        return (this.getIndiName(indi) + (this.showIDs ? " (" + indi.getId() + ")" : "")).trim();
    }

    private String getIndiName(Indi indi) {
        return (this.getFirstNames(indi) + " " + indi.getLastName()).trim();
    }

    private String getFamName(Fam fam) {
        String id;
        Indi wife = fam.getWife();
        Indi husband = fam.getHusband();
        String string = id = this.showIDs ? " (" + fam.getId() + ")" : "";
        if (wife == null && husband == null) {
            return id;
        }
        if (wife == null) {
            return this.getIndiName(husband) + " + " + this.translate("wife") + id;
        }
        if (husband == null) {
            return this.getIndiName(wife) + " + " + this.translate("husband") + id;
        }
        return this.getFirstNames(wife) + " + " + this.getIndiName(husband) + id;
    }

    private String getFamFirstNames(Fam fam) {
        Indi wife = fam.getWife();
        Indi husband = fam.getHusband();
        if (wife == null && husband == null) {
            return "";
        }
        if (wife == null) {
            return this.getFirstNames(husband);
        }
        if (husband == null) {
            return this.getFirstNames(wife);
        }
        return this.getFirstNames(husband) + " + " + this.getFirstNames(wife);
    }

    private String getFamLastNames(Fam fam) {
        Indi wife = fam.getWife();
        Indi husband = fam.getHusband();
        if (wife == null && husband == null) {
            return "";
        }
        if (wife == null) {
            return husband.getLastName();
        }
        if (husband == null) {
            return wife.getFirstName();
        }
        return husband.getLastName() + " + " + wife.getLastName();
    }

    private String getFirstNames(Indi indi) {
        String firstName = indi.getFirstName();
        if (this.max_names <= 0) {
            return firstName;
        }
        if (firstName.trim().equals("")) {
            return "";
        }
        String[] names = firstName.split("  *");
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.max_names && i < names.length; ++i) {
            sb.append(names[i]).append(" ");
        }
        return sb.substring(0, sb.length() - 1);
    }

    private boolean isAlive(Indi indi, LocalDate date) {
        if (indi.getDeathDate() != null || indi.getProperty(PATH_INDIDEATPLAC) != null) {
            return false;
        }
        if (this.assume_dead == 0) {
            return true;
        }
        PropertyDate birth = indi.getBirthDate();
        if (birth == null) {
            return true;
        }
        int d = date.getDayOfMonth();
        Delta delta = birth.getAnniversary(new PointInTime(d - 1, date.getMonthValue() - 1, date.getYear()));
        if (delta == null) {
            return true;
        }
        return delta.getYears() < this.assume_dead;
    }

    private static class Event {
        public LocalDate date;
        public LocalDate origine;
        public int count;
        public String categorie;
        public String firstnames;
        public String lastname;
        public String type;
        public String summary;
        public String place = "";
        public String time = "";
        public String description = "";

        public Event(LocalDate date, LocalDate origine, int count) {
            this.date = date;
            this.origine = origine;
            this.count = count;
        }

        public String toString() {
            return this.date.toString() + "\t" + this.strFill("" + this.count, 5) + "\t" + this.strFill(this.type, 10) + "\t" + this.origine.toString() + "\t" + this.strFill(this.firstnames, 40) + "\t" + this.lastname;
        }

        private String strFill(String str, int len) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < len; ++i) {
                sb.append(' ');
            }
            int l = Math.min(len, str.length());
            return str.substring(0, l) + sb.substring(l);
        }
    }
}

