/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.geo.renderer;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import org.jxmapviewer.JXMapViewer;
import org.jxmapviewer.viewer.DefaultWaypointRenderer;
import org.jxmapviewer.viewer.Waypoint;

public class NoNameWaypointRenderer
extends DefaultWaypointRenderer {
    private int markersSize;
    private Color markersColor;

    public NoNameWaypointRenderer(int size, Color couleur) {
        this.markersSize = size;
        this.markersColor = couleur;
    }

    public NoNameWaypointRenderer() {
        this(10, Color.BLUE);
    }

    public void paintWaypoint(Graphics2D g, JXMapViewer map, Waypoint wp) {
        Point2D point = map.getTileFactory().geoToPixel(wp.getPosition(), map.getZoom());
        int x = Long.valueOf(Math.round(point.getX())).intValue();
        int y = Long.valueOf(Math.round(point.getY())).intValue();
        g.setStroke(new BasicStroke((int)((double)this.markersSize / 8.0 + 1.0)));
        g.setColor(this.markersColor);
        g.drawOval(x - this.markersSize, y - this.markersSize, 2 * this.markersSize, 2 * this.markersSize);
        g.setStroke(new BasicStroke(1.0f));
        g.drawLine(x - this.markersSize, y, x + this.markersSize, y);
        g.drawLine(x, y - this.markersSize, x, y + this.markersSize);
    }
}

