/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.flashlist;

import ancestris.modules.flashlist.FlashListPanel;
import ancestris.util.swing.DialogManager;
import genj.fo.Document;
import genj.gedcom.Fam;
import genj.gedcom.Gedcom;
import genj.gedcom.Indi;
import genj.gedcom.Property;
import genj.gedcom.PropertyDate;
import genj.gedcom.PropertyPlace;
import genj.gedcom.TagPath;
import genj.gedcom.time.Calendar;
import genj.gedcom.time.PointInTime;
import genj.report.Report;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import org.openide.util.NbBundle;

public class ReportFlashList
extends Report {
    private static final Logger LOG = Logger.getLogger("ReportFlashList");
    private static final TagPath CITY = new TagPath(".:ADDR:CITY");
    private static final String FORMAT_LNORMAL = "font-weight=normal,text-align=left";
    private static final String FORMAT_CNORMAL = "font-weight=normal,text-align=center";
    private static final String FORMAT_RNORMAL = "font-weight=normal,text-align=right";
    private static final String FORMAT_LSTRONG = "font-weight=bold,text-align=left";
    private static final String FORMAT_CSTRONG = "font-weight=bold,text-align=center";
    private static final String FORMAT_RSTRONG = "font-weight=bold,text-align=right";
    private static final String FORMAT_CBACKGROUND = "background-color=#ffffcc,font-weight=bold,text-align=center";
    private static final String FORMAT_RBACKGROUND = "background-color=#ffffcc,font-weight=bold,text-align=right";
    FlashListPanel flashListOptions = null;
    private static final int LEGEND_NO = 0;
    private static final int LEGEND_TOP = 1;
    private static final int LEGEND_BOT = 2;
    private boolean existPLACTag = true;
    private static final int LOC12_SURN_LOC34 = 0;
    private static final int LOC12_LOC34_SURN = 1;
    private static final int SURN_LOC12_LOC34 = 2;
    private int recordKey = 0;
    private int posLoc1 = 0;
    private int posLoc2 = 2;
    private int posLoc3 = 4;
    private int posLoc4 = 4;
    public String filterKey1 = "";
    public String filterKey2 = "";
    public String filterKey3 = "";

    public Document start(Gedcom gedcom, String documentName) {
        boolean repeatHeader;
        if (!this.getFlashOptions(gedcom)) {
            return null;
        }
        boolean repeatKeys = this.flashListOptions.getRepeatKeys();
        boolean displayZeros = this.flashListOptions.getDisplayZeros();
        this.existPLACTag = this.flashListOptions.existPlaceTag();
        this.recordKey = this.flashListOptions.getRecordKey();
        this.posLoc1 = this.flashListOptions.getPosLoc(1);
        this.posLoc2 = this.flashListOptions.getPosLoc(2);
        this.posLoc3 = this.flashListOptions.getPosLoc(3);
        this.posLoc4 = this.flashListOptions.getPosLoc(4);
        int nbEvents = this.flashListOptions.getNbEvents();
        int yearSpan = this.flashListOptions.getYearSpan();
        int minSosa = this.flashListOptions.getMinSosa();
        this.filterKey1 = this.flashListOptions.getFilter1();
        this.filterKey2 = this.flashListOptions.getFilter2();
        this.filterKey3 = this.flashListOptions.getFilter3();
        Collection indis = gedcom.getEntities("INDI");
        TreeMap<String, Object> primary = new TreeMap<String, Object>();
        LOG.log(Level.INFO, NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"ReportFlashList.StartingAnalysis"));
        Iterator it = indis.iterator();
        while (it.hasNext()) {
            this.analyze((Indi)it.next(), primary, this.flashListOptions.getRootIndi());
        }
        LOG.log(Level.INFO, NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"ReportFlashList.NowWriting"));
        Document doc = new Document(documentName);
        if (this.flashListOptions.getTOC()) {
            doc.addTOC();
            if (primary.size() > 10) {
                doc.nextPage();
            }
        }
        if (this.flashListOptions.getDisplayLegend() == 1) {
            this.displayLegend(doc);
        }
        if (!(repeatHeader = this.flashListOptions.getRepeatHeader())) {
            this.displayHeader(doc, null, true);
            doc.endTable();
        }
        for (String p : primary.keySet()) {
            doc.startSection(p, p.replaceAll(" ", "%").replaceAll("/", "%").replaceAll(",", "%"));
            this.displayHeader(doc, p, repeatHeader);
            String secondaryKey = "";
            Map secondary = (Map)this.lookup(primary, p, null);
            for (String s : secondary.keySet()) {
                Map tertiary = (Map)this.lookup(secondary, s, null);
                for (String t : tertiary.keySet()) {
                    Range range = (Range)this.lookup(tertiary, t, null);
                    String lformat = FORMAT_LNORMAL;
                    String cformat = FORMAT_CNORMAL;
                    String rformat = FORMAT_RNORMAL;
                    if (range.getNbEvents() >= nbEvents || range.getYearSpan() >= yearSpan || range.getValueSosa() >= minSosa) {
                        lformat = FORMAT_LSTRONG;
                        cformat = FORMAT_CSTRONG;
                        rformat = FORMAT_RSTRONG;
                    }
                    doc.nextTableRow(lformat);
                    if (repeatKeys || !secondaryKey.equals(s)) {
                        doc.addText(s);
                    } else {
                        doc.addText(" ");
                    }
                    if (!secondaryKey.equals(s)) {
                        secondaryKey = s;
                    }
                    doc.nextTableCell(lformat);
                    doc.addText(t);
                    doc.nextTableCell(rformat);
                    doc.addText(!displayZeros && range.nbSosa == 0 ? "-" : range.getNbSosa());
                    doc.nextTableCell(rformat);
                    doc.addText(!displayZeros && range.nbBirth == 0 ? "-" : range.getNbBirth());
                    doc.nextTableCell(rformat);
                    doc.addText(!displayZeros && range.nbChris == 0 ? "-" : range.getNbChris());
                    doc.nextTableCell(rformat);
                    doc.addText(!displayZeros && range.nbMarr == 0 ? "-" : range.getNbMarr());
                    doc.nextTableCell(rformat);
                    doc.addText(!displayZeros && range.nbDeath == 0 ? "-" : range.getNbDeath());
                    doc.nextTableCell(rformat);
                    doc.addText(!displayZeros && range.nbOther == 0 ? "-" : range.getNbOther());
                    doc.nextTableCell(cformat);
                    doc.addText(range.getFirst());
                    doc.nextTableCell(cformat);
                    doc.addText(range.getLast());
                }
            }
            doc.endTable();
        }
        if (this.flashListOptions.getDisplayLegend() == 2) {
            this.displayLegend(doc);
        }
        LOG.log(Level.INFO, NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"ReportFlashList.Completed"));
        return doc;
    }

    private boolean getFlashOptions(Gedcom gedcom) {
        this.flashListOptions = new FlashListPanel(gedcom);
        Object choice = DialogManager.create((String)NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"FlashListPanel.title"), (JComponent)this.flashListOptions).setMessageType(-1).setOptionType(2).setDialogId("flashListWindow").show();
        if (choice == DialogManager.CANCEL_OPTION) {
            return false;
        }
        this.flashListOptions.store();
        return true;
    }

    private void displayLegend(Document doc) {
        doc.addText(" ");
        doc.nextParagraph();
        doc.addText(" ");
        doc.nextParagraph();
        doc.addText(" ");
        doc.nextParagraph();
        doc.addText(" ");
        doc.nextParagraph();
        doc.startSection(NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"ReportFlashList.legendText"), "legend");
        doc.addText(" ");
        doc.nextParagraph();
        doc.addText(NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"ReportFlashList.legendS"));
        doc.nextParagraph();
        doc.addText(NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"ReportFlashList.legendB"));
        doc.nextParagraph();
        doc.addText(NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"ReportFlashList.legendC"));
        doc.nextParagraph();
        doc.addText(NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"ReportFlashList.legendM"));
        doc.nextParagraph();
        doc.addText(NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"ReportFlashList.legendD"));
        doc.nextParagraph();
        doc.addText(NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"ReportFlashList.legendO"));
        doc.nextParagraph();
        doc.addText(NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"ReportFlashList.legendMin"));
        doc.nextParagraph();
        doc.addText(NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"ReportFlashList.legendMax"));
        doc.addText(" ");
        doc.nextParagraph();
        doc.addText(" ");
        doc.nextParagraph();
        doc.addText(" ");
        doc.nextParagraph();
        doc.addText(" ");
        doc.nextParagraph();
    }

    private void displayHeader(Document doc, String name, boolean dHeader) {
        if (name != null) {
            doc.startTable("genj:csv=true,genj:csvprefix=" + name + ",width=100%");
        } else {
            doc.startTable("width=100%");
        }
        doc.addTableColumn("column-width=30%");
        doc.addTableColumn("column-width=23%");
        doc.addTableColumn("column-width=5%");
        doc.addTableColumn("column-width=5%");
        doc.addTableColumn("column-width=5%");
        doc.addTableColumn("column-width=5%");
        doc.addTableColumn("column-width=5%");
        doc.addTableColumn("column-width=5%");
        doc.addTableColumn("column-width=10%");
        doc.addTableColumn("column-width=7%");
        if (dHeader) {
            doc.nextTableRow();
            doc.addText(" ");
            doc.nextTableCell();
            doc.addText(" ");
            doc.nextTableCell(FORMAT_RBACKGROUND);
            doc.addText(NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"ReportFlashList.colS"));
            doc.nextTableCell(FORMAT_RBACKGROUND);
            doc.addText(NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"ReportFlashList.colB"));
            doc.nextTableCell(FORMAT_RBACKGROUND);
            doc.addText(NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"ReportFlashList.colC"));
            doc.nextTableCell(FORMAT_RBACKGROUND);
            doc.addText(NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"ReportFlashList.colM"));
            doc.nextTableCell(FORMAT_RBACKGROUND);
            doc.addText(NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"ReportFlashList.colD"));
            doc.nextTableCell(FORMAT_RBACKGROUND);
            doc.addText(NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"ReportFlashList.colO"));
            doc.nextTableCell(FORMAT_CBACKGROUND);
            doc.addText(NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"ReportFlashList.colMin"));
            doc.nextTableCell(FORMAT_CBACKGROUND);
            doc.addText(NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"ReportFlashList.colMax"));
        }
    }

    private void analyze(Indi indi, Map<String, Object> primary, Indi indiDeCujus) {
        String name = indi.getLastName();
        if (name.length() == 0) {
            return;
        }
        name = name.trim();
        boolean isSosa = indi.isAncestorOf(indiDeCujus);
        if (indi == indiDeCujus) {
            isSosa = true;
        }
        try {
            for (PropertyDate date : indi.getProperties(PropertyDate.class)) {
                int end;
                if (!date.isValid()) continue;
                int start = 0;
                start = date.getStart().getPointInTime((Calendar)PointInTime.GREGORIAN).getYear();
                int n = end = date.isRange() ? date.getEnd().getPointInTime((Calendar)PointInTime.GREGORIAN).getYear() : start;
                if (start > end) continue;
                this.analyzePlaces(name, start, end, date.getParent(), primary, isSosa);
                this.analyzeCities(name, start, end, date.getParent(), primary, isSosa);
            }
            for (Fam family : Arrays.asList(indi.getFamiliesWhereSpouse())) {
                for (PropertyDate date : family.getProperties(PropertyDate.class)) {
                    int end;
                    if (!date.isValid()) continue;
                    int start = date.getStart().getPointInTime((Calendar)PointInTime.GREGORIAN).getYear();
                    int n = end = date.isRange() ? date.getEnd().getPointInTime((Calendar)PointInTime.GREGORIAN).getYear() : start;
                    if (start > end) continue;
                    this.analyzePlaces(name, start, end, date.getParent(), primary, isSosa);
                    this.analyzeCities(name, start, end, date.getParent(), primary, isSosa);
                }
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private void analyzeCities(String name, int start, int end, Property prop, Map<String, Object> primary, boolean isSosa) {
        if (!this.isEvent(prop)) {
            return;
        }
        Property[] cities = prop.getProperties(CITY);
        for (int c = 0; c < cities.length; ++c) {
            String loc1 = cities[c].getDisplayValue().trim();
            if (loc1.length() == 0) continue;
            String loc2 = "";
            String loc3 = "";
            String loc4 = "";
            if (this.existPLACTag) {
                loc2 = "-";
                loc3 = "-";
                loc4 = "-";
            }
            this.keep(loc1, loc2, loc3, loc4, name, start, end, primary, prop, isSosa);
        }
    }

    private void analyzePlaces(String name, int start, int end, Property prop, Map<String, Object> primary, boolean isSosa) {
        if (!this.isEvent(prop)) {
            return;
        }
        for (PropertyPlace place : prop.getProperties(PropertyPlace.class)) {
            String loc1 = "";
            String loc2 = "";
            String loc3 = "";
            String loc4 = "";
            if (this.existPLACTag) {
                loc1 = place.getJurisdiction(this.posLoc1);
                loc2 = place.getJurisdiction(this.posLoc2);
                loc3 = place.getJurisdiction(this.posLoc3);
                loc4 = place.getJurisdiction(this.posLoc4);
                if (loc1 != null) {
                    loc1 = loc1.trim();
                }
                if (loc2 != null) {
                    loc2 = loc2.trim();
                }
                if (loc3 != null) {
                    loc3 = loc3.trim();
                }
                if (loc4 != null) {
                    loc4 = loc4.trim();
                }
                if (loc1 == null || loc1.length() == 0) {
                    loc1 = "-";
                }
                if (loc2 == null || loc2.length() == 0) {
                    loc2 = "-";
                }
                if (loc3 == null || loc3.length() == 0) {
                    loc3 = "-";
                }
                if (loc4 == null || loc4.length() == 0) {
                    loc4 = "-";
                }
                if (loc1 == "-" && loc2 == "-" && loc3 == "-" && loc4 == "-") {
                    continue;
                }
            } else {
                loc1 = place.getFirstAvailableJurisdiction().trim();
                if (loc1.length() == 0) continue;
            }
            this.keep(loc1, loc2, loc3, loc4, name, start, end, primary, prop, isSosa);
        }
    }

    private boolean isEvent(Property prop) {
        String[] strTable = new String[]{"ADOP", "ANUL", "BIRT", "BAPM", "BARM", "BASM", "BLES", "BURI", "CENS", "CHR", "CHRA", "CONF", "CREM", "DEAT", "DIV", "DIVF", "EMIG", "ENGA", "EVEN", "FCOM", "GRAD", "IMMI", "MARR", "MARB", "MARC", "MARL", "MARS", "NATU", "ORDN", "RETI", "PROB", "WILL"};
        List<String> listOfEvents = Arrays.asList(strTable);
        return listOfEvents.contains(prop.getTag());
    }

    private void keep(String loc1, String loc2, String loc3, String loc4, String name, int start, int end, Map<String, Object> primary, Property prop, boolean isSosa) {
        String ts;
        String ss;
        String ps;
        switch (this.recordKey) {
            case 0: {
                ps = loc1 + (loc2.isEmpty() ? "" : "/" + loc2);
                ss = name;
                ts = loc3 + (loc4.isEmpty() ? "" : "/" + loc4);
                break;
            }
            case 1: {
                ps = loc1 + (loc2.isEmpty() ? "" : "/" + loc2);
                ss = loc3 + (loc4.isEmpty() ? "" : "/" + loc4);
                ts = name;
                break;
            }
            case 2: {
                ps = name;
                ss = loc1 + (loc2.isEmpty() ? "" : "/" + loc2);
                ts = loc3 + (loc4.isEmpty() ? "" : "/" + loc4);
                break;
            }
            default: {
                throw new IllegalArgumentException("no such report type");
            }
        }
        if (!this.filterKey1.trim().isEmpty() && !ps.toUpperCase().contains(this.filterKey1.toUpperCase())) {
            return;
        }
        if (!this.filterKey2.trim().isEmpty() && !ss.toUpperCase().contains(this.filterKey2.toUpperCase())) {
            return;
        }
        if (!this.filterKey3.trim().isEmpty() && !ts.toUpperCase().contains(this.filterKey3.toUpperCase())) {
            return;
        }
        if (!this.existPLACTag) {
            ts = "";
        }
        Map secondary = (Map)this.lookup(primary, ps, TreeMap.class);
        Map tertiary = (Map)this.lookup(secondary, ss, TreeMap.class);
        Range range = (Range)this.lookup(tertiary, ts, Range.class);
        range.add(start, end, isSosa, prop.getTag());
    }

    private Object lookup(Map<String, Object> index, String key, Class<? extends Object> fallback) {
        Object result = index.get(key);
        if (result == null) {
            try {
                result = fallback.newInstance();
            }
            catch (Throwable t) {
                t.printStackTrace();
                throw new IllegalArgumentException("can't instantiate fallback " + fallback);
            }
            index.put(key, result);
        }
        return result;
    }

    static class Range {
        int firstYear = Integer.MAX_VALUE;
        int lastYear = -2147483647;
        int nbSosa = 0;
        int nbBirth = 0;
        int nbChris = 0;
        int nbMarr = 0;
        int nbDeath = 0;
        int nbOther = 0;
        double geoLat = 0.0;
        double geoLon = 0.0;

        Range() {
        }

        void add(int start, int end, boolean isSosa, String tag) {
            if (start != Integer.MAX_VALUE) {
                this.firstYear = Math.min(this.firstYear, start);
            }
            if (end != Integer.MAX_VALUE) {
                this.lastYear = Math.max(this.lastYear, end);
            }
            if (isSosa) {
                ++this.nbSosa;
            }
            if (tag == "BIRT") {
                ++this.nbBirth;
            } else if (tag == "CHR") {
                ++this.nbChris;
            } else if (tag == "MARR") {
                ++this.nbMarr;
            } else if (tag == "DEAT") {
                ++this.nbDeath;
            } else {
                ++this.nbOther;
            }
        }

        void add(Range rangeElt) {
            this.firstYear = Math.min(this.firstYear, rangeElt.getValueFirst());
            this.lastYear = Math.max(this.lastYear, rangeElt.getValueLast());
            this.nbSosa += rangeElt.getValueSosa();
            this.nbBirth += rangeElt.getValueBirth();
            this.nbChris += rangeElt.getValueChris();
            this.nbMarr += rangeElt.getValueMarr();
            this.nbDeath += rangeElt.getValueDeath();
            this.nbOther += rangeElt.getValueOther();
        }

        void setGeo(double lat, double lon) {
            this.geoLat = lat;
            this.geoLon = lon;
        }

        String getFirst() {
            if (this.firstYear == Integer.MAX_VALUE || this.lastYear == Integer.MAX_VALUE) {
                return "";
            }
            return Integer.toString(this.firstYear);
        }

        String getLast() {
            return Integer.toString(this.lastYear);
        }

        String getNbSosa() {
            return Integer.toString(this.nbSosa);
        }

        String getNbBirth() {
            return Integer.toString(this.nbBirth);
        }

        String getNbChris() {
            return Integer.toString(this.nbChris);
        }

        String getNbMarr() {
            return Integer.toString(this.nbMarr);
        }

        String getNbDeath() {
            return Integer.toString(this.nbDeath);
        }

        String getNbOther() {
            return Integer.toString(this.nbOther);
        }

        int getNbEvents() {
            return this.nbBirth + this.nbChris + this.nbMarr + this.nbDeath + this.nbOther;
        }

        int getYearSpan() {
            return this.lastYear - this.firstYear;
        }

        int getValueFirst() {
            return this.firstYear;
        }

        int getValueLast() {
            return this.lastYear;
        }

        int getValueSosa() {
            return this.nbSosa;
        }

        int getValueBirth() {
            return this.nbBirth;
        }

        int getValueChris() {
            return this.nbChris;
        }

        int getValueMarr() {
            return this.nbMarr;
        }

        int getValueDeath() {
            return this.nbDeath;
        }

        int getValueOther() {
            return this.nbOther;
        }

        double getValueLat() {
            return this.geoLat;
        }

        double getValueLon() {
            return this.geoLon;
        }
    }
}

