/*
 * Decompiled with CFR 0.152.
 */
package ancestris.app;

import ancestris.gedcom.GedcomDirectory;
import ancestris.util.swing.DialogManager;
import genj.gedcom.Context;
import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomConstants;
import genj.gedcom.GedcomException;
import genj.gedcom.GedcomOptions;
import genj.gedcom.Grammar;
import genj.gedcom.Indi;
import genj.gedcom.Submitter;
import genj.gedcom.TagPath;
import java.awt.Dimension;
import java.awt.Font;
import java.util.Date;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.openide.awt.Mnemonics;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public final class NewGedcomPanel
extends JPanel
implements DocumentListener {
    private Gedcom gedcom;
    private JButton confirmButton = new JButton(NbBundle.getMessage(this.getClass(), (String)"OK_button"));
    private ButtonGroup buttonGroup1;
    private JLabel femaleIconeLabel;
    private JRadioButton femaleRadioButton;
    private JLabel firstnameLabel;
    private JTextField firstnameTextField;
    private JLabel iconLabel;
    private JLabel lastnameLabel;
    private JTextField lastnameTextField;
    private JLabel maleIconLabel;
    private JRadioButton maleRadioButton;
    private JLabel noticeLabel;
    private JLabel sexLabel;

    public NewGedcomPanel() {
        this.initComponents();
        this.updateButtons();
        this.firstnameTextField.getDocument().addDocumentListener(this);
        this.lastnameTextField.getDocument().addDocumentListener(this);
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.iconLabel = new JLabel();
        this.noticeLabel = new JLabel();
        this.firstnameLabel = new JLabel();
        this.firstnameTextField = new JTextField();
        this.lastnameLabel = new JLabel();
        this.lastnameTextField = new JTextField();
        this.sexLabel = new JLabel();
        this.maleRadioButton = new JRadioButton();
        this.femaleRadioButton = new JRadioButton();
        this.maleIconLabel = new JLabel();
        this.femaleIconeLabel = new JLabel();
        this.setBorder(null);
        this.setMinimumSize(new Dimension(420, 290));
        this.iconLabel.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/view/images/New24.png")));
        Mnemonics.setLocalizedText((JLabel)this.iconLabel, (String)NbBundle.getMessage(NewGedcomPanel.class, (String)"NewGedcomPanel.iconLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.noticeLabel, (String)NbBundle.getMessage(NewGedcomPanel.class, (String)"NewGedcomPanel.noticeLabel.text"));
        this.noticeLabel.setVerticalAlignment(1);
        this.firstnameLabel.setFont(new Font("DejaVu Sans", 1, 12));
        Mnemonics.setLocalizedText((JLabel)this.firstnameLabel, (String)NbBundle.getMessage(NewGedcomPanel.class, (String)"NewGedcomPanel.firstnameLabel.text"));
        this.firstnameTextField.setText(NbBundle.getMessage(NewGedcomPanel.class, (String)"NewGedcomPanel.firstnameTextField.text"));
        this.lastnameLabel.setFont(new Font("DejaVu Sans", 1, 12));
        Mnemonics.setLocalizedText((JLabel)this.lastnameLabel, (String)NbBundle.getMessage(NewGedcomPanel.class, (String)"NewGedcomPanel.lastnameLabel.text"));
        this.lastnameTextField.setText(NbBundle.getMessage(NewGedcomPanel.class, (String)"NewGedcomPanel.lastnameTextField.text"));
        this.sexLabel.setFont(new Font("DejaVu Sans", 1, 12));
        Mnemonics.setLocalizedText((JLabel)this.sexLabel, (String)NbBundle.getMessage(NewGedcomPanel.class, (String)"NewGedcomPanel.sexLabel.text"));
        this.buttonGroup1.add(this.maleRadioButton);
        this.maleRadioButton.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.maleRadioButton, (String)NbBundle.getMessage(NewGedcomPanel.class, (String)"NewGedcomPanel.maleRadioButton.text"));
        this.buttonGroup1.add(this.femaleRadioButton);
        Mnemonics.setLocalizedText((AbstractButton)this.femaleRadioButton, (String)NbBundle.getMessage(NewGedcomPanel.class, (String)"NewGedcomPanel.femaleRadioButton.text"));
        this.maleIconLabel.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/app/Male.png")));
        Mnemonics.setLocalizedText((JLabel)this.maleIconLabel, (String)NbBundle.getMessage(NewGedcomPanel.class, (String)"NewGedcomPanel.maleIconLabel.text"));
        this.femaleIconeLabel.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/app/Female.png")));
        Mnemonics.setLocalizedText((JLabel)this.femaleIconeLabel, (String)NbBundle.getMessage(NewGedcomPanel.class, (String)"NewGedcomPanel.femaleIconeLabel.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(30, 30, 30).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.sexLabel, -1, -1, Short.MAX_VALUE).addComponent(this.lastnameLabel, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGap(1, 1, 1).addComponent(this.firstnameLabel))).addGap(12, 12, 12).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.firstnameTextField, -1, 236, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.maleRadioButton).addComponent(this.maleIconLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.femaleRadioButton).addComponent(this.femaleIconeLabel)).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.lastnameTextField)).addGap(71, 71, 71)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(20, 20, 20).addComponent(this.iconLabel).addGap(12, 12, 12).addComponent(this.noticeLabel, -2, 0, Short.MAX_VALUE).addGap(15, 15, 15)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(14, 14, 14).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.noticeLabel, -2, 117, -2).addComponent(this.iconLabel)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.firstnameLabel).addComponent(this.firstnameTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lastnameLabel).addComponent(this.lastnameTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.sexLabel).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.maleRadioButton).addComponent(this.femaleRadioButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.femaleIconeLabel).addComponent(this.maleIconLabel)))).addContainerGap(28, Short.MAX_VALUE)));
    }

    public String getFirstName() {
        return this.firstnameTextField.getText().trim();
    }

    public String getLastName() {
        return this.lastnameTextField.getText().trim();
    }

    public Boolean getSex() {
        return this.maleRadioButton.isSelected();
    }

    public void setFirstNameFocus() {
        this.firstnameTextField.requestFocusInWindow();
    }

    public void setLastNameFocus() {
        this.lastnameTextField.requestFocusInWindow();
    }

    private void updateButtons() {
        this.confirmButton.setEnabled(!this.getFirstName().isEmpty() && !this.getLastName().isEmpty());
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.updateButtons();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.updateButtons();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.updateButtons();
    }

    public void execute() {
        Object o = DialogManager.create((String)NbBundle.getMessage(this.getClass(), (String)"CTL_ActionNew").replaceAll("&", ""), (JComponent)this).setMessageType(-1).setOptions(new Object[]{this.confirmButton, DialogManager.CANCEL_OPTION}).setDialogId("newGedcomAction").show();
        if (o == this.confirmButton) {
            this.commit();
        }
    }

    public void commit() {
        try {
            this.gedcom = new Gedcom();
            Entity header = this.gedcom.createEntity("HEAD", "");
            Submitter submitter = (Submitter)this.gedcom.createEntity("SUBM");
            this.gedcom.setSubmitter(submitter);
            this.gedcom.setEncoding(GedcomConstants.Encodings.UTF8);
            this.gedcom.setGrammar(Grammar.V551);
            this.gedcom.setPlaceFormat(GedcomOptions.getInstance().getPlaceFormat());
            header.setValue(new TagPath(".:NOTE"), NbBundle.getMessage(NewGedcomPanel.class, (String)"NewGedcomPanel.headerNote", (Object)new Date()));
            Indi firstIndi = (Indi)this.gedcom.createEntity("INDI");
            firstIndi.addDefaultProperties();
            firstIndi.setName(this.getFirstName(), this.getLastName());
            firstIndi.setSex(this.getSex() != false ? 1 : 2);
        }
        catch (GedcomException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            this.displayErrorMessage();
            return;
        }
        String filename = this.getLastName();
        Context newContext = GedcomDirectory.getDefault().newGedcom(this.gedcom, NbBundle.getMessage(NewGedcomPanel.class, (String)"NewGedcomPanel.chooseDir", (Object)filename), filename, false);
        if (newContext == null) {
            this.displayErrorMessage();
        }
    }

    private void displayErrorMessage() {
        DialogManager.create((String)NbBundle.getMessage(this.getClass(), (String)"CTL_ActionNew"), (String)NbBundle.getMessage(this.getClass(), (String)"NewGedcomPanel.creationerror")).setMessageType(0).show();
    }
}

