/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.gedcom.searchduplicates;

import ancestris.modules.gedcom.matchers.PotentialMatch;
import ancestris.modules.gedcom.searchduplicates.SearchDuplicatesPlugin;
import ancestris.util.GedcomUtilities;
import ancestris.util.swing.MergeEntityPanel;
import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomException;
import genj.gedcom.UnitOfWork;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.KeyStroke;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class DuplicateResultCreator
implements Runnable {
    private final MergeEntityPanel entityViewPanel;
    private final Gedcom gedcom;
    private final List<PotentialMatch<? extends Entity>> matchesLinkedList;
    private DialogDescriptor checkDuplicatePanelDescriptor;
    private int linkedListIndex = -1;
    private final JButton firstButton = new JButton();
    private final JButton previousButton = new JButton();
    private final JButton swapButton = new JButton();
    private final JButton nextButton = new JButton();
    private final JButton lastButton = new JButton();
    private final JButton mergeButton = new JButton();
    private final JButton cleanButton = new JButton();
    private final JButton closeButton = new JButton();

    public DuplicateResultCreator(Gedcom myGedcom, List<PotentialMatch<? extends Entity>> myMatches) {
        this.gedcom = myGedcom;
        this.entityViewPanel = new MergeEntityPanel(myGedcom);
        this.matchesLinkedList = myMatches;
    }

    @Override
    public void run() {
        AbstractAction doFirst = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DuplicateResultCreator.this.firstButton.isEnabled()) {
                    DuplicateResultCreator.this.firstButtonActionPerformed(e);
                }
            }
        };
        this.firstButton.setAction(doFirst);
        this.firstButton.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/gedcom/searchduplicates/first.png")));
        this.firstButton.setToolTipText(NbBundle.getMessage(DuplicateResultCreator.class, (String)"SearchDuplicatesPlugin.firstButton"));
        this.firstButton.setEnabled(false);
        this.firstButton.setDefaultCapable(true);
        this.firstButton.putClientProperty("defaultButton", Boolean.FALSE);
        AbstractAction doPrevious = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DuplicateResultCreator.this.previousButton.isEnabled()) {
                    DuplicateResultCreator.this.previousButtonActionPerformed(e);
                }
            }
        };
        this.previousButton.setAction(doPrevious);
        this.previousButton.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/gedcom/searchduplicates/previous.png")));
        this.previousButton.setToolTipText(NbBundle.getMessage(DuplicateResultCreator.class, (String)"SearchDuplicatesPlugin.previousButton"));
        this.previousButton.setEnabled(false);
        this.previousButton.setDefaultCapable(true);
        this.previousButton.putClientProperty("defaultButton", Boolean.FALSE);
        AbstractAction doSwap = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DuplicateResultCreator.this.swapButton.isEnabled()) {
                    DuplicateResultCreator.this.swapButtonActionPerformed(e);
                }
            }
        };
        this.swapButton.setAction(doSwap);
        this.swapButton.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/gedcom/searchduplicates/swap.png")));
        this.swapButton.setToolTipText(NbBundle.getMessage(DuplicateResultCreator.class, (String)"SearchDuplicatesPlugin.swapButton"));
        this.swapButton.setEnabled(true);
        this.swapButton.setDefaultCapable(true);
        this.swapButton.putClientProperty("defaultButton", Boolean.FALSE);
        AbstractAction doNext = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DuplicateResultCreator.this.nextButton.isEnabled()) {
                    DuplicateResultCreator.this.nextButtonActionPerformed(e);
                }
            }
        };
        this.nextButton.setAction(doNext);
        this.nextButton.setDefaultCapable(true);
        this.nextButton.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/gedcom/searchduplicates/next.png")));
        this.nextButton.setToolTipText(NbBundle.getMessage(DuplicateResultCreator.class, (String)"SearchDuplicatesPlugin.nextButton"));
        this.nextButton.setEnabled(false);
        AbstractAction doLast = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DuplicateResultCreator.this.lastButton.isEnabled()) {
                    DuplicateResultCreator.this.lastButtonActionPerformed(e);
                }
            }
        };
        this.lastButton.setAction(doLast);
        this.lastButton.setDefaultCapable(true);
        this.lastButton.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/gedcom/searchduplicates/last.png")));
        this.lastButton.setToolTipText(NbBundle.getMessage(DuplicateResultCreator.class, (String)"SearchDuplicatesPlugin.lastButton"));
        this.lastButton.setEnabled(false);
        this.lastButton.putClientProperty("defaultButton", Boolean.FALSE);
        AbstractAction doMerge = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DuplicateResultCreator.this.mergeButton.isEnabled()) {
                    DuplicateResultCreator.this.mergeButtonActionPerformed(e);
                }
            }
        };
        this.mergeButton.setAction(doMerge);
        this.mergeButton.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/gedcom/searchduplicates/merge.png")));
        this.mergeButton.setToolTipText(NbBundle.getMessage(DuplicateResultCreator.class, (String)"SearchDuplicatesPlugin.mergeButton"));
        this.mergeButton.setDefaultCapable(true);
        this.mergeButton.setEnabled(true);
        AbstractAction doClean = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DuplicateResultCreator.this.cleanButton.isEnabled()) {
                    DuplicateResultCreator.this.cleanButtonActionPerformed(e);
                }
            }
        };
        this.cleanButton.setAction(doClean);
        this.cleanButton.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/gedcom/searchduplicates/clean.png")));
        this.cleanButton.setToolTipText(NbBundle.getMessage(DuplicateResultCreator.class, (String)"SearchDuplicatesPlugin.cleanButton"));
        this.cleanButton.setDefaultCapable(true);
        this.cleanButton.setEnabled(true);
        this.closeButton.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/gedcom/searchduplicates/close.png")));
        this.closeButton.setToolTipText(NbBundle.getMessage(DuplicateResultCreator.class, (String)"SearchDuplicatesPlugin.closeButton"));
        this.closeButton.setDefaultCapable(true);
        this.closeButton.setEnabled(true);
        if (this.matchesLinkedList.size() > 0) {
            this.checkDuplicatePanelDescriptor = new DialogDescriptor((Object)this.entityViewPanel, "", false, new Object[]{this.firstButton, this.previousButton, this.swapButton, this.nextButton, this.lastButton, this.mergeButton, this.cleanButton, this.closeButton}, (Object)this.mergeButton, 0, null, null);
            this.checkDuplicatePanelDescriptor.setClosingOptions(new Object[]{this.closeButton});
            this.linkedListIndex = 0;
            if (this.linkedListIndex < this.matchesLinkedList.size() - 1) {
                this.nextButton.setEnabled(true);
                this.lastButton.setEnabled(true);
            }
            this.setEntities(this.matchesLinkedList.get(this.linkedListIndex));
            this.setTitle();
            Dialog dialog = DialogDisplayer.getDefault().createDialog(this.checkDuplicatePanelDescriptor);
            this.entityViewPanel.getInputMap(2).put(KeyStroke.getKeyStroke(38, 128), "doFirst");
            this.entityViewPanel.getInputMap(2).put(KeyStroke.getKeyStroke(37, 128), "doPrevious");
            this.entityViewPanel.getInputMap(2).put(KeyStroke.getKeyStroke(8, 128), "doSwap");
            this.entityViewPanel.getInputMap(2).put(KeyStroke.getKeyStroke(39, 128), "doNext");
            this.entityViewPanel.getInputMap(2).put(KeyStroke.getKeyStroke(40, 128), "doLast");
            this.entityViewPanel.getInputMap(2).put(KeyStroke.getKeyStroke(10, 128), "doMerge");
            this.entityViewPanel.getInputMap(2).put(KeyStroke.getKeyStroke(32, 128), "doClean");
            this.entityViewPanel.getActionMap().put("doFirst", doFirst);
            this.entityViewPanel.getActionMap().put("doPrevious", doPrevious);
            this.entityViewPanel.getActionMap().put("doSwap", doSwap);
            this.entityViewPanel.getActionMap().put("doNext", doNext);
            this.entityViewPanel.getActionMap().put("doLast", doLast);
            this.entityViewPanel.getActionMap().put("doMerge", doMerge);
            this.entityViewPanel.getActionMap().put("doClean", doClean);
            dialog.setModal(true);
            dialog.setVisible(true);
            dialog.toFront();
        } else {
            NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)NbBundle.getMessage(SearchDuplicatesPlugin.class, (String)"CheckDuplicates.noDuplicates"), 1);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
        }
    }

    private void setEntities(PotentialMatch<? extends Entity> match) {
        this.entityViewPanel.setEntities(match.getLeft(), match.getRight(), match.isMerged());
    }

    private void firstButtonActionPerformed(ActionEvent evt) {
        this.linkedListIndex = 0;
        this.mergeButton.setEnabled(!this.matchesLinkedList.get(this.linkedListIndex).isMerged());
        this.setEntities(this.matchesLinkedList.get(this.linkedListIndex));
        this.setTitle();
        if (this.linkedListIndex <= 0) {
            this.firstButton.setEnabled(false);
            this.previousButton.setEnabled(false);
        }
        if (this.linkedListIndex < this.matchesLinkedList.size() - 1) {
            this.nextButton.setEnabled(true);
            this.lastButton.setEnabled(true);
        }
    }

    private void previousButtonActionPerformed(ActionEvent evt) {
        --this.linkedListIndex;
        this.mergeButton.setEnabled(!this.matchesLinkedList.get(this.linkedListIndex).isMerged());
        this.setEntities(this.matchesLinkedList.get(this.linkedListIndex));
        this.setTitle();
        if (this.linkedListIndex <= 0) {
            this.firstButton.setEnabled(false);
            this.previousButton.setEnabled(false);
        }
        if (this.linkedListIndex < this.matchesLinkedList.size() - 1) {
            this.nextButton.setEnabled(true);
            this.lastButton.setEnabled(true);
        }
    }

    private void swapButtonActionPerformed(ActionEvent evt) {
        PotentialMatch<? extends Entity> e = this.matchesLinkedList.get(this.linkedListIndex);
        e.swap();
        this.setEntities(e);
    }

    private void nextButtonActionPerformed(ActionEvent evt) {
        ++this.linkedListIndex;
        this.mergeButton.setEnabled(!this.matchesLinkedList.get(this.linkedListIndex).isMerged());
        this.setEntities(this.matchesLinkedList.get(this.linkedListIndex));
        this.setTitle();
        if (this.linkedListIndex >= this.matchesLinkedList.size() - 1) {
            this.nextButton.setEnabled(false);
            this.lastButton.setEnabled(false);
        }
        if (this.linkedListIndex > 0) {
            this.firstButton.setEnabled(true);
            this.previousButton.setEnabled(true);
        }
    }

    private void lastButtonActionPerformed(ActionEvent evt) {
        this.linkedListIndex = this.matchesLinkedList.size() - 1;
        this.mergeButton.setEnabled(!this.matchesLinkedList.get(this.linkedListIndex).isMerged());
        this.setEntities(this.matchesLinkedList.get(this.linkedListIndex));
        this.setTitle();
        if (this.linkedListIndex >= this.matchesLinkedList.size() - 1) {
            this.nextButton.setEnabled(false);
            this.lastButton.setEnabled(false);
        }
        if (this.linkedListIndex > 0) {
            this.firstButton.setEnabled(true);
            this.previousButton.setEnabled(true);
        }
    }

    private void mergeButtonActionPerformed(ActionEvent evt) {
        boolean merge = false;
        if (this.entityViewPanel.getSelectedProperties().isEmpty()) {
            NotifyDescriptor.Confirmation nd = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(SearchDuplicatesPlugin.class, (String)"SearchDuplicatesPlugin.noSelectedProperties"), 2);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
            if (nd.getValue() == NotifyDescriptor.OK_OPTION) {
                merge = true;
            }
        } else {
            merge = true;
        }
        if (merge) {
            final Entity left = this.matchesLinkedList.get(this.linkedListIndex).getLeft();
            final Entity right = this.matchesLinkedList.get(this.linkedListIndex).getRight();
            final List selectedProperties = this.entityViewPanel.getSelectedProperties();
            try {
                this.gedcom.doUnitOfWork(new UnitOfWork(){

                    public void perform(Gedcom gedcom) throws GedcomException {
                        GedcomUtilities.MergeEntities((Entity)left, (Entity)right, (List)selectedProperties);
                    }
                });
            }
            catch (GedcomException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            this.matchesLinkedList.get(this.linkedListIndex).setMerged(true);
            this.mergeButton.setEnabled(!this.matchesLinkedList.get(this.linkedListIndex).isMerged());
            this.setEntities(this.matchesLinkedList.get(this.linkedListIndex));
            this.setTitle();
        }
    }

    private void cleanButtonActionPerformed(ActionEvent evt) {
        Entity right = this.matchesLinkedList.get(this.linkedListIndex).getRight();
        this.linkedListIndex = this.cleanList(this.matchesLinkedList, right, this.linkedListIndex);
        this.matchesLinkedList.remove(this.linkedListIndex);
        if (this.matchesLinkedList.size() > 0) {
            if (this.linkedListIndex >= this.matchesLinkedList.size() - 1) {
                this.nextButton.setEnabled(false);
                this.lastButton.setEnabled(false);
                this.linkedListIndex = this.matchesLinkedList.size() - 1;
            }
            if (this.linkedListIndex <= 0) {
                this.firstButton.setEnabled(false);
                this.previousButton.setEnabled(false);
                this.linkedListIndex = 0;
            }
            if (this.linkedListIndex > 0) {
                this.firstButton.setEnabled(true);
                this.previousButton.setEnabled(true);
            }
            if (this.linkedListIndex < this.matchesLinkedList.size() - 1) {
                this.nextButton.setEnabled(true);
                this.lastButton.setEnabled(true);
            }
            this.mergeButton.setEnabled(!this.matchesLinkedList.get(this.linkedListIndex).isMerged());
            this.setEntities(this.matchesLinkedList.get(this.linkedListIndex));
            this.setTitle();
        } else {
            this.closeButton.doClick();
            NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)NbBundle.getMessage(SearchDuplicatesPlugin.class, (String)"CheckDuplicates.mergeCompleted"), 1);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
        }
    }

    private void setTitle() {
        String part1 = "";
        part1 = this.matchesLinkedList.get(this.linkedListIndex).isMerged() ? NbBundle.getMessage(this.getClass(), (String)"SearchDuplicatesPlugin.title.part1b") : NbBundle.getMessage(this.getClass(), (String)"SearchDuplicatesPlugin.title.part1a", (Object)this.matchesLinkedList.get(this.linkedListIndex).getCertainty());
        String part2 = NbBundle.getMessage(this.getClass(), (String)"SearchDuplicatesPlugin.title.part2", (Object)(this.linkedListIndex + 1), (Object)this.matchesLinkedList.size());
        this.checkDuplicatePanelDescriptor.setTitle(part1 + " - " + part2);
    }

    private int cleanList(List<PotentialMatch<? extends Entity>> matchesLinkedList, Entity rightEntity, int linkedListIndex) {
        PotentialMatch<? extends Entity> currentMatch = matchesLinkedList.get(linkedListIndex);
        LinkedList<PotentialMatch<? extends Entity>> matchToRemove = new LinkedList<PotentialMatch<? extends Entity>>();
        for (PotentialMatch<? extends Entity> match : matchesLinkedList) {
            if (match.equals(currentMatch) || !match.getLeft().equals(rightEntity) && !match.getRight().equals(rightEntity)) continue;
            matchToRemove.add(match);
        }
        matchesLinkedList.removeAll(matchToRemove);
        int index = 0;
        for (PotentialMatch<? extends Entity> match : matchesLinkedList) {
            if (match.equals(currentMatch)) {
                return index;
            }
            ++index;
        }
        return 0;
    }
}

