/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.gedcom.matchers;

import ancestris.modules.gedcom.matchers.EntityMatcher;
import ancestris.modules.gedcom.matchers.FamMatcherOptions;
import ancestris.modules.gedcom.matchers.IndiMatcher;
import genj.gedcom.Fam;
import genj.gedcom.Indi;
import genj.gedcom.Property;
import genj.gedcom.PropertyDate;
import genj.gedcom.PropertyName;
import genj.gedcom.PropertyPlace;
import java.util.ArrayList;
import java.util.List;

public class FamMatcher
extends EntityMatcher<Fam, FamMatcherOptions> {
    public FamMatcher() {
        this.options = new FamMatcherOptions();
    }

    @Override
    public int compare(Fam left, Fam right) {
        int score = 0;
        Indi leftHusband = left.getHusband();
        Indi rightHusband = right.getHusband();
        if (leftHusband != null && rightHusband != null) {
            int m = new IndiMatcher().compare(leftHusband, rightHusband);
            score += m;
        }
        Indi leftWife = left.getWife();
        Indi rightWife = right.getWife();
        if (leftWife != null && rightWife != null) {
            int m = new IndiMatcher().compare(leftWife, rightWife);
            score *= m / 100;
        }
        score = Math.max(score - 20, 0);
        PropertyDate leftwhen = left.getMarriageDate();
        PropertyDate rightwhen = right.getMarriageDate();
        if (leftwhen != null && leftwhen.isComparable() && rightwhen != null && rightwhen.isComparable()) {
            if (leftwhen.compareTo((Property)rightwhen) <= ((FamMatcherOptions)this.options).getDateinterval()) {
                score += 10;
            }
        } else if (!((FamMatcherOptions)this.options).isEmptyValueInvalid()) {
            score += 5;
        }
        if (this.compareMarriagePlace(left, right)) {
            score += 10;
        }
        return score;
    }

    @Override
    protected String[] getKeys(Fam entity) {
        List<PropertyName> wifeNames;
        PropertyName pN;
        List<PropertyName> husbandNames;
        ArrayList<String> keys = new ArrayList<String>();
        if (entity.getHusband() != null) {
            husbandNames = entity.getHusband().getProperties(PropertyName.class);
        } else {
            husbandNames = new ArrayList();
            pN = new PropertyName();
            pN.setName("?", "?");
            husbandNames.add(pN);
        }
        if (entity.getWife() != null) {
            wifeNames = entity.getWife().getProperties(PropertyName.class);
        } else {
            wifeNames = new ArrayList();
            pN = new PropertyName();
            pN.setName("?", "?");
            wifeNames.add(pN);
        }
        for (Property property : husbandNames) {
            for (Property property2 : wifeNames) {
                keys.add(((PropertyName)property).getFirstName() + ((PropertyName)property2).getFirstName());
            }
        }
        return keys.toArray(new String[0]);
    }

    private boolean compareMarriagePlace(Fam leftFam, Fam rightFam) {
        Property leftFamMarrDate = leftFam.getProperty("MARR");
        Property rightFamMarrDate = rightFam.getProperty("MARR");
        if (leftFamMarrDate != null && rightFamMarrDate != null) {
            PropertyPlace rightFamPropertyPlace = (PropertyPlace)rightFamMarrDate.getProperty("PLAC");
            PropertyPlace leftFamPropertyPlace = (PropertyPlace)leftFamMarrDate.getProperty("PLAC");
            if (rightFamPropertyPlace != null && leftFamPropertyPlace != null) {
                return rightFamPropertyPlace.compareTo((Property)leftFamPropertyPlace) == 0;
            }
            return false;
        }
        return false;
    }
}

