/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.editors.standard.tools;

import genj.util.Registry;
import genj.view.ViewContext;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import javax.swing.ListCellRenderer;
import org.netbeans.api.options.OptionsDisplayer;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class ErrorPanel
extends JPanel {
    private Registry registry = Registry.get(this.getClass());
    List<ViewContext> errors = null;
    private JList errorsList;
    private JScrollPane jScrollPane;
    private JButton paramButton;
    private JLabel paramLabel;

    public ErrorPanel(List<ViewContext> errors, boolean showParameters) {
        this.errors = errors;
        this.initComponents();
        this.errorsList.setCellRenderer(new ListRenderer());
        this.paramLabel.setVisible(showParameters);
        this.paramButton.setVisible(showParameters);
        int maxWidth = this.registry.get("errorWindowWidth", this.getPreferredSize().width);
        FontMetrics fm = this.getFontMetrics(this.getFont());
        for (ViewContext error : errors) {
            maxWidth = Math.max(maxWidth, fm.stringWidth(error.getText()) + 70);
        }
        this.setPreferredSize(new Dimension(maxWidth, this.registry.get("errorWindowHeight", this.getPreferredSize().height)));
    }

    private void initComponents() {
        this.jScrollPane = new JScrollPane();
        this.errorsList = new JList();
        this.paramLabel = new JLabel();
        this.paramButton = new JButton();
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent evt) {
                ErrorPanel.this.formComponentResized(evt);
            }
        });
        this.errorsList.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        this.errorsList.setModel(new AbstractListModel(){
            ViewContext[] lines;
            {
                this.lines = ErrorPanel.this.errors.toArray(new ViewContext[ErrorPanel.this.errors.size()]);
            }

            @Override
            public int getSize() {
                return this.lines.length;
            }

            @Override
            public Object getElementAt(int i) {
                return this.lines[i];
            }
        });
        this.errorsList.setSelectionMode(0);
        this.errorsList.setFixedCellHeight(20);
        this.errorsList.setVisibleRowCount(12);
        this.jScrollPane.setViewportView(this.errorsList);
        Mnemonics.setLocalizedText((JLabel)this.paramLabel, (String)NbBundle.getMessage(ErrorPanel.class, (String)"ErrorPanel.paramLabel.text"));
        this.paramButton.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/editors/standard/images/parameters.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.paramButton, (String)NbBundle.getMessage(ErrorPanel.class, (String)"ErrorPanel.paramButton.text"));
        this.paramButton.setPreferredSize(new Dimension(24, 24));
        this.paramButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ErrorPanel.this.paramButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane, -1, 481, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.paramButton, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.paramLabel).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane, -1, 170, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.paramLabel).addComponent(this.paramButton, -2, -1, -2)).addContainerGap()));
    }

    private void paramButtonActionPerformed(ActionEvent evt) {
        OptionsDisplayer.getDefault().open("Extensions/GedcomValidateOptions");
    }

    private void formComponentResized(ComponentEvent evt) {
        this.registry.put("errorWindowWidth", evt.getComponent().getWidth());
        this.registry.put("errorWindowHeight", evt.getComponent().getHeight());
    }

    private class ListRenderer
    extends JLabel
    implements ListCellRenderer {
        private Color backSelectedColor = null;
        private Color foreSelectedColor = null;

        public ListRenderer() {
            Color c = new JList().getSelectionBackground();
            this.backSelectedColor = new Color(c.getRed(), c.getGreen(), c.getBlue());
            c = new JList().getSelectionForeground();
            this.foreSelectedColor = new Color(c.getRed(), c.getGreen(), c.getBlue());
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value != null) {
                ViewContext vc = (ViewContext)value;
                this.setIconTextGap(8);
                this.setIcon((Icon)vc.getImage());
                this.setText(vc.getText());
                if (isSelected) {
                    this.setBackground(this.backSelectedColor);
                    this.setForeground(this.foreSelectedColor);
                } else {
                    this.setBackground(list.getBackground());
                    this.setForeground(list.getForeground());
                }
                this.setEnabled(list.isEnabled());
                this.setFont(list.getFont());
                this.setOpaque(true);
            }
            return this;
        }
    }
}

