/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.editors.genealogyeditor.panels;

import ancestris.modules.editors.genealogyeditor.AriesTopComponent;
import ancestris.modules.editors.genealogyeditor.editors.NoteEditor;
import ancestris.modules.editors.genealogyeditor.models.NotesTableModel;
import ancestris.modules.editors.genealogyeditor.table.EditorTable;
import ancestris.modules.editors.genealogyeditor.utilities.AriesFilterPanel;
import ancestris.modules.editors.genealogyeditor.utilities.FilterToolBar;
import ancestris.util.swing.DialogManager;
import genj.gedcom.Context;
import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomException;
import genj.gedcom.Note;
import genj.gedcom.Property;
import genj.gedcom.UnitOfWork;
import genj.util.Registry;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.regex.PatternSyntaxException;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.RowFilter;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import org.openide.DialogDescriptor;
import org.openide.util.ChangeSupport;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class NotesTablePanel
extends JPanel
implements AriesFilterPanel {
    private Property mRoot;
    private final NotesTableModel mNotesTableModel = new NotesTableModel();
    private Note mNote;
    private final ChangeListner changeListner = new ChangeListner();
    private final ChangeSupport changeSupport = new ChangeSupport(NotesTablePanel.class);
    private final TableRowSorter<TableModel> notesTableSorter;
    private Registry registry = null;
    private JButton addNoteButton;
    private JButton deleteNoteButton;
    private JButton editNoteButton;
    private FilterToolBar filterToolBar;
    private JToolBar jToolBar1;
    private JButton linkToNoteButton;
    private EditorTable notesTable;
    private JScrollPane notesTableScrollPane;
    private JToolBar notesToolBar;

    public NotesTablePanel(Property root, List<Note> notesList) {
        this.initComponents();
        this.mRoot = root;
        this.registry = root.getGedcom().getRegistry();
        this.notesTable.setID(NotesTablePanel.class.getName());
        this.mNotesTableModel.addAll(notesList);
        if (this.mNotesTableModel.getRowCount() > 0) {
            this.deleteNoteButton.setEnabled(false);
            this.editNoteButton.setEnabled(false);
        } else {
            this.deleteNoteButton.setEnabled(true);
            this.editNoteButton.setEnabled(true);
        }
        this.notesTableSorter = new TableRowSorter<TableModel>(this.notesTable.getModel());
        this.loadSettings();
        this.notesTable.setRowSorter(this.notesTableSorter);
    }

    @Override
    public void saveFilterSettings() {
        StringBuilder sb = new StringBuilder();
        List<RowSorter.SortKey> sortKeys = this.notesTableSorter.getSortKeys();
        for (int i = 0; i < sortKeys.size(); ++i) {
            RowSorter.SortKey sk = sortKeys.get(i);
            sb.append(sk.getColumn());
            sb.append(',');
            sb.append(sk.getSortOrder().toString());
            sb.append(';');
        }
        this.registry.put("Aries.NotesSortOrder", sb.toString());
    }

    private void loadSettings() {
        String sortOrder = this.registry.get("Aries.NotesSortOrder", "");
        if ("".equals(sortOrder)) {
            return;
        }
        ArrayList<RowSorter.SortKey> sorts = new ArrayList<RowSorter.SortKey>();
        for (String columnInfo : sortOrder.split(";")) {
            String[] column = columnInfo.split(",");
            RowSorter.SortKey sk = new RowSorter.SortKey(Integer.valueOf(column[0]), SortOrder.valueOf(column[1]));
            sorts.add(sk);
        }
        if (sorts.size() > 0) {
            this.notesTableSorter.setSortKeys(sorts);
        }
    }

    private void initComponents() {
        this.jToolBar1 = new JToolBar();
        this.notesToolBar = new JToolBar();
        this.addNoteButton = new JButton();
        this.linkToNoteButton = new JButton();
        this.editNoteButton = new JButton();
        this.deleteNoteButton = new JButton();
        this.filterToolBar = new FilterToolBar(this);
        this.notesTableScrollPane = new JScrollPane();
        this.notesTable = new EditorTable();
        this.jToolBar1.setBorder(null);
        this.jToolBar1.setFloatable(false);
        this.jToolBar1.setRollover(true);
        this.notesToolBar.setFloatable(false);
        this.notesToolBar.setRollover(true);
        this.addNoteButton.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/editors/genealogyeditor/resources/edit_add.png")));
        this.addNoteButton.setToolTipText(MessageFormat.format(ResourceBundle.getBundle("ancestris/modules/editors/genealogyeditor/panels/Bundle").getString("NotesTablePanel.addNoteButton.toolTipText"), new Object[0]));
        this.addNoteButton.setFocusable(false);
        this.addNoteButton.setHorizontalTextPosition(0);
        this.addNoteButton.setVerticalTextPosition(3);
        this.addNoteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NotesTablePanel.this.addNoteButtonActionPerformed(evt);
            }
        });
        this.notesToolBar.add(this.addNoteButton);
        this.linkToNoteButton.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/editors/genealogyeditor/resources/link_add.png")));
        this.linkToNoteButton.setToolTipText(MessageFormat.format(ResourceBundle.getBundle("ancestris/modules/editors/genealogyeditor/panels/Bundle").getString("NotesTablePanel.linkToNoteButton.toolTipText"), new Object[0]));
        this.linkToNoteButton.setFocusable(false);
        this.linkToNoteButton.setHorizontalTextPosition(0);
        this.linkToNoteButton.setVerticalTextPosition(3);
        this.linkToNoteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NotesTablePanel.this.linkToNoteButtonActionPerformed(evt);
            }
        });
        this.notesToolBar.add(this.linkToNoteButton);
        this.editNoteButton.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/editors/genealogyeditor/resources/edit.png")));
        this.editNoteButton.setToolTipText(MessageFormat.format(ResourceBundle.getBundle("ancestris/modules/editors/genealogyeditor/panels/Bundle").getString("NotesTablePanel.editNoteButton.toolTipText"), new Object[0]));
        this.editNoteButton.setFocusable(false);
        this.editNoteButton.setHorizontalTextPosition(0);
        this.editNoteButton.setVerticalTextPosition(3);
        this.editNoteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NotesTablePanel.this.editNoteButtonActionPerformed(evt);
            }
        });
        this.notesToolBar.add(this.editNoteButton);
        this.deleteNoteButton.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/editors/genealogyeditor/resources/edit_delete.png")));
        this.deleteNoteButton.setToolTipText(MessageFormat.format(ResourceBundle.getBundle("ancestris/modules/editors/genealogyeditor/panels/Bundle").getString("NotesTablePanel.deleteNoteButton.toolTipText"), new Object[0]));
        this.deleteNoteButton.setFocusable(false);
        this.deleteNoteButton.setHorizontalTextPosition(0);
        this.deleteNoteButton.setVerticalTextPosition(3);
        this.deleteNoteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NotesTablePanel.this.deleteNoteButtonActionPerformed(evt);
            }
        });
        this.notesToolBar.add(this.deleteNoteButton);
        this.jToolBar1.add(this.notesToolBar);
        this.jToolBar1.add(this.filterToolBar);
        this.notesTable.setModel(this.mNotesTableModel);
        this.notesTable.setSelectionBackground(new Color(89, 142, 195));
        this.notesTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                NotesTablePanel.this.notesTableMouseClicked(evt);
            }
        });
        this.notesTableScrollPane.setViewportView(this.notesTable);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.notesTableScrollPane, GroupLayout.Alignment.TRAILING, -1, 546, Short.MAX_VALUE).addComponent(this.jToolBar1, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jToolBar1, -2, -1, -2).addGap(4, 4, 4).addComponent(this.notesTableScrollPane, -1, 156, Short.MAX_VALUE)));
    }

    private void addNoteButtonActionPerformed(ActionEvent evt) {
        Gedcom gedcom = this.mRoot.getGedcom();
        int undoNb = gedcom.getUndoNb();
        try {
            gedcom.doUnitOfWork(new UnitOfWork(){

                public void perform(Gedcom gedcom) throws GedcomException {
                    NotesTablePanel.this.mNote = (Note)gedcom.createEntity("NOTE");
                }
            });
            NoteEditor noteEditor = new NoteEditor();
            noteEditor.setContext(new Context((Entity)this.mNote));
            AriesTopComponent atc = AriesTopComponent.findEditorWindow(gedcom);
            atc.getOpenEditors().add(noteEditor);
            if (noteEditor.showPanel()) {
                this.mNotesTableModel.add(this.mNote);
                this.changeListner.stateChanged(null);
                gedcom.doUnitOfWork(new UnitOfWork(){

                    public void perform(Gedcom gedcom) throws GedcomException {
                        NotesTablePanel.this.mRoot.addNote(NotesTablePanel.this.mNote);
                    }
                });
                this.deleteNoteButton.setEnabled(true);
                this.editNoteButton.setEnabled(true);
            } else {
                while (gedcom.getUndoNb() > undoNb && gedcom.canUndo()) {
                    gedcom.undoUnitOfWork(false);
                }
            }
            atc.getOpenEditors().remove((Object)noteEditor);
        }
        catch (GedcomException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private void editNoteButtonActionPerformed(ActionEvent evt) {
        int selectedRow = this.notesTable.getSelectedRow();
        if (selectedRow != -1) {
            int rowIndex = this.notesTable.convertRowIndexToModel(selectedRow);
            NoteEditor noteEditor = new NoteEditor();
            noteEditor.setContext(new Context((Entity)this.mNotesTableModel.getValueAt(rowIndex)));
            AriesTopComponent atc = AriesTopComponent.findEditorWindow(this.mRoot.getGedcom());
            atc.getOpenEditors().add(noteEditor);
            noteEditor.showPanel();
            atc.getOpenEditors().remove((Object)noteEditor);
        }
    }

    private void deleteNoteButtonActionPerformed(ActionEvent evt) {
        int selectedRow = this.notesTable.getSelectedRow();
        if (selectedRow != -1) {
            final int rowIndex = this.notesTable.convertRowIndexToModel(selectedRow);
            DialogManager createYesNo = DialogManager.createYesNo((String)NbBundle.getMessage(NotesTablePanel.class, (String)"NotesTableDialog.deleteNote.title"), (String)NbBundle.getMessage(NotesTablePanel.class, (String)"NotesTableDialog.deleteNote.text", (Object)this.mRoot));
            if (createYesNo.show() == DialogManager.YES_OPTION) {
                try {
                    this.mRoot.getGedcom().doUnitOfWork(new UnitOfWork(){

                        public void perform(Gedcom gedcom) throws GedcomException {
                            NotesTablePanel.this.mRoot.delProperty((Property)NotesTablePanel.this.mNotesTableModel.remove(rowIndex));
                        }
                    });
                    this.changeListner.stateChanged(null);
                    if (this.mNotesTableModel.getRowCount() == 0) {
                        this.deleteNoteButton.setEnabled(false);
                        this.editNoteButton.setEnabled(false);
                    }
                }
                catch (GedcomException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }
    }

    private void linkToNoteButtonActionPerformed(ActionEvent evt) {
        ArrayList<Note> notesList = new ArrayList<Note>(this.mRoot.getGedcom().getEntities("NOTE"));
        NotesTablePanel notesTablePanel = new NotesTablePanel(this.mRoot, notesList);
        notesTablePanel.setToolBarVisible(false);
        DialogManager.ADialog notesTablePanelDialog = new DialogManager.ADialog(NbBundle.getMessage(NoteEditor.class, (String)"NoteEditorPanel.title"), (JComponent)notesTablePanel);
        notesTablePanelDialog.setDialogId(NoteEditor.class.getName());
        if (notesTablePanelDialog.show() == DialogDescriptor.OK_OPTION) {
            final Note selectedNote = notesTablePanel.getSelectedNote();
            this.mNotesTableModel.add(selectedNote);
            try {
                this.mRoot.getGedcom().doUnitOfWork(new UnitOfWork(){

                    public void perform(Gedcom gedcom) throws GedcomException {
                        NotesTablePanel.this.mRoot.addNote(selectedNote);
                    }
                });
                this.deleteNoteButton.setEnabled(true);
                this.editNoteButton.setEnabled(true);
                this.changeListner.stateChanged(null);
            }
            catch (GedcomException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        notesTablePanel.saveFilterSettings();
    }

    private void notesTableMouseClicked(MouseEvent evt) {
        int selectedRow;
        if (evt.getClickCount() >= 2 && (selectedRow = this.notesTable.getSelectedRow()) != -1) {
            int rowIndex = this.notesTable.convertRowIndexToModel(selectedRow);
            NoteEditor noteEditor = new NoteEditor();
            noteEditor.setContext(new Context((Entity)this.mNotesTableModel.getValueAt(rowIndex)));
            noteEditor.addChangeListener(this.changeListner);
            AriesTopComponent atc = AriesTopComponent.findEditorWindow(this.mRoot.getGedcom());
            atc.getOpenEditors().add(noteEditor);
            noteEditor.showPanel();
            noteEditor.removeChangeListener(this.changeListner);
            atc.getOpenEditors().remove((Object)noteEditor);
        }
    }

    public void setToolBarVisible(boolean visible) {
        this.notesToolBar.setVisible(visible);
    }

    public Note getSelectedNote() {
        int selectedRow = this.notesTable.getSelectedRow();
        if (selectedRow != -1) {
            int rowIndex = this.notesTable.convertRowIndexToModel(selectedRow);
            return this.mNotesTableModel.getValueAt(rowIndex);
        }
        return null;
    }

    public void addChangeListener(ChangeListener l) {
        this.changeSupport.addChangeListener(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.changeSupport.removeChangeListener(l);
    }

    @Override
    public ComboBoxModel<String> getComboBoxModel() {
        return new DefaultComboBoxModel<String>(this.mNotesTableModel.getColumnsName());
    }

    @Override
    public void filter(int index, String searchFilter) {
        RowFilter rf;
        try {
            rf = RowFilter.regexFilter("(?i)" + searchFilter, index);
        }
        catch (PatternSyntaxException e) {
            return;
        }
        this.notesTableSorter.setRowFilter(rf);
    }

    private class ChangeListner
    implements ChangeListener {
        private ChangeListner() {
        }

        @Override
        public void stateChanged(ChangeEvent ce) {
            NotesTablePanel.this.changeSupport.fireChange();
        }
    }
}

