/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.editors.genealogyeditor.models;

import genj.gedcom.Gedcom;
import genj.gedcom.Property;
import genj.util.ReferenceSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.DefaultComboBoxModel;
import org.openide.util.NbBundle;

public class NameTypeComboBoxModel
extends DefaultComboBoxModel<String> {
    static final Map<String, String> NAME_TYPE_COMBO_BOX = new HashMap<String, String>(){
        {
            this.put("aka", NbBundle.getMessage(NameTypeComboBoxModel.class, (String)"NameTypeComboBoxModelModel.NamesType.aka"));
            this.put("birth", NbBundle.getMessage(NameTypeComboBoxModel.class, (String)"NameTypeComboBoxModelModel.NamesType.birth"));
            this.put("immigrant", NbBundle.getMessage(NameTypeComboBoxModel.class, (String)"NameTypeComboBoxModelModel.NamesType.immigrant"));
            this.put("maiden", NbBundle.getMessage(NameTypeComboBoxModel.class, (String)"NameTypeComboBoxModelModel.NamesType.maiden"));
            this.put("married", NbBundle.getMessage(NameTypeComboBoxModel.class, (String)"NameTypeComboBoxModelModel.NamesType.married"));
        }
    };
    private final Set<String> elements = new HashSet<String>(4);

    public NameTypeComboBoxModel() {
        this.addDefault();
    }

    public void setGedcom(Gedcom gedcom) {
        this.removeAllElements();
        ReferenceSet gedcomList = gedcom.getReferenceSet("TYPE");
        for (String key : gedcomList.getKeys()) {
            Set propList = gedcomList.getReferences((Object)key);
            this.elements.addAll(propList.stream().filter(prop -> "NAME".equals(prop.getParent().getTag())).map(Property::getValue).collect(Collectors.toSet()));
        }
        this.addDefault();
    }

    private void addDefault() {
        this.elements.addAll(NAME_TYPE_COMBO_BOX.values());
        List<String> elemList = this.elements.stream().sorted().collect(Collectors.toList());
        elemList.forEach(s -> this.addElement(s));
    }
}

