/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.editors.genealogyeditor.editors;

import ancestris.modules.editors.genealogyeditor.editors.EntityEditor;
import ancestris.modules.editors.genealogyeditor.panels.AddressEditorPanel;
import ancestris.modules.editors.genealogyeditor.panels.NoteCitationsTablePanel;
import ancestris.modules.editors.genealogyeditor.panels.ReferencesTablePanel;
import genj.gedcom.Context;
import genj.gedcom.Entity;
import genj.gedcom.Property;
import genj.gedcom.PropertyChange;
import genj.gedcom.PropertyXRef;
import genj.gedcom.Repository;
import genj.view.ViewContext;
import java.awt.Component;
import java.awt.Container;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.ResourceBundle;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentListener;
import org.openide.util.NbBundle;

public class RepositoryEditor
extends EntityEditor {
    private Context context;
    private Repository mRepository;
    private AddressEditorPanel addressEditorPanel;
    private JPanel addressPanel;
    private JLabel changeDateLabel;
    private JLabel changeDateLabeldate;
    private JTabbedPane jTabbedPane1;
    private NoteCitationsTablePanel noteCitationsTablePanel;
    private JPanel notesPanel;
    private JPanel referencesPanel;
    private ReferencesTablePanel referencesTablePanel;
    private JLabel repositoryIDLabel;
    private JTextField repositoryIDTextField;
    private JLabel repositoryNameLabel;
    private JTextField repositoryNameTextField;

    public RepositoryEditor() {
        this(false);
    }

    public RepositoryEditor(boolean isNew) {
        super(isNew);
        this.initComponents();
        this.repositoryNameTextField.getDocument().addDocumentListener((DocumentListener)this.changes);
        this.addressEditorPanel.addChangeListener((ChangeListener)this.changes);
        this.noteCitationsTablePanel.addChangeListener((ChangeListener)this.changes);
    }

    private void initComponents() {
        this.repositoryIDLabel = new JLabel();
        this.repositoryIDTextField = new JTextField();
        this.repositoryNameLabel = new JLabel();
        this.repositoryNameTextField = new JTextField();
        this.jTabbedPane1 = new JTabbedPane();
        this.addressPanel = new JPanel();
        this.addressEditorPanel = new AddressEditorPanel();
        this.notesPanel = new JPanel();
        this.noteCitationsTablePanel = new NoteCitationsTablePanel();
        this.referencesPanel = new JPanel();
        this.referencesTablePanel = new ReferencesTablePanel();
        this.changeDateLabel = new JLabel();
        this.changeDateLabeldate = new JLabel();
        this.repositoryIDLabel.setText(MessageFormat.format(ResourceBundle.getBundle("ancestris/modules/editors/genealogyeditor/editors/Bundle").getString("RepositoryEditor.repositoryIDLabel.text"), new Object[0]));
        this.repositoryIDTextField.setEditable(false);
        this.repositoryIDTextField.setColumns(8);
        this.repositoryIDTextField.setText(MessageFormat.format(ResourceBundle.getBundle("ancestris/modules/editors/genealogyeditor/editors/Bundle").getString("RepositoryEditor.repositoryIDTextField.text"), new Object[0]));
        this.repositoryIDTextField.setToolTipText(MessageFormat.format(ResourceBundle.getBundle("ancestris/modules/editors/genealogyeditor/editors/Bundle").getString("RepositoryEditor.repositoryIDTextField.toolTipText"), new Object[0]));
        this.repositoryNameLabel.setText(MessageFormat.format(ResourceBundle.getBundle("ancestris/modules/editors/genealogyeditor/editors/Bundle").getString("RepositoryEditor.repositoryNameLabel.text"), new Object[0]));
        this.repositoryNameTextField.setText(MessageFormat.format(ResourceBundle.getBundle("ancestris/modules/editors/genealogyeditor/editors/Bundle").getString("RepositoryEditor.repositoryNameTextField.text"), new Object[0]));
        GroupLayout addressPanelLayout = new GroupLayout(this.addressPanel);
        this.addressPanel.setLayout(addressPanelLayout);
        addressPanelLayout.setHorizontalGroup(addressPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.addressEditorPanel, -1, 453, Short.MAX_VALUE));
        addressPanelLayout.setVerticalGroup(addressPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.addressEditorPanel, -1, -1, Short.MAX_VALUE));
        this.jTabbedPane1.addTab(NbBundle.getMessage(RepositoryEditor.class, (String)"RepositoryEditor.addressPanel.TabConstraints.tabTitle"), this.addressPanel);
        GroupLayout notesPanelLayout = new GroupLayout(this.notesPanel);
        this.notesPanel.setLayout(notesPanelLayout);
        notesPanelLayout.setHorizontalGroup(notesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.noteCitationsTablePanel, -1, 453, Short.MAX_VALUE));
        notesPanelLayout.setVerticalGroup(notesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.noteCitationsTablePanel, -1, 220, Short.MAX_VALUE));
        this.jTabbedPane1.addTab(NbBundle.getMessage(RepositoryEditor.class, (String)"RepositoryEditor.notesPanel.TabConstraints.tabTitle"), new ImageIcon(((Object)((Object)this)).getClass().getResource("/ancestris/modules/editors/genealogyeditor/resources/note.png")), this.notesPanel);
        GroupLayout referencesPanelLayout = new GroupLayout(this.referencesPanel);
        this.referencesPanel.setLayout(referencesPanelLayout);
        referencesPanelLayout.setHorizontalGroup(referencesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, referencesPanelLayout.createSequentialGroup().addGap(0, 0, 0).addComponent(this.referencesTablePanel, -1, 453, Short.MAX_VALUE)));
        referencesPanelLayout.setVerticalGroup(referencesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, referencesPanelLayout.createSequentialGroup().addGap(0, 0, 0).addComponent(this.referencesTablePanel, -1, 220, Short.MAX_VALUE)));
        this.jTabbedPane1.addTab(NbBundle.getMessage(RepositoryEditor.class, (String)"RepositoryEditor.referencesPanel.TabConstraints.tabTitle"), new ImageIcon(((Object)((Object)this)).getClass().getResource("/ancestris/modules/editors/genealogyeditor/resources/association.png")), this.referencesPanel);
        this.changeDateLabel.setHorizontalAlignment(2);
        this.changeDateLabel.setText(NbBundle.getMessage(RepositoryEditor.class, (String)"RepositoryEditor.changeDateLabel.text"));
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTabbedPane1).addGroup(layout.createSequentialGroup().addComponent(this.repositoryNameLabel).addGap(24, 24, 24).addComponent(this.repositoryNameTextField)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.repositoryIDLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.repositoryIDTextField, -2, -1, -2)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.changeDateLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.changeDateLabeldate, -1, -1, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.repositoryIDLabel).addComponent(this.repositoryIDTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.repositoryNameLabel).addComponent(this.repositoryNameTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTabbedPane1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.changeDateLabel, -1, -1, Short.MAX_VALUE).addComponent(this.changeDateLabeldate, -1, -1, Short.MAX_VALUE)).addContainerGap()));
    }

    public ViewContext getContext() {
        return new ViewContext(this.context);
    }

    public Component getEditorComponent() {
        return this;
    }

    protected String getTitleImpl() {
        if (this.context == null || this.context.getEntity() == null) {
            return "";
        }
        return new ViewContext(this.context.getEntity()).getText();
    }

    protected void setContextImpl(Context context) {
        this.context = context;
        this.changes.mute();
        Entity entity = context.getEntity();
        if (entity != null && entity instanceof Repository && entity.getGedcom() != null) {
            this.mRepository = (Repository)entity;
            this.setTitle(NbBundle.getMessage(RepositoryEditor.class, (String)(this.isNew() ? "RepositoryEditor.create.title" : "RepositoryEditor.edit.title"), (Object)this.mRepository));
            this.repositoryIDTextField.setText(this.mRepository.getId());
            Property repositoryName = this.mRepository.getProperty("NAME");
            this.repositoryNameTextField.setText(repositoryName != null ? repositoryName.getValue() : "");
            Property address = this.mRepository.getProperty("ADDR");
            this.addressEditorPanel.set((Property)this.mRepository, address);
            ArrayList<Entity> entitiesList = new ArrayList<Entity>();
            for (PropertyXRef entityRef : this.mRepository.getProperties(PropertyXRef.class)) {
                entitiesList.add(entityRef.getTargetEntity());
            }
            this.referencesTablePanel.set((Entity)this.mRepository, entitiesList);
            this.noteCitationsTablePanel.set((Property)this.mRepository, Arrays.asList(this.mRepository.getProperties("NOTE")));
            Property changeDate = this.mRepository.getProperty("CHAN");
            if (changeDate != null) {
                this.changeDateLabeldate.setText(((PropertyChange)changeDate).getDisplayValue());
            }
        }
        this.changes.unmute();
    }

    public void commit() {
        if (this.changes.hasChanged()) {
            Property repositoryName = this.mRepository.getProperty("NAME");
            if (repositoryName == null) {
                this.mRepository.addProperty("NAME", this.repositoryNameTextField.getText());
            } else {
                repositoryName.setValue(this.repositoryNameTextField.getText());
            }
        }
        this.addressEditorPanel.commit();
    }

    public Entity getEditedEntity() {
        return this.mRepository;
    }
}

