/*
 * Decompiled with CFR 0.152.
 */
package genj.edit.beans;

import ancestris.util.swing.DialogManager;
import genj.edit.beans.CCPMenu;
import genj.edit.beans.PropertyBean;
import genj.gedcom.Gedcom;
import genj.gedcom.Property;
import genj.gedcom.PropertyChoiceValue;
import genj.util.GridBagHelper;
import genj.util.swing.ChoiceWidget;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JPopupMenu;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ChoiceBean
extends PropertyBean {
    private ChoiceWidget choices;
    private JCheckBox global;
    private Property[] sameChoices = new Property[0];

    private String getGlobalReplaceMsg() {
        if (this.sameChoices.length < 2) {
            return null;
        }
        return RESOURCES.getString("choice.global.confirm", new Object[]{"" + this.sameChoices.length, this.sameChoices[0].getDisplayValue(), this.choices.getText()});
    }

    public ChoiceBean() {
        this.choices = new ChoiceWidget();
        this.choices.setComponentPopupMenu((JPopupMenu)new CCPMenu(this.choices.getTextEditor()));
        this.choices.addChangeListener((ChangeListener)this.changeSupport);
        this.choices.setIgnoreCase(true);
        this.global = new JCheckBox();
        this.global.setBorder(new EmptyBorder(1, 1, 1, 1));
        this.global.setVisible(false);
        this.global.setRequestFocusEnabled(false);
        this.choices.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                String msg = ChoiceBean.this.getGlobalReplaceMsg();
                if (msg != null) {
                    ChoiceBean.this.global.setVisible(true);
                    ChoiceBean.this.global.setToolTipText(msg);
                }
            }
        });
        this.global.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String msg = ChoiceBean.this.getGlobalReplaceMsg();
                if (msg != null && ChoiceBean.this.global.isSelected()) {
                    boolean yes = DialogManager.YES_OPTION == DialogManager.createYesNo((String)PropertyBean.RESOURCES.getString("choice.global.enable"), (String)msg).show();
                    ChoiceBean.this.global.setSelected(yes);
                }
            }
        });
        GridBagHelper layout = new GridBagHelper((Container)this);
        layout.add((Component)this.choices, 0, 0, 1, 1, 17);
        layout.add((Component)this.global, 1, 0);
        layout.addFiller(0, 1);
        this.defaultFocus = this.choices;
    }

    @Override
    protected void commitImpl(Property property) {
        PropertyChoiceValue choice = (PropertyChoiceValue)property;
        String text = this.choices.getText();
        choice.setValue(text, this.global.isSelected());
        this.choices.setValues((Object[])((PropertyChoiceValue)property).getChoices(true));
        this.choices.setText(text);
        this.global.setSelected(false);
        this.global.setVisible(false);
    }

    @Override
    public void setPropertyImpl(Property prop) {
        PropertyChoiceValue choice = (PropertyChoiceValue)prop;
        if (choice != null) {
            this.choices.setValues((Object[])choice.getChoices(true));
            this.choices.setText(choice.isSecret() ? "" : choice.getDisplayValue());
            this.sameChoices = choice.getSameChoices();
        } else {
            this.choices.setValues((Object[])PropertyChoiceValue.getChoices((Gedcom)this.getRoot().getGedcom(), (String)this.getPath().getLast(), (boolean)true));
            this.choices.setText("");
            this.sameChoices = new Property[0];
        }
        this.global.setSelected(false);
        this.global.setVisible(false);
    }
}

