/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.familygroups;

import ancestris.gedcom.ActionSaveViewAsGedcom;
import ancestris.modules.document.view.WidgetDocumentView;
import ancestris.modules.familygroups.ActionMark;
import ancestris.modules.familygroups.FamilyGroupsPlugin;
import genj.common.ContextListWidget;
import genj.gedcom.Context;
import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.Indi;
import genj.io.Filter;
import genj.view.ViewContext;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.ListCellRenderer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class SubgroupSelectionPanel
extends JPanel {
    private Gedcom gedcom;
    private ActionSaveViewAsGedcom extractAction;
    private FamilyGroupsPlugin.FamilyGroupFilter[] data;
    private ActionSaveViewAsGedcom extractGroupsAction;
    private FamilyGroupsPlugin.FamilyGroupFilter groupsFilter;
    private JCheckBox allCheckBox;
    private JButton displayButton;
    private JButton exportButton;
    private JButton exportGroupsButton;
    private JTable generationTable;
    private JList<FamilyGroupsPlugin.FamilyGroupFilter> groupList;
    private JLabel jLabel1;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane3;
    private JSplitPane jSplitPane1;
    private JTabbedPane jTabbedPane1;
    private JButton markButton;
    private JList<FamilyGroupsPlugin.SubgroupInfo> subgroupList;
    private JButton unmarkButton;

    public SubgroupSelectionPanel(Gedcom gedcom, List<FamilyGroupsPlugin.FamilyGroupFilter> filters, ActionSaveViewAsGedcom extractAction, FamilyGroupsPlugin.FamilyGroupFilter groupsFilter, ActionSaveViewAsGedcom extractGroupsAction) {
        this.gedcom = gedcom;
        this.extractAction = extractAction;
        this.data = filters.toArray(new FamilyGroupsPlugin.FamilyGroupFilter[0]);
        this.initComponents();
        this.extractGroupsAction = extractGroupsAction;
        this.groupsFilter = groupsFilter;
        this.groupList.setSelectedIndex(0);
    }

    private void initComponents() {
        this.jSplitPane1 = new JSplitPane();
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.groupList = new JList<FamilyGroupsPlugin.FamilyGroupFilter>(this.data);
        this.jPanel2 = new JPanel();
        this.jTabbedPane1 = new JTabbedPane();
        this.jScrollPane2 = new JScrollPane();
        this.subgroupList = new JList();
        this.jScrollPane3 = new JScrollPane();
        this.generationTable = new JTable();
        this.allCheckBox = new JCheckBox();
        this.exportButton = new JButton();
        this.markButton = new JButton();
        this.unmarkButton = new JButton();
        this.displayButton = new JButton();
        this.exportGroupsButton = new JButton();
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(SubgroupSelectionPanel.class, (String)"SubgroupSelectionPanel.jLabel1.text"));
        this.groupList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                SubgroupSelectionPanel.this.groupListValueChanged(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.groupList);
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 493, Short.MAX_VALUE).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel1).addContainerGap(-1, Short.MAX_VALUE)))));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 257, Short.MAX_VALUE)));
        this.jSplitPane1.setLeftComponent(this.jPanel1);
        this.jTabbedPane1.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                SubgroupSelectionPanel.this.jTabbedPane1StateChanged(evt);
            }
        });
        this.subgroupList.setSelectionMode(0);
        this.subgroupList.setCellRenderer(new CheckListRenderer());
        this.subgroupList.setVisibleRowCount(13);
        this.subgroupList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                SubgroupSelectionPanel.this.subgroupListMouseClicked(evt);
            }
        });
        this.jScrollPane2.setViewportView(this.subgroupList);
        this.jTabbedPane1.addTab(NbBundle.getMessage(SubgroupSelectionPanel.class, (String)"SubgroupSelectionPanel.jScrollPane2.TabConstraints.tabTitle"), this.jScrollPane2);
        this.generationTable.setModel(new DefaultTableModel(new Object[0][], new String[0]));
        this.jScrollPane3.setViewportView(this.generationTable);
        this.jTabbedPane1.addTab(NbBundle.getMessage(SubgroupSelectionPanel.class, (String)"SubgroupSelectionPanel.jScrollPane3.TabConstraints.tabTitle"), this.jScrollPane3);
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTabbedPane1, -1, 442, Short.MAX_VALUE));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTabbedPane1, -1, 278, Short.MAX_VALUE));
        this.jTabbedPane1.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SubgroupSelectionPanel.class, (String)"SubgroupSelectionPanel.jTabbedPane1.AccessibleContext.accessibleName"));
        this.jSplitPane1.setRightComponent(this.jPanel2);
        this.allCheckBox.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.allCheckBox, (String)NbBundle.getMessage(SubgroupSelectionPanel.class, (String)"SubgroupSelectionPanel.allCheckBox.text"));
        this.allCheckBox.setToolTipText(NbBundle.getMessage(SubgroupSelectionPanel.class, (String)"SubgroupSelectionPanel.allCheckBox.toolTipText"));
        this.allCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SubgroupSelectionPanel.this.allCheckBoxActionPerformed(evt);
            }
        });
        this.exportButton.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/familygroups/Export.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.exportButton, (String)NbBundle.getMessage(SubgroupSelectionPanel.class, (String)"SubgroupSelectionPanel.exportButton.text"));
        this.exportButton.setToolTipText(NbBundle.getMessage(SubgroupSelectionPanel.class, (String)"SubgroupSelectionPanel.exportButton.toolTipText"));
        this.exportButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SubgroupSelectionPanel.this.exportButtonActionPerformed(evt);
            }
        });
        this.markButton.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/familygroups/MarkingIcon.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.markButton, (String)NbBundle.getMessage(SubgroupSelectionPanel.class, (String)"SubgroupSelectionPanel.markButton.text"));
        this.markButton.setToolTipText(NbBundle.getMessage(SubgroupSelectionPanel.class, (String)"SubgroupSelectionPanel.markButton.toolTipText"));
        this.markButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SubgroupSelectionPanel.this.markButtonActionPerformed(evt);
            }
        });
        this.unmarkButton.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/familygroups/Clean.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.unmarkButton, (String)NbBundle.getMessage(SubgroupSelectionPanel.class, (String)"SubgroupSelectionPanel.unmarkButton.text"));
        this.unmarkButton.setToolTipText(NbBundle.getMessage(SubgroupSelectionPanel.class, (String)"SubgroupSelectionPanel.unmarkButton.toolTipText"));
        this.unmarkButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SubgroupSelectionPanel.this.unmarkButtonActionPerformed(evt);
            }
        });
        this.displayButton.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/familygroups/List.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.displayButton, (String)NbBundle.getMessage(SubgroupSelectionPanel.class, (String)"SubgroupSelectionPanel.displayButton.text"));
        this.displayButton.setToolTipText(NbBundle.getMessage(SubgroupSelectionPanel.class, (String)"SubgroupSelectionPanel.displayButton.toolTipText"));
        this.displayButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SubgroupSelectionPanel.this.displayButtonActionPerformed(evt);
            }
        });
        this.exportGroupsButton.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/familygroups/Export.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.exportGroupsButton, (String)NbBundle.getMessage(SubgroupSelectionPanel.class, (String)"SubgroupSelectionPanel.exportGroupsButton.text"));
        this.exportGroupsButton.setToolTipText(NbBundle.getMessage(SubgroupSelectionPanel.class, (String)"SubgroupSelectionPanel.exportGroupsButton.toolTipText"));
        this.exportGroupsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SubgroupSelectionPanel.this.exportGroupsButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSplitPane1).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.exportGroupsButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.allCheckBox).addGap(18, 18, 18).addComponent(this.exportButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.markButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.unmarkButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.displayButton))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jSplitPane1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.exportButton).addComponent(this.markButton).addComponent(this.allCheckBox).addComponent(this.unmarkButton).addComponent(this.displayButton).addComponent(this.exportGroupsButton)).addContainerGap()));
    }

    private void groupListValueChanged(ListSelectionEvent evt) {
        if (!evt.getValueIsAdjusting()) {
            FamilyGroupsPlugin.FamilyGroupFilter filter = this.groupList.getSelectedValue();
            List<FamilyGroupsPlugin.SubgroupInfo> subgroups = filter.getSubgroups();
            this.subgroupList.setListData((FamilyGroupsPlugin.SubgroupInfo[])subgroups.toArray(new FamilyGroupsPlugin.SubgroupInfo[0]));
            DefaultTableModel tableModel = new DefaultTableModel(filter.getGenerationsData(), filter.getGenerationsTitles()){

                @Override
                public boolean isCellEditable(int row, int column) {
                    return false;
                }
            };
            this.generationTable.setModel(tableModel);
            if (tableModel.getRowCount() > 0) {
                this.generationTable.setRowSelectionInterval(0, 0);
            }
        }
    }

    private void subgroupListMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() == 1) {
            FamilyGroupsPlugin.SubgroupInfo subgroup;
            subgroup.setSelected(!(subgroup = this.subgroupList.getSelectedValue()).isSelected());
            this.subgroupList.repaint();
            this.reset();
        }
    }

    private void allCheckBoxActionPerformed(ActionEvent evt) {
        FamilyGroupsPlugin.FamilyGroupFilter filter = this.groupList.getSelectedValue();
        List<FamilyGroupsPlugin.SubgroupInfo> subgroups = filter.getSubgroups();
        for (FamilyGroupsPlugin.SubgroupInfo subgroup : subgroups) {
            subgroup.setSelected(this.allCheckBox.isSelected());
        }
        this.subgroupList.repaint();
        this.reset();
    }

    private void exportButtonActionPerformed(ActionEvent evt) {
        this.exportFilter(this.groupList.getSelectedValue());
    }

    private void markButtonActionPerformed(ActionEvent evt) {
        this.markFilter(this.groupList.getSelectedValue());
    }

    private void unmarkButtonActionPerformed(ActionEvent evt) {
        this.unmarkFilter(this.groupList.getSelectedValue());
    }

    private void displayButtonActionPerformed(ActionEvent evt) {
        if (this.isSubgroupOn()) {
            this.displayFilter(this.groupList.getSelectedValue());
        } else {
            this.displayGeneration(this.groupList.getSelectedValue());
        }
    }

    private void jTabbedPane1StateChanged(ChangeEvent evt) {
        boolean on = this.isSubgroupOn();
        this.allCheckBox.setVisible(on);
        this.exportButton.setVisible(on);
        this.markButton.setVisible(on);
        this.unmarkButton.setVisible(on);
    }

    private void exportGroupsButtonActionPerformed(ActionEvent evt) {
        ArrayList<Indi> selectedIndis = new ArrayList<Indi>();
        List<FamilyGroupsPlugin.FamilyGroupFilter> selectedFilters = this.groupList.getSelectedValuesList();
        selectedFilters.stream().map(f -> f.getSubgroups()).forEachOrdered(sgs -> sgs.stream().filter(g -> g.isSelected()).forEachOrdered(g -> selectedIndis.addAll(g.getIndis())));
        this.groupsFilter.setList(selectedIndis);
        this.extractGroupsAction.refreshNames();
        this.extractGroupsAction.actionPerformed(evt);
    }

    private void reset() {
        FamilyGroupsPlugin.FamilyGroupFilter filter = this.groupList.getSelectedValue();
        filter.reset();
        this.extractAction.refreshNames();
        this.groupList.repaint();
        this.enableButtons(filter);
    }

    private void enableButtons(FamilyGroupsPlugin.FamilyGroupFilter filter) {
        boolean isSelected = false;
        for (FamilyGroupsPlugin.SubgroupInfo subgroup : filter.getSubgroups()) {
            isSelected |= subgroup.isSelected();
        }
        this.exportButton.setEnabled(isSelected);
        this.markButton.setEnabled(isSelected);
        this.unmarkButton.setEnabled(isSelected);
        this.displayButton.setEnabled(isSelected);
    }

    private void exportFilter(FamilyGroupsPlugin.FamilyGroupFilter filter) {
        ActionSaveViewAsGedcom.exportFilter((Gedcom)this.gedcom, (Filter)filter);
    }

    private void markFilter(FamilyGroupsPlugin.FamilyGroupFilter filter) {
        ActionMark.markFilter(this.gedcom, filter);
    }

    private void unmarkFilter(FamilyGroupsPlugin.FamilyGroupFilter filter) {
        ActionMark.unmarkFilter(this.gedcom, filter);
    }

    private boolean isSubgroupOn() {
        return this.jTabbedPane1.getSelectedIndex() == 0;
    }

    private void displayFilter(FamilyGroupsPlugin.FamilyGroupFilter filter) {
        ArrayList<Context> contextList = new ArrayList<Context>();
        filter.getSubgroups().stream().filter(subgroup -> subgroup.isSelected()).forEachOrdered(subgroup -> subgroup.getIndis().stream().sorted().map(indi -> new ViewContext((Entity)indi).setText(indi.getDisplayTitle(true)).setCode(subgroup.key)).forEachOrdered(vc -> contextList.add((Context)vc)));
        this.displayContextList(contextList, NbBundle.getMessage(SubgroupSelectionPanel.class, (String)"SubgroupSelectionPanel.list.title1"), NbBundle.getMessage(SubgroupSelectionPanel.class, (String)"SubgroupSelectionPanel.list.tip1", (Object)filter.getFilterName()));
    }

    private void displayGeneration(FamilyGroupsPlugin.FamilyGroupFilter filter) {
        int gen = this.generationTable.getSelectedRow();
        ArrayList<Context> contextList = new ArrayList<Context>();
        filter.getGeneration(gen).forEach(indi -> contextList.add((Context)new ViewContext((Entity)indi).setText(indi.getDisplayTitle(true))));
        this.displayContextList(contextList, NbBundle.getMessage(SubgroupSelectionPanel.class, (String)"SubgroupSelectionPanel.list.title2"), NbBundle.getMessage(SubgroupSelectionPanel.class, (String)"SubgroupSelectionPanel.list.tip2", (Object)filter.getGenerationsData()[gen][0]));
    }

    private void displayContextList(List<Context> contextList, String title, String tip) {
        Collections.sort(contextList, new Comparator(){

            public int compare(Object o1, Object o2) {
                Context c1 = (Context)o1;
                Context c2 = (Context)o2;
                return c1.getEntity().getDisplayComparator().compare((Object)c1.getEntity(), (Object)c2.getEntity());
            }
        });
        ContextListWidget object = new ContextListWidget(contextList);
        new WidgetDocumentView(new Context(this.gedcom), title, tip, (JComponent)object);
    }

    private class CheckListRenderer
    extends JCheckBox
    implements ListCellRenderer {
        private CheckListRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean hasFocus) {
            this.setText(value.toString());
            this.setOpaque(true);
            if (isSelected) {
                this.setBackground(new Color(list.getSelectionBackground().getRGB()));
                this.setForeground(new Color(list.getSelectionForeground().getRGB()));
            } else {
                this.setBackground(new Color(list.getBackground().getRGB()));
                this.setForeground(new Color(list.getForeground().getRGB()));
            }
            this.setSelected(((FamilyGroupsPlugin.SubgroupInfo)value).isSelected());
            this.setEnabled(((FamilyGroupsPlugin.SubgroupInfo)value).getNbIndis() > 0);
            if (((FamilyGroupsPlugin.SubgroupInfo)value).getNbIndis() == 0) {
                this.setSelected(false);
            }
            return this;
        }
    }
}

