/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.webbook;

import ancestris.core.actions.AbstractAncestrisContextAction;
import ancestris.modules.webbook.WebBookStarter;
import ancestris.modules.webbook.WebBookWizardPanel1;
import ancestris.modules.webbook.WebBookWizardPanel2;
import ancestris.modules.webbook.WebBookWizardPanel3;
import ancestris.modules.webbook.WebBookWizardPanel4;
import ancestris.modules.webbook.WebBookWizardPanel5;
import ancestris.modules.webbook.WebBookWizardPanel6;
import ancestris.modules.webbook.WebBookWizardPanel7;
import ancestris.modules.webbook.WebBookWizardPanel8;
import genj.gedcom.Context;
import genj.gedcom.Gedcom;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import javax.swing.JComponent;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.WizardDescriptor;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

public final class WebBookWizardAction
extends AbstractAncestrisContextAction {
    private WizardDescriptor.Panel[] panels;

    public WebBookWizardAction() {
        this.setIconBase("ancestris/modules/webbook/WebBook.png");
        this.setText(NbBundle.getMessage(WebBookWizardAction.class, (String)"CTL_WebBookAction"));
    }

    protected void contextChanged() {
        this.setEnabled(!this.contextProperties.isEmpty());
        super.contextChanged();
    }

    protected void actionPerformedImpl(ActionEvent event) {
        Gedcom gedcom;
        Context contextToOpen = this.getContext();
        if (contextToOpen != null && (gedcom = contextToOpen.getGedcom()) != null) {
            boolean cancelled;
            WizardDescriptor wizardDescriptor = new WizardDescriptor(this.getPanels(gedcom));
            wizardDescriptor.setTitleFormat(new MessageFormat("{0}"));
            wizardDescriptor.setTitle(NbBundle.getMessage(WebBookWizardAction.class, (String)"CTL_WebBookTitle") + " - " + gedcom.getDisplayName());
            Dialog dialog = DialogDisplayer.getDefault().createDialog((DialogDescriptor)wizardDescriptor);
            dialog.setVisible(true);
            dialog.toFront();
            boolean bl = cancelled = wizardDescriptor.getValue() != WizardDescriptor.FINISH_OPTION;
            if (!cancelled) {
                WebBookStarter wbs = new WebBookStarter(gedcom);
                wbs.start();
            }
            this.panels = null;
        }
    }

    private WizardDescriptor.Panel[] getPanels(Gedcom gedcom) {
        if (this.panels == null) {
            this.panels = new WizardDescriptor.Panel[]{new WebBookWizardPanel1(gedcom), new WebBookWizardPanel2(gedcom), new WebBookWizardPanel3(gedcom), new WebBookWizardPanel4(gedcom), new WebBookWizardPanel5(gedcom), new WebBookWizardPanel6(gedcom), new WebBookWizardPanel7(gedcom), new WebBookWizardPanel8(gedcom)};
            String[] steps = new String[this.panels.length];
            for (int i = 0; i < this.panels.length; ++i) {
                Component c = this.panels[i].getComponent();
                steps[i] = c.getName();
                if (!(c instanceof JComponent)) continue;
                JComponent jc = (JComponent)c;
                jc.putClientProperty("WizardPanel_contentSelectedIndex", i);
                jc.putClientProperty("WizardPanel_contentData", steps);
                jc.putClientProperty("WizardPanel_autoWizardStyle", Boolean.TRUE);
                jc.putClientProperty("WizardPanel_contentDisplayed", Boolean.TRUE);
                jc.putClientProperty("WizardPanel_contentNumbered", Boolean.TRUE);
                jc.putClientProperty("WizardPanel_image", ImageUtilities.loadImage((String)NbBundle.getMessage(WebBookWizardAction.class, (String)"CTL_WebBookBckImage")));
            }
        }
        return this.panels;
    }

    public String getName() {
        return NbBundle.getMessage(WebBookWizardAction.class, (String)"CTL_WebBookAction");
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }
}

