/*
 * Decompiled with CFR 0.152.
 */
package genj.renderer.views;

import ancestris.util.Utilities;
import genj.gedcom.Entity;
import genj.gedcom.MultiLineProperty;
import genj.gedcom.Property;
import genj.gedcom.PropertyBlob;
import genj.gedcom.PropertyChange;
import genj.gedcom.PropertyDate;
import genj.gedcom.PropertyFile;
import genj.gedcom.PropertyPlace;
import genj.gedcom.PropertySex;
import genj.gedcom.TagPath;
import genj.renderer.BlueprintRenderer;
import genj.renderer.MediaRenderer;
import genj.renderer.views.MyView;
import genj.util.Dimension2d;
import genj.util.swing.ImageIcon;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.Element;

public class PropertyView
extends MyView {
    private static final Logger LOG = Logger.getLogger("ancestris.renderer");
    private static final Stroke DEBUG_STROKE = new BasicStroke(1.0f, 2, 0, 10.0f, new float[]{1.0f, 2.0f}, 0.0f);
    private static final String STARS = "*****";
    private static final int IMAGE_GAP = 4;
    private static final String HINT_KEY_TXT = "txt";
    private static final String HINT_KEY_IMG = "img";
    private static final String HINT_KEY_SHORT = "short";
    private static final String HINT_VALUE_TRUE = "yes";
    private static final String HINT_VALUE_FALSE = "no";
    private final Map<String, String> attributes = new HashMap<String, String>();
    private String path = null;
    private String elsePath = null;
    private Property cachedProperty = null;
    private Dimension2D cachedSize = null;

    public PropertyView(Element elem, BlueprintRenderer rdr) {
        super(elem, rdr);
        Enumeration<?> as = elem.getAttributes().getAttributeNames();
        while (as.hasMoreElements()) {
            Object key = as.nextElement();
            if (!(key instanceof String)) continue;
            this.attributes.put((String)key, (String)elem.getAttributes().getAttribute(key));
        }
        this.path = this.attributes.get("path");
        this.elsePath = this.attributes.get("default");
    }

    private Property getProperty(String thePath) {
        if (this.cachedProperty != null) {
            return this.cachedProperty;
        }
        Property entity = this.getRenderer().getEntity();
        if (entity == null || thePath == null || thePath.isEmpty()) {
            return null;
        }
        try {
            Property p = entity.getProperty(this.createPath(thePath));
            if (p == null) {
                return null;
            }
            this.cachedProperty = p;
        }
        catch (NullPointerException e) {
            return null;
        }
        return this.cachedProperty;
    }

    private TagPath createPath(String thePath) {
        try {
            return new TagPath(thePath, true);
        }
        catch (IllegalArgumentException e) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.log(Level.FINER, "got wrong path {0}", thePath);
            }
            return null;
        }
    }

    private Property getProperty() {
        Property prop = this.getProperty(this.path);
        if (prop == null) {
            prop = this.getProperty(this.elsePath);
        }
        return prop;
    }

    @Override
    public void paint(Graphics g, Shape allocation) {
        Property prop = this.getProperty();
        if (prop == null) {
            return;
        }
        Graphics2D graphics = (Graphics2D)g;
        Rectangle r = allocation instanceof Rectangle ? (Rectangle)allocation : allocation.getBounds();
        Color fg = super.getForeground();
        if (this.getRenderer().isIsDebug()) {
            Stroke stroke = graphics.getStroke();
            graphics.setStroke(DEBUG_STROKE);
            g.setColor(new Color(fg.getRed(), fg.getGreen(), fg.getBlue(), 32));
            graphics.draw(r);
            graphics.setStroke(stroke);
        }
        Shape old = graphics.getClip();
        graphics.clip(r);
        g.setColor(fg);
        g.setFont(super.getFont());
        this.render(prop, graphics, r);
        g.setClip(old);
    }

    private void render(Property prop, Graphics2D g, Rectangle r) {
        if (prop instanceof PropertyChange) {
            this.render(this.getText(prop), g, r);
            return;
        }
        if (!(prop instanceof Entity) && prop instanceof MultiLineProperty) {
            this.render((MultiLineProperty)((Object)prop), g, r);
            return;
        }
        if (prop instanceof PropertyFile || prop instanceof PropertyBlob) {
            MediaRenderer.render(g, r, prop);
            return;
        }
        if (HINT_VALUE_TRUE.equals(this.attributes.get(HINT_KEY_IMG)) && prop != null && prop.getParent() != null) {
            this.render(prop instanceof PropertyDate ? prop.getParent().getImage(false) : prop.getImage(false), g, r);
        }
        if (!HINT_VALUE_FALSE.equals(this.attributes.get(HINT_KEY_TXT))) {
            this.render(this.getText(prop), g, r);
        }
    }

    private void render(MultiLineProperty mle, Graphics2D g, Rectangle r) {
        MultiLineProperty.Iterator line = mle.getLineIterator(true);
        Graphics2D graphics = g;
        Font font = g.getFont();
        FontRenderContext context = graphics.getFontRenderContext();
        float x = (float)r.getX();
        float y = (float)r.getY();
        do {
            String txt = line.getValue();
            LineMetrics lm = font.getLineMetrics(txt, context);
            graphics.drawString(txt, x, (y += lm.getHeight()) - lm.getDescent());
        } while (!((double)y > r.getMaxY()) && line.next());
    }

    private void render(ImageIcon img, Graphics2D g, Rectangle bounds) {
        if (bounds.getHeight() == 0.0 || bounds.getWidth() == 0.0) {
            return;
        }
        int w = img.getIconWidth();
        int max = g.getFontMetrics().getHeight();
        AffineTransform at = AffineTransform.getTranslateInstance(bounds.getX(), bounds.getY());
        if (max < img.getIconHeight()) {
            float scale = (float)max / (float)img.getIconHeight();
            at.scale(scale, scale);
            w = (int)Math.ceil((float)w * scale);
        }
        g.drawImage(img.getImage(), at, null);
        bounds.x += w + 4;
        bounds.width -= w + 4;
    }

    private String getText(Property prop) {
        if (prop instanceof Entity) {
            return this.getText((Entity)prop);
        }
        if (prop.isPrivate()) {
            return STARS;
        }
        if (prop instanceof PropertyPlace) {
            return this.getText((PropertyPlace)prop);
        }
        if (prop instanceof PropertySex) {
            return this.getText((PropertySex)prop);
        }
        if (this.attributes.get("format") != null) {
            return prop.format(this.attributes.get("format"));
        }
        return prop.getDisplayValue();
    }

    private String getText(Entity entity) {
        if (this.attributes.get("format") != null) {
            return entity.format(this.attributes.get("format"));
        }
        return entity.getId();
    }

    private String getText(PropertySex sex) {
        String result;
        if (!this.attributes.containsKey(HINT_KEY_TXT)) {
            this.attributes.put(HINT_KEY_TXT, HINT_VALUE_FALSE);
        }
        if (!this.attributes.containsKey(HINT_KEY_IMG)) {
            this.attributes.put(HINT_KEY_IMG, HINT_VALUE_TRUE);
        }
        if ((result = sex.getDisplayValue()).length() > 0 && HINT_VALUE_TRUE.equals(this.attributes.get(HINT_KEY_SHORT))) {
            result = result.substring(0, 1);
        }
        return result;
    }

    private String getText(PropertyPlace place) {
        return Utilities.html2text(place.format(this.attributes.get("format")));
    }

    @Override
    protected Dimension2D getPreferredSpan() {
        if (this.cachedSize != null) {
            return this.cachedSize;
        }
        this.cachedSize = this.getSize();
        return this.cachedSize;
    }

    private Dimension2D getSize() {
        Property prop = this.getProperty();
        if (prop == null) {
            return new Dimension();
        }
        if (prop instanceof PropertyChange) {
            return this.getSize(prop);
        }
        if (!(prop instanceof Entity) && prop instanceof MultiLineProperty) {
            return this.getSize((MultiLineProperty)((Object)prop));
        }
        if (prop instanceof PropertyFile || prop instanceof PropertyBlob) {
            return MediaRenderer.getSize(prop);
        }
        return this.getSize(prop);
    }

    private Dimension2D getSize(Property prop) {
        String txt = this.getText(prop);
        double w = 0.0;
        double h = 0.0;
        this.getRenderer().getGraphics().setFont(super.getFont());
        FontMetrics fm = this.getRenderer().getGraphics().getFontMetrics();
        if (!HINT_VALUE_FALSE.equals(this.attributes.get(HINT_KEY_TXT)) && txt.length() > 0) {
            w += (double)fm.stringWidth(txt);
            h = Math.max(h, (double)(fm.getAscent() + fm.getDescent()));
        }
        if (HINT_VALUE_TRUE.equals(this.attributes.get(HINT_KEY_IMG))) {
            ImageIcon img = prop.getImage(false);
            float max = fm.getHeight();
            float scale = 1.0f;
            if (max < (float)img.getIconHeight()) {
                scale = max / (float)img.getIconHeight();
            }
            w += (double)((int)Math.ceil((float)img.getIconWidth() * scale) + 4);
            h = Math.max(h, (double)fm.getHeight());
        }
        return new Dimension2d(w, h);
    }

    private Dimension2D getSize(MultiLineProperty mle) {
        this.getRenderer().getGraphics().setFont(super.getFont());
        FontMetrics fm = this.getRenderer().getGraphics().getFontMetrics();
        double width = 0.0;
        double height = 0.0;
        MultiLineProperty.Iterator line = mle.getLineIterator(true);
        do {
            width = Math.max(width, (double)fm.stringWidth(line.getValue()));
            height += (double)fm.getHeight();
        } while (line.next());
        return new Dimension2d(width, height);
    }

    @Override
    public void invalidate() {
        this.cachedProperty = null;
        this.cachedSize = null;
        super.invalidate();
    }
}

