/*
 * Decompiled with CFR 0.152.
 */
package genj.io.input;

import genj.io.InputSource;
import genj.io.input.URLChecker;
import genj.util.EnvironmentChecker;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.logging.Level;
import java.util.logging.Logger;

public class URLInput
extends InputSource {
    private static final Logger LOG = Logger.getLogger("ancestris.URLInput");
    public static final String WEB = "web";
    private URL url;
    private String extension;
    private boolean hasExistenceBeenChecked = false;
    private boolean isFound = false;

    public URLInput(URL theUrl) {
        this(theUrl.getFile(), theUrl);
    }

    public URLInput(String name, URL theUrl) {
        super(name);
        this.url = theUrl;
        this.setLocation(theUrl.toString());
    }

    public URL getURL() {
        return this.url;
    }

    @Override
    public InputStream open() throws IOException {
        InputStream in = null;
        if (!this.hasExistenceBeenChecked) {
            this.checkAvailability();
        }
        if (this.isFound) {
            try {
                in = this.url.openStream();
            }
            catch (IOException ex) {
                LOG.log(Level.WARNING, "Unable to open remote address " + this.url.toString(), ex.getLocalizedMessage());
                this.isFound = false;
            }
        }
        return in;
    }

    public int hashCode() {
        return this.url.hashCode() * this.getName().hashCode();
    }

    public String toString() {
        return "file name=" + this.getName() + " url=" + this.url.toString();
    }

    @Override
    public String getExtension() {
        if (this.extension == null) {
            this.extension = this.setExtension();
        }
        return this.extension;
    }

    private String setExtension() {
        if (!this.hasExistenceBeenChecked) {
            this.checkAvailability();
        }
        if (!this.isFound) {
            return WEB;
        }
        try {
            String type = URLConnection.guessContentTypeFromStream(this.url.openStream());
            LOG.log(Level.FINER, "Media " + this.getName() + " type from internet (guessed) : " + type);
            if (type == null) {
                type = this.url.openConnection().getContentType();
                if (type == null) {
                    return WEB;
                }
                LOG.log(Level.FINER, "Media " + this.getName() + " type from internet (checked) : " + type);
            }
            if (type.startsWith("image/")) {
                String extension = type.substring(6);
                if ("jpeg".equals(extension)) {
                    return "jpg";
                }
                return extension;
            }
            if (type.equals("application/pdf")) {
                return "pdf";
            }
            return WEB;
        }
        catch (IOException ex) {
            LOG.log(Level.WARNING, "(setExtension) Unable to open remote address stream " + this.url.toString(), ex.getLocalizedMessage());
            this.isFound = false;
            return WEB;
        }
    }

    @Override
    public boolean isAvailable() {
        if (!this.hasExistenceBeenChecked) {
            this.checkAvailability();
        }
        return this.isFound;
    }

    public boolean isAvailable(boolean force) {
        if (force) {
            this.checkAvailability();
        }
        return this.isFound;
    }

    private void checkAvailability() {
        if (!EnvironmentChecker.isConnected(true)) {
            this.isFound = false;
            return;
        }
        URLChecker checker = URLChecker.createURLChecker(this.url, "", 0);
        URLChecker.CheckResult check = checker.run();
        this.isFound = check.getResult();
        if (this.isFound && check.getURL() != null) {
            this.url = check.getURL();
        }
        this.hasExistenceBeenChecked = true;
    }
}

