/*
 * Decompiled with CFR 0.152.
 */
package genj.io;

import genj.gedcom.Entity;
import genj.gedcom.MultiLineProperty;
import genj.gedcom.Property;
import genj.gedcom.PropertyDate;
import genj.gedcom.PropertyXRef;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PropertyWriter {
    private static final Pattern P_ESCAPE = Pattern.compile("@#[^@]+@");
    boolean useIndents = false;
    private int lines = 0;
    private BufferedWriter out;
    private boolean isConcFile;

    public PropertyWriter(Writer out, boolean useIndents, boolean isConcFile) {
        this.out = new BufferedWriter(out);
        this.useIndents = useIndents;
        this.isConcFile = isConcFile;
    }

    public int write(int level, Property prop) throws IOException {
        this.writeProperty(level, prop);
        this.out.flush();
        return this.lines;
    }

    public int getLines() {
        return this.lines;
    }

    protected String getValue(Property prop) throws IOException {
        return prop.getValue();
    }

    protected void writeProperty(int level, Property prop) throws IOException {
        if (prop.isTransient()) {
            return;
        }
        if (prop.isGuessed()) {
            return;
        }
        if (prop instanceof MultiLineProperty) {
            this.writeMultiLine(level, prop);
        } else if (prop instanceof PropertyXRef || prop instanceof PropertyDate) {
            this.writeLine(level, this.getTag(prop), this.getValue(prop));
        } else {
            String value = this.getValue(prop);
            this.writeLine(level, this.getTag(prop), this.escapeValue(value));
        }
        int num = prop.getNoOfProperties();
        for (int i = 0; i < num; ++i) {
            this.writeProperty(level + 1, prop.getProperty(i));
        }
    }

    private String escapeValue(String valeur) {
        String value = this.escapeEndLine(valeur);
        Matcher m = P_ESCAPE.matcher(value);
        if (!m.find()) {
            return this.isConcFile ? value.replaceAll("@", "@@") : value;
        }
        ArrayList<String> matc = new ArrayList<String>();
        m.reset();
        while (m.find()) {
            matc.add(m.group());
        }
        String[] split = P_ESCAPE.split(value);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < split.length; ++i) {
            sb.append(this.isConcFile ? split[i].replaceAll("@", "@@") : split[i]);
            if (i >= matc.size()) continue;
            sb.append((String)matc.get(i));
        }
        return sb.toString();
    }

    private String escapeEndLine(String valeur) {
        return valeur.replaceAll("\r", "");
    }

    protected String getTag(Property prop) {
        String xref;
        if (prop instanceof Entity && (xref = ((Entity)prop).getId()).length() > 0) {
            return '@' + xref + "@ " + prop.getTag();
        }
        return prop.getTag();
    }

    private void writeMultiLine(int level, Property prop) throws IOException {
        MultiLineProperty.Iterator lines = ((MultiLineProperty)((Object)prop)).getLineIterator(this.isConcFile);
        lines.setValue(this.escapeValue(this.getValue(prop)));
        this.writeLine(level + lines.getIndent(), this.getTag(prop), lines.getValue());
        while (lines.next()) {
            this.writeLine(level + lines.getIndent(), lines.getTag(), lines.getValue());
        }
    }

    private void writeLine(int level, String tag, String value) throws IOException {
        if (this.useIndents) {
            for (int i = 0; i < level; ++i) {
                this.out.write(32);
            }
        } else {
            this.out.write(Integer.toString(level));
            this.out.write(32);
        }
        this.out.write(tag);
        if (value != null && value.length() > 0) {
            this.out.write(32);
            this.out.write(value);
        }
        this.out.newLine();
        ++this.lines;
    }
}

