/*
 * Decompiled with CFR 0.152.
 */
package genj.gedcom.time;

import genj.gedcom.GedcomException;
import genj.gedcom.time.Calendar;
import genj.gedcom.time.GregorianCalendar;
import genj.gedcom.time.PointInTime;

public class FrenchRCalendar
extends Calendar {
    private static final int AN_0 = 2375474;
    private static final int AN_I = new GregorianCalendar().toJulianDay(21, 8, 1792);
    private static final int UNTIL = new GregorianCalendar().toJulianDay(0, 0, 1806);
    private static final String[] MONTHS = new String[]{"VEND", "BRUM", "FRIM", "NIVO", "PLUV", "VENT", "GERM", "FLOR", "PRAI", "MESS", "THER", "FRUC", "COMP"};
    private static final String[] WEEKDAYS = new String[]{"PRI", "DUO", "TRI", "QUA", "QUI", "SEX", "SEP", "OCT", "NON", "DEC", "VER", "GEN", "TRA", "OPI", "REC", "REV"};
    private static final int[] LEAP_YEARS = new int[]{3, 7, 11};
    private static final String YEARS_PREFIX = "An ";
    private static final String[] YEARS = new String[]{"I", "II", "III", "IV", "V", "VI", "VII", "VIII", "IX", "X", "XI", "XII", "XIII", "XIV"};
    private static final int DAYS_PER_MONTH = 30;
    private static final int DAYS_PER_4_YEARS = 1461;

    protected FrenchRCalendar() {
        super("@#DFRENCH R@", "french", "images/FrenchR", MONTHS, WEEKDAYS);
    }

    @Override
    public int getDays(int month, int year) {
        if (month < 12) {
            return 30;
        }
        return this.isLeap(year) ? 6 : 5;
    }

    private boolean isLeap(int year) {
        return (year + 1) % 4 == 0;
    }

    @Override
    protected String getDayOfWeek(PointInTime pit, boolean localize) throws GedcomException {
        String[] result;
        if (!pit.isComplete()) {
            throw new GedcomException("");
        }
        String[] stringArray = result = localize ? this.localizedWeekDays : this.weekDays;
        if (pit.getMonth() == 12) {
            return result[10 + pit.getDay()];
        }
        return result[pit.getDay() % 10];
    }

    @Override
    protected int toJulianDay(int day, int month, int year) throws GedcomException {
        int jd = year * 1461 / 4 + month * 30 + day + 1 + 2375474;
        if (jd < AN_I) {
            throw new GedcomException(resources.getString("frenchr.bef"));
        }
        if (jd >= UNTIL) {
            throw new GedcomException(resources.getString("frenchr.aft"));
        }
        return jd;
    }

    @Override
    protected PointInTime toPointInTime(int julianDay) throws GedcomException {
        if (julianDay < AN_I) {
            throw new GedcomException(resources.getString("frenchr.bef"));
        }
        if (julianDay >= UNTIL) {
            throw new GedcomException(resources.getString("frenchr.aft"));
        }
        int temp = (julianDay - 2375474) * 4 - 1;
        int year = temp / 1461;
        int dayOfYear = temp % 1461 / 4;
        int month = dayOfYear / 30 + 1;
        int day = dayOfYear % 30 + 1;
        return new PointInTime(day - 1, month - 1, year, this);
    }

    @Override
    public String getDisplayYear(int year) {
        if (year < 1 || year > YEARS.length) {
            return super.getDisplayYear(year);
        }
        return YEARS_PREFIX + YEARS[year - 1];
    }

    @Override
    public int getYear(String year) throws GedcomException {
        if (year.length() > YEARS_PREFIX.length() && year.substring(0, YEARS_PREFIX.length()).equalsIgnoreCase(YEARS_PREFIX)) {
            year = year.substring(YEARS_PREFIX.length());
        }
        for (int y = 0; y < YEARS.length; ++y) {
            if (!YEARS[y].equals(year)) continue;
            return y + 1;
        }
        return super.getYear(year);
    }
}

