/*
 * Decompiled with CFR 0.152.
 */
package genj.gedcom;

import ancestris.util.ComparableList;
import genj.gedcom.Property;
import genj.gedcom.PropertyComparator2;
import genj.gedcom.PropertyNumericValue;
import java.math.BigInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PropertyNumDaboville
extends PropertyNumericValue {
    private ComparableList<BigInteger> numbers = new ComparableList();

    public PropertyNumDaboville(String tag) {
        super(tag);
    }

    @Override
    public void setValue(String set) {
        super.setValue(set);
        this.calcNumbers(this.getValue(), this.numbers);
    }

    public ComparableList<BigInteger> getNumbersList() {
        return this.numbers;
    }

    protected void calcNumbers(String value, ComparableList<BigInteger> array) {
        Pattern numberPattern = Pattern.compile("([0-9]+[a-z]*)*");
        Pattern digitsPattern = Pattern.compile("^[0-9]+");
        Pattern marrPattern = Pattern.compile("[a-z]$");
        array.clear();
        Matcher m = numberPattern.matcher(value);
        while (m.find()) {
            Matcher mm;
            String bit = m.group();
            if (bit.isEmpty()) continue;
            char marr = 'a';
            Matcher md = digitsPattern.matcher(bit);
            if (md.find()) {
                BigInteger i1 = new BigInteger(md.group());
                array.add((BigInteger)i1);
            }
            if ((mm = marrPattern.matcher(bit)).find()) {
                marr = mm.group().charAt(0);
            }
            BigInteger i2 = new BigInteger(String.valueOf(Character.getNumericValue(marr)));
            array.add((BigInteger)i2);
        }
    }

    @Override
    public int compareTo(Property other) {
        PropertyNumericValue that = (PropertyNumericValue)other;
        if (that.value.getClass() != this.value.getClass()) {
            return super.compareTo(other);
        }
        int c = this.getNumbersList().compareTo((BigInteger)((Object)((PropertyNumDaboville)that).getNumbersList()));
        return c == 0 ? this.getValue().compareTo(that.getValue()) : c;
    }

    @Override
    public PropertyComparator2 getComparator() {
        return NUMDABOVILLEComparator.getInstance();
    }

    private static class NUMDABOVILLEComparator
    extends PropertyComparator2.Default<PropertyNumDaboville> {
        private static final NUMDABOVILLEComparator INSTANCE = new NUMDABOVILLEComparator();

        private NUMDABOVILLEComparator() {
        }

        public static PropertyComparator2 getInstance() {
            return INSTANCE;
        }

        @Override
        public int compare(PropertyNumDaboville nd1, PropertyNumDaboville nd2) {
            return nd1.compareTo(nd2);
        }

        @Override
        public String getSortGroup(PropertyNumDaboville p) {
            return String.valueOf(p.getNumbersList().size() / 2);
        }
    }
}

