/*
 * Decompiled with CFR 0.152.
 */
package genj.gedcom;

import ancestris.gedcom.GedcomDirectory;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomOptions;
import genj.gedcom.Grammar;
import genj.gedcom.Property;
import genj.gedcom.TagPath;
import genj.io.FileAssociation;
import genj.io.InputSource;
import genj.io.input.FileInput;
import genj.io.input.URLInput;
import genj.util.swing.ImageIcon;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.util.NbPreferences;

public class PropertyFile
extends Property {
    private static final Logger LOG = Logger.getLogger("ancestris.app");
    public static final ImageIcon DEFAULT_IMAGE = Grammar.V55.getMeta(new TagPath("INDI:OBJE:FILE")).getImage();
    private static final String FILE_PROTOCOLE = "file://";
    private String file;
    private boolean isLocal = true;
    private boolean isRemote = false;
    private boolean isFound = true;
    private boolean checkRemoteExistence = true;
    public static boolean suspendExistenceCheck = false;
    private Optional<InputSource> input = Optional.empty();

    public PropertyFile(String tag) {
        super(tag);
    }

    public boolean isIsLocal() {
        return this.isLocal;
    }

    public boolean isIsRemote() {
        return this.isRemote;
    }

    public boolean isFound() {
        return this.isFound;
    }

    public boolean isFound(boolean forceInput) {
        if (forceInput) {
            this.input = Optional.empty();
            this.forceInput();
        }
        return this.isFound;
    }

    private void setFound() {
        if (!suspendExistenceCheck && this.input.isPresent()) {
            this.isFound = this.input.get().isAvailable();
        }
    }

    @Override
    public boolean isValid() {
        if (!NbPreferences.forModule(Gedcom.class).getBoolean("isFileNotFoundValid", false)) {
            this.forceInput();
            return this.isFound;
        }
        return super.isValid();
    }

    @Override
    public boolean addFile(InputSource file) {
        this.setValue(file.getLocation(), true);
        return true;
    }

    @Override
    public String getValue() {
        String relative;
        if (this.file == null) {
            return "";
        }
        Gedcom gedcom = this.getGedcom();
        if (GedcomOptions.getInstance().isForceRelative() && gedcom != null && (relative = gedcom.getOrigin().calcRelativeLocation(this.file)) != null && !relative.equals(this.file)) {
            String old = this.file;
            this.file = relative;
            this.propagatePropertyChanged(this, old);
            return this.file;
        }
        if (gedcom != null && gedcom.isGrammar7()) {
            Optional<InputSource> ois = this.getInput();
            if (!ois.isPresent()) {
                return this.file;
            }
            InputSource is = ois.get();
            if (is instanceof FileInput) {
                return FILE_PROTOCOLE + this.file;
            }
        }
        return this.file;
    }

    @Override
    public synchronized void setValue(String value) {
        String old;
        String newValue = value;
        if (value.startsWith(FILE_PROTOCOLE)) {
            newValue = value.substring(7);
        }
        if (!value.equals(old = this.getValue())) {
            this.input = Optional.empty();
        }
        this.file = newValue.replace('\\', '/');
        this.forceInput();
        this.propagatePropertyChanged(this, old);
    }

    private void forceInput() {
        File fichier = this.getFile();
        if (fichier == null) {
            this.isLocal = false;
            this.isRemote = false;
            this.input = Optional.empty();
            this.isFound = false;
            return;
        }
        if (fichier.exists()) {
            this.isLocal = true;
            this.isFound = true;
            this.isRemote = false;
            this.input = InputSource.get(fichier);
            return;
        }
        try {
            URL remote = new URL(this.file);
            this.isLocal = false;
            this.isRemote = true;
            if (this.input.equals(Optional.empty())) {
                this.input = InputSource.get(remote);
                this.checkRemoteExistence = true;
            }
            if (GedcomDirectory.getDefault().isGedcomRegistered(this.getGedcom()) && this.checkRemoteExistence && !suspendExistenceCheck && !this.input.equals(Optional.empty())) {
                this.setFound();
                this.checkRemoteExistence = false;
            }
            return;
        }
        catch (MalformedURLException mfue) {
            LOG.log(Level.FINEST, "URL exception.", mfue.getLocalizedMessage());
            this.isLocal = false;
            this.isRemote = false;
            this.input = Optional.empty();
            this.isFound = false;
            return;
        }
    }

    public synchronized void setValueAsIs(String value) {
        String old = this.getValue();
        if (!value.equals(old)) {
            this.input = Optional.empty();
        }
        this.file = value.replace('\\', '/');
        this.propagatePropertyChanged(this, old);
    }

    public void setValue(String value, boolean updateMeta) {
        Property form;
        this.setValue(value);
        Property media = this.getParent();
        if (!updateMeta || !media.getTag().equals("OBJE")) {
            return;
        }
        Property parent = this;
        if (!this.getMetaProperty().allows("FORM")) {
            if (!media.getMetaProperty().allows("FORM")) {
                return;
            }
            parent = media;
        }
        if ((form = parent.getProperty("FORM", false)) == null) {
            parent.addProperty("FORM", this.getSuffix());
        } else {
            form.setValue(this.getSuffix());
        }
    }

    private File getFile() {
        Gedcom gedcom = this.getGedcom();
        return gedcom != null ? gedcom.getOrigin().getFile(this.file) : null;
    }

    public Optional<InputSource> getInput() {
        if (!this.input.isPresent()) {
            this.forceInput();
        }
        this.setFound();
        return this.input;
    }

    public static int getMaxValueAsIconSize(boolean kb) {
        return (kb ? 1 : 1024) * GedcomOptions.getInstance().getMaxImageFileSizeKB();
    }

    public String getSuffix() {
        this.getInput();
        if (this.input.isPresent()) {
            return this.input.get().getExtension();
        }
        return PropertyFile.getSuffix(this.file);
    }

    private static String getSuffix(String value) {
        int j;
        int i;
        String result = "";
        if (value != null && (i = value.lastIndexOf(46)) >= 0 && (j = (result = value.substring(i + 1)).indexOf(63)) > 0) {
            result = result.substring(0, j);
        }
        return result;
    }

    public boolean isOpenable() {
        Optional<InputSource> oInput = this.getInput();
        if (!oInput.isPresent()) {
            return false;
        }
        InputSource inputSource = oInput.get();
        return inputSource instanceof FileInput || inputSource instanceof URLInput;
    }

    public void openFile() {
        Optional<InputSource> oInput = this.getInput();
        if (!oInput.isPresent()) {
            return;
        }
        InputSource inputSource = oInput.get();
        if (inputSource instanceof FileInput) {
            FileAssociation.getDefault().execute(((FileInput)inputSource).getFile());
        }
        if (inputSource instanceof URLInput) {
            FileAssociation.getDefault().execute(((URLInput)inputSource).getURL());
        }
    }
}

