/*
 * Decompiled with CFR 0.152.
 */
package genj.gedcom;

import ancestris.core.TextOptions;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomException;
import genj.gedcom.GedcomOptions;
import genj.gedcom.Property;
import genj.gedcom.PropertyComparator2;
import genj.gedcom.time.Calendar;
import genj.gedcom.time.Delta;
import genj.gedcom.time.PointInTime;
import genj.util.DirectAccessTokenizer;
import genj.util.Resources;
import genj.util.WordBuffer;
import java.util.Locale;
import org.openide.util.NbPreferences;
import org.openide.util.Parameters;

public class PropertyDate
extends Property {
    private final PIT start = new PIT();
    private final PIT end = new PIT();
    private boolean isAdjusting = false;
    private String valueAsString = null;
    private Format format = DATE;
    private String phrase = "";
    public static final Format DATE = new Format("", "");
    public static final Format FROM_TO = new Format("FROM", "TO");
    public static final Format FROM = new Format("FROM", "");
    public static final Format TO = new Format("TO", "");
    public static final Format BETWEEN_AND = new Format("BET", "AND");
    public static final Format BEFORE = new Format("BEF", "");
    public static final Format AFTER = new Format("AFT", "");
    public static final Format ABOUT = new Format("ABT", "");
    public static final Format CALCULATED = new Format("CAL", "");
    public static final Format ESTIMATED = new Format("EST", "");
    public static final Format INTERPRETED = new Interpreted();
    public static final Format[] FORMATS = new Format[]{DATE, FROM_TO, FROM, TO, BETWEEN_AND, BEFORE, AFTER, ABOUT, CALCULATED, ESTIMATED, INTERPRETED};

    public PropertyDate(String tag) {
        super(tag);
    }

    public PropertyDate() {
        super("DATE");
    }

    public PropertyDate(int year) {
        super("DATE");
        this.getStart().set(Integer.MAX_VALUE, Integer.MAX_VALUE, year);
    }

    @Override
    public int compareTo(Property other) {
        if (!(other instanceof PropertyDate)) {
            return 1;
        }
        PropertyDate theOther = (PropertyDate)other;
        PointInTime theClone = this.start.clone();
        PointInTime theOtherClone = theOther.start.clone();
        if (this.format == AFTER) {
            theClone.add(0, 0, 1);
        }
        if (this.format == BEFORE) {
            theClone.add(-1, 0, 0);
        }
        if (theOther.format == AFTER) {
            theOtherClone.add(0, 0, 1);
        }
        if (theOther.format == BEFORE) {
            theOtherClone.add(-1, 0, 0);
        }
        return theClone.compareTo(theOtherClone);
    }

    @Override
    public PropertyComparator2 getComparator() {
        return DATEComparator.getInstance();
    }

    public String getPhrase() {
        return this.phrase;
    }

    public PointInTime getStart() {
        return this.start;
    }

    public PointInTime getEnd() {
        return this.end;
    }

    public Format getFormat() {
        return this.format;
    }

    @Override
    public String getValue() {
        return this.valueAsString != null ? this.valueAsString : this.format.getValue(this);
    }

    public boolean isRange() {
        return this.format.isRange();
    }

    @Override
    public boolean isValid() {
        return this.getValue().trim().isEmpty() && super.isValid() || this.valueAsString == null && this.format.isValid(this);
    }

    public boolean isComparable() {
        return this.start.isValid();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValue(Format newFormat, PointInTime newStart, PointInTime newEnd, String newPhrase) {
        String old = this.getValue();
        this.isAdjusting = true;
        try {
            if (newStart == null) {
                this.start.reset();
            } else {
                this.start.set(newStart);
            }
            if (newEnd == null) {
                this.end.reset();
            } else {
                this.end.set(newEnd);
            }
            this.phrase = newPhrase;
            this.valueAsString = null;
            this.format = newFormat.needsValidStart() && !this.start.isValid() || newFormat.needsValidEnd() && !this.end.isValid() ? DATE : newFormat;
        }
        finally {
            this.isAdjusting = false;
        }
        this.propagatePropertyChanged(this, old);
    }

    public void setFormat(Format set) {
        String old = this.getValue();
        this.isAdjusting = true;
        try {
            if (!this.isRange() && set.isRange()) {
                this.end.set(this.start);
            }
            this.format = set;
        }
        finally {
            this.isAdjusting = false;
        }
        this.propagatePropertyChanged(this, old);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setValue(String newValue) {
        String old;
        block5: {
            old = this.getParent() == null ? null : this.getValue();
            this.isAdjusting = true;
            try {
                this.start.reset();
                this.end.reset();
                this.format = DATE;
                this.phrase = "";
                this.valueAsString = newValue.trim();
                if (this.valueAsString.length() <= 0) break block5;
                for (Format FORMATS1 : FORMATS) {
                    if (!FORMATS1.setValue(newValue, this)) continue;
                    this.format = FORMATS1;
                    this.valueAsString = null;
                    break;
                }
            }
            finally {
                this.isAdjusting = false;
            }
        }
        if (old != null) {
            this.propagatePropertyChanged(this, old);
        }
    }

    @Override
    public String getDisplayValue() {
        return this.getDisplayValue(null);
    }

    public String getDisplayValue(Calendar calendar) {
        return this.getDisplayValue(calendar, GedcomOptions.getInstance().getDateFormat());
    }

    public String getDisplayValue(Calendar calendar, GedcomOptions.GedcomDateFormat theFormat) {
        if (this.valueAsString != null) {
            return this.valueAsString;
        }
        return this.format.getDisplayValue(this, calendar, theFormat);
    }

    @Override
    public String getReportValue() {
        return this.getReportValue(null, GedcomOptions.getInstance().getDateFormat());
    }

    public String getShortReportValue() {
        if (this.valueAsString != null) {
            return this.valueAsString;
        }
        return this.format.getReportValue(this, null, GedcomOptions.getInstance().getDateFormat(), TextOptions.getInstance().getOutputLocale(), "");
    }

    public String getReportValue(Calendar calendar, GedcomOptions.GedcomDateFormat theFormat) {
        if (this.valueAsString != null) {
            return this.valueAsString;
        }
        return this.format.getReportValue(this, calendar, theFormat, TextOptions.getInstance().getOutputLocale(), ".long");
    }

    @Override
    public String getPropertyInfo() {
        WordBuffer result = new WordBuffer();
        result.append(super.getPropertyInfo());
        result.append("<br>");
        result.append(this.getDisplayValue());
        if (!this.getStart().isGregorian() || !this.getEnd().isGregorian()) {
            result.append("<br>");
            result.append(this.getDisplayValue(PointInTime.GREGORIAN));
            result.append("(" + PointInTime.GREGORIAN.getName() + ")");
        }
        return result.toString();
    }

    public Delta getAnniversary() {
        return this.getAnniversary(PointInTime.getNow());
    }

    public Delta getAnniversary(PointInTime now) {
        PointInTime pit;
        if (!this.isValid()) {
            return null;
        }
        PointInTime pointInTime = pit = this.isRange() ? this.getEnd() : this.getStart();
        if (now.compareTo(pit) < 0) {
            return null;
        }
        return Delta.get(pit, now);
    }

    private static class Interpreted
    extends Format {
        private Interpreted() {
            super("INT", "");
        }

        @Override
        public boolean usesPhrase() {
            return true;
        }

        @Override
        public boolean isRange() {
            return false;
        }

        @Override
        protected boolean needsValidStart() {
            return false;
        }

        @Override
        protected boolean needsValidEnd() {
            return false;
        }

        @Override
        public boolean isValid(PropertyDate date) {
            return true;
        }

        @Override
        protected boolean setValue(String text, PropertyDate date) {
            if (text.length() > this.start.length() && text.substring(0, this.start.length()).equalsIgnoreCase(this.start)) {
                int bracket = text.indexOf(40);
                if (bracket > 0 && date.start.set(text.substring(this.start.length(), bracket))) {
                    date.phrase = text.substring(bracket + 1, text.endsWith(")") ? text.length() - 1 : text.length());
                    return true;
                }
                if (date.start.set(text.substring(this.start.length()))) {
                    date.phrase = "";
                    return true;
                }
            }
            if (!text.startsWith("(") || !text.endsWith(")")) {
                return false;
            }
            date.phrase = text.substring(1, text.length() - 1).trim();
            return true;
        }

        @Override
        protected String getDisplayValue(PropertyDate date, Calendar calendar) {
            try {
                WordBuffer result = new WordBuffer();
                if (date.start.isValid()) {
                    if (calendar == null || date.start.getCalendar() == calendar) {
                        date.start.toString(result);
                    } else {
                        date.start.getPointInTime(calendar).toString(result);
                    }
                }
                result.append("(" + date.phrase + ")");
                return result.toString();
            }
            catch (GedcomException e) {
                return "";
            }
        }

        @Override
        protected String getValue(PropertyDate date) {
            WordBuffer result = new WordBuffer();
            if (date.start.isValid()) {
                result.append(this.start);
                date.start.getValue(result);
            }
            result.append("(" + date.phrase + ")");
            return result.toString();
        }
    }

    public static class Format {
        protected String start;
        protected String end;

        private Format(String s, String e) {
            this.start = s;
            this.end = e;
        }

        public String toString() {
            return this.start + this.end;
        }

        public boolean usesPhrase() {
            return false;
        }

        public boolean isRange() {
            return this.end.length() > 0;
        }

        protected boolean needsValidStart() {
            return true;
        }

        protected boolean needsValidEnd() {
            return this.isRange();
        }

        public String getName() {
            String key = (this.start + this.end).toLowerCase();
            if (key.length() == 0) {
                key = "date";
            }
            return Property.resources.getString("prop.date." + key);
        }

        public String getPrefix1Name() {
            if (this.start.length() == 0) {
                return null;
            }
            return Property.resources.getString("prop.date.mod." + this.start, false);
        }

        public String getPrefix2Name() {
            if (this.end.length() == 0) {
                return null;
            }
            return Property.resources.getString("prop.date.mod." + this.end, false);
        }

        public boolean isValid(PropertyDate date) {
            if (!date.start.isValid() || this.isRange() && !date.end.isValid()) {
                return false;
            }
            PointInTime minYear = new PointInTime(0, 0, NbPreferences.forModule(Gedcom.class).getInt("minYear", 1));
            PointInTime maxYear = new PointInTime(0, 0, NbPreferences.forModule(Gedcom.class).getInt("maxYear", 3000));
            return this.checkPointInTime(date.getStart(), minYear, maxYear) && this.checkPointInTime(date.getEnd(), minYear, maxYear);
        }

        private boolean checkPointInTime(PointInTime pit, PointInTime min, PointInTime max) {
            if (pit == null) {
                return true;
            }
            if (!pit.isValid()) {
                return true;
            }
            Parameters.notNull((CharSequence)"min", (Object)min);
            Parameters.notNull((CharSequence)"max", (Object)max);
            return pit.compareTo(min) >= 0 && pit.compareTo(max) <= 0;
        }

        protected String getValue(PropertyDate date) {
            WordBuffer result = new WordBuffer();
            result.append(this.start);
            date.start.getValue(result);
            if (this.isRange()) {
                result.append(this.end);
                date.end.getValue(result);
            }
            return result.toString();
        }

        protected String getDisplayValue(PropertyDate date, Calendar calendar) {
            return this.getReportValue(date, calendar, GedcomOptions.getInstance().getDateFormat(), null, "");
        }

        protected String getDisplayValue(PropertyDate date, Calendar calendar, GedcomOptions.GedcomDateFormat format) {
            return this.getReportValue(date, calendar, format, null, "");
        }

        protected String getReportValue(PropertyDate date, Calendar calendar, GedcomOptions.GedcomDateFormat format, Locale locale, String lon) {
            try {
                WordBuffer result = new WordBuffer();
                if (this.start.length() > 0) {
                    if (locale == null) {
                        result.append(Gedcom.getResources().getString("prop.date.mod." + this.start + lon));
                    } else {
                        result.append(Resources.get(Gedcom.class, locale).getString("prop.date.mod." + this.start + lon));
                    }
                }
                if (calendar == null || date.start.getCalendar() == calendar) {
                    date.start.toString(result, format, locale);
                } else {
                    date.start.getPointInTime(calendar).toString(result, format, locale);
                }
                if (this.isRange()) {
                    if (locale == null) {
                        result.append(Gedcom.getResources().getString("prop.date.mod." + this.end + lon));
                    } else {
                        result.append(Resources.get(Gedcom.class, locale).getString("prop.date.mod." + this.end + lon));
                    }
                    if (calendar == null || date.end.getCalendar() == calendar) {
                        date.end.toString(result, format, locale);
                    } else {
                        date.end.getPointInTime(calendar).toString(result, format, locale);
                    }
                }
                return result.toString();
            }
            catch (GedcomException e) {
                return "";
            }
        }

        protected boolean setValue(String text, PropertyDate date) {
            DirectAccessTokenizer tokens = new DirectAccessTokenizer(text, " ", true);
            int afterFirst = 0;
            if (this.start.length() > 0) {
                String first = tokens.get(0);
                if (!first.equalsIgnoreCase(this.start)) {
                    return false;
                }
                afterFirst = 1;
            }
            if (!this.isRange()) {
                return date.start.set(tokens.getSubstringFrom(afterFirst));
            }
            for (int pos = 1; pos < tokens.count(); ++pos) {
                String token = tokens.get(pos);
                if (!token.equalsIgnoreCase(this.end)) continue;
                return date.start.set(tokens.getSubstring(afterFirst, pos)) && date.end.set(tokens.getSubstringFrom(pos + 1));
            }
            return false;
        }
    }

    private final class PIT
    extends PointInTime {
        private PIT() {
        }

        @Override
        public void set(int d, int m, int y) {
            if (PropertyDate.this.isAdjusting) {
                super.set(d, m, y);
            } else {
                String old = super.getValue();
                super.set(d, m, y);
                PropertyDate.this.propagatePropertyChanged(PropertyDate.this, old);
            }
        }
    }

    private static class DATEComparator
    extends PropertyComparator2.Default<PropertyDate> {
        private static final DATEComparator INSTANCE = new DATEComparator();

        private DATEComparator() {
        }

        public static PropertyComparator2 getInstance() {
            return INSTANCE;
        }

        @Override
        public int compare(PropertyDate d1, PropertyDate d2) {
            return d1.start.compareTo(d2.start);
        }

        @Override
        public String getSortGroup(PropertyDate p) {
            if (!p.isValid()) {
                return "";
            }
            if (p.start.getYear() == Integer.MAX_VALUE) {
                return "";
            }
            String value = "0000" + String.valueOf(p.start.getYear());
            return value.substring(value.length() - 4);
        }
    }
}

