/*
 * Decompiled with CFR 0.152.
 */
package ancestris.swing.atable;

import java.util.ArrayList;
import java.util.List;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;

public class ATableRowSorter<M extends TableModel>
extends TableRowSorter<M> {
    public ATableRowSorter(M model) {
        super(model);
    }

    private void checkColumn(int column) {
        if (column < 0 || column >= this.getModelWrapper().getColumnCount()) {
            throw new IndexOutOfBoundsException("column beyond range of TableModel");
        }
    }

    @Override
    public void toggleSortOrder(int column) {
    }

    public void toggleSortOrder(int column, boolean clear) {
        this.checkColumn(column);
        if (this.isSortable(column)) {
            int sortIndex;
            List<RowSorter.SortKey> keys = new ArrayList<RowSorter.SortKey>(this.getSortKeys());
            for (sortIndex = keys.size() - 1; sortIndex >= 0 && ((RowSorter.SortKey)keys.get(sortIndex)).getColumn() != column; --sortIndex) {
            }
            RowSorter.SortKey sortKey = sortIndex == -1 ? new RowSorter.SortKey(column, SortOrder.ASCENDING) : this.toggle((RowSorter.SortKey)keys.get(sortIndex), keys.size() > 1);
            if (clear) {
                keys = new ArrayList(3);
                if (sortKey != null) {
                    keys.add(sortKey);
                }
            } else if (sortKey == null) {
                keys.remove(sortIndex);
            } else if (sortIndex == -1) {
                keys.add(sortKey);
            } else {
                keys.set(sortIndex, sortKey);
            }
            if (keys.size() > this.getMaxSortKeys()) {
                keys = keys.subList(0, this.getMaxSortKeys());
            }
            this.setSortKeys(keys);
        }
    }

    private RowSorter.SortKey toggle(RowSorter.SortKey key, boolean canBeUnsorted) {
        if (key.getSortOrder() == SortOrder.ASCENDING) {
            return new RowSorter.SortKey(key.getColumn(), SortOrder.DESCENDING);
        }
        if (key.getSortOrder() == SortOrder.DESCENDING && canBeUnsorted) {
            return null;
        }
        return new RowSorter.SortKey(key.getColumn(), SortOrder.ASCENDING);
    }
}

