/*
 * Decompiled with CFR 0.152.
 */
package ancestris.gedcom;

import genj.gedcom.Entity;
import genj.gedcom.Fam;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomConstants;
import genj.gedcom.GedcomException;
import genj.gedcom.Indi;
import genj.gedcom.Note;
import genj.gedcom.Property;
import genj.gedcom.PropertyDate;
import genj.gedcom.PropertyFile;
import genj.gedcom.PropertyXRef;
import genj.gedcom.TagPath;
import genj.gedcom.time.PointInTime;
import genj.io.Filter;
import genj.io.Options;
import genj.util.Registry;
import genj.util.Resources;
import genj.util.swing.ChoiceWidget;
import genj.util.swing.DateWidget;
import genj.util.swing.TextFieldWidget;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import org.apache.commons.lang.StringUtils;

public class SaveOptionsWidget
extends JTabbedPane {
    private static final Logger LOG = Logger.getLogger("ancestris.app", null);
    private JCheckBox[] checkEntities = new JCheckBox[7];
    private JRadioButton checkEntityNone;
    private JRadioButton checkEntityInclude;
    private JRadioButton checkEntityExclude;
    private TextFieldWidget textEntityTag;
    private JCheckBox[] checkFilters;
    private JTextField textTags;
    private JTextField textValues;
    private TextFieldWidget textPassword;
    private JComboBox<GedcomConstants.Encodings> comboEncodings;
    private JCheckBox checkFilterEmpties;
    private JCheckBox checkFilterLiving;
    private JCheckBox checkMediaDirectory;
    private final Resources resources = Resources.get(this);
    private DateWidget dateEventsAfter;
    private DateWidget dateBirthsAfter;
    private boolean isGedcom = false;
    private JCheckBox sort;
    private OptionsSaveType saveType = OptionsSaveType.NONE;
    private Registry registry = Registry.get(SaveOptionsWidget.class);
    private Gedcom theGedcom;
    private boolean noFilters = false;
    private Filter[] filters;

    public SaveOptionsWidget(Gedcom gedcom) {
        this(gedcom, (Filter[])null);
    }

    public SaveOptionsWidget(Gedcom gedcom, Collection<? extends Filter> filters) {
        this(gedcom, filters.toArray(new Filter[0]));
    }

    public SaveOptionsWidget(Gedcom gedcom, Filter[] filters, OptionsSaveType save) {
        this(gedcom, filters, true, true, true, true, true, save);
    }

    public SaveOptionsWidget(Gedcom gedcom, Filter[] filters) {
        this(gedcom, filters, true, true, true, true, true, OptionsSaveType.NONE);
    }

    public SaveOptionsWidget(Gedcom gedcom, Filter[] filters, boolean isEntities, boolean isProperties, boolean isView, boolean isMedia, boolean isEncoding, OptionsSaveType save) {
        this.saveType = save;
        if (isEntities) {
            Box types = new Box(1);
            String[] entities = gedcom.getEntitiesType();
            this.checkEntities = new JCheckBox[entities.length];
            for (int t = 0; t < entities.length; ++t) {
                this.checkEntities[t] = new JCheckBox(Gedcom.getName(entities[t], true), true);
                types.add(this.checkEntities[t]);
            }
            types.add(new JLabel(" "));
            types.add(new JLabel(" "));
            ButtonGroup group = new ButtonGroup();
            this.checkEntityNone = new JRadioButton(this.resources.getString("save.options.entities.none"));
            this.checkEntityNone.setSelected(true);
            this.checkEntityInclude = new JRadioButton(this.resources.getString("save.options.entities.include"));
            this.checkEntityExclude = new JRadioButton(this.resources.getString("save.options.entities.exclude"));
            group.add(this.checkEntityNone);
            group.add(this.checkEntityInclude);
            group.add(this.checkEntityExclude);
            types.add(this.checkEntityNone);
            types.add(this.checkEntityInclude);
            types.add(this.checkEntityExclude);
            types.add(new JLabel(this.resources.getString("save.options.entities.tag")));
            this.textEntityTag = new TextFieldWidget("");
            this.textEntityTag.setEditable(true);
            types.add(this.textEntityTag);
            this.add(this.resources.getString("save.options.filter.entities"), types);
        }
        if (isProperties) {
            Box props = new Box(1);
            props.add(new JLabel(this.resources.getString("save.options.exclude.tags")));
            this.textTags = new TextFieldWidget(this.resources.getString("save.options.exclude.tags.eg"), 10).setTemplate(true);
            props.add(this.textTags);
            props.add(new JLabel(this.resources.getString("save.options.exclude.values")));
            this.textValues = new TextFieldWidget(this.resources.getString("save.options.exclude.values.eg"), 10).setTemplate(true);
            props.add(this.textValues);
            props.add(new JLabel(this.resources.getString("save.options.exclude.events")));
            this.dateEventsAfter = new DateWidget();
            props.add(this.dateEventsAfter);
            props.add(new JLabel(this.resources.getString("save.options.exclude.indis")));
            this.dateBirthsAfter = new DateWidget();
            props.add(this.dateBirthsAfter);
            this.checkFilterLiving = new JCheckBox(this.resources.getString("save.options.exclude.living"));
            props.add(this.checkFilterLiving);
            this.checkFilterEmpties = new JCheckBox(this.resources.getString("save.options.exclude.empties"));
            props.add(this.checkFilterEmpties);
            this.add(this.resources.getString("save.options.filter.properties"), props);
        }
        if (isView) {
            Box others = new Box(1);
            this.filters = filters;
            if (filters != null) {
                this.checkFilters = new JCheckBox[filters.length];
                for (int i = 0; i < this.checkFilters.length; ++i) {
                    this.checkFilters[i] = new JCheckBox(filters[i].getFilterName(), false);
                    others.add(this.checkFilters[i]);
                }
            }
            this.add(this.resources.getString("save.options.filter.views"), new JScrollPane(others));
        }
        if (gedcom != null && isMedia) {
            this.isGedcom = true;
            this.theGedcom = gedcom;
            int nbFiles = 0;
            Box directories = new Box(1);
            List<? extends Property> files = gedcom.getPropertiesByClass(PropertyFile.class);
            nbFiles = files.size();
            directories.add(new JLabel(" "));
            this.checkMediaDirectory = new JCheckBox(this.resources.getString("save.options.files.check"));
            directories.add(this.checkMediaDirectory);
            directories.add(new JLabel(" "));
            directories.add(new JLabel(this.resources.getString("save.options.files.label")));
            directories.add(new JLabel(" "));
            if (nbFiles > 0) {
                this.add(this.resources.getString("save.options.files"), directories);
            }
        }
        if (gedcom != null && isEncoding) {
            Box options = new Box(1);
            this.isGedcom = true;
            this.theGedcom = gedcom;
            options.add(new JLabel(" "));
            options.add(new JLabel(this.resources.getString("save.options.encoding")));
            this.comboEncodings = new ChoiceWidget((Object[])GedcomConstants.Encodings.values(), (Object)GedcomConstants.Encodings.UTF8);
            this.comboEncodings.setEditable(false);
            this.comboEncodings.setSelectedItem((Object)gedcom.getEncoding());
            options.add(this.comboEncodings);
            options.add(new JLabel(" "));
            options.add(new JLabel(this.resources.getString("save.options.password")));
            this.textPassword = new TextFieldWidget(gedcom.hasPassword() ? gedcom.getPassword() : "", 10);
            this.textPassword.setEditable(gedcom.getPassword() != "unknown");
            options.add(this.textPassword);
            options.add(new JLabel(" "));
            this.sort = new JCheckBox(this.resources.getString("save.options.sort"), Options.getSortEntities());
            this.sort.setToolTipText(this.resources.getString("save.options.sort.tooltip"));
            options.add(this.sort);
            this.add(this.resources.getString("save.options"), options);
        }
        this.loadPreferences();
    }

    public boolean isIsGedcom() {
        return this.isGedcom;
    }

    public boolean areMediaToBeCopied() {
        return this.checkMediaDirectory != null ? this.checkMediaDirectory.isSelected() : false;
    }

    public void setMediaToBeCopied(boolean set) {
        this.checkMediaDirectory.setSelected(set);
    }

    public void setNoFilters(boolean set) {
        this.noFilters = set;
    }

    public String getPassword() {
        return this.textPassword != null ? this.textPassword.getText() : null;
    }

    public GedcomConstants.Encodings getEncoding() {
        return this.comboEncodings != null ? (GedcomConstants.Encodings)((Object)this.comboEncodings.getSelectedItem()) : GedcomConstants.Encodings.UTF8;
    }

    public Collection<Filter> getFilters() {
        PointInTime birthsAfter;
        PointInTime eventsAfter;
        FilterProperties fp;
        ArrayList<Filter> result = new ArrayList<Filter>();
        if (this.noFilters) {
            return result;
        }
        if (this.checkEntities != null && this.checkEntityInclude != null && this.textEntityTag != null) {
            String tag = this.checkEntityInclude.isSelected() || this.checkEntityExclude.isSelected() ? this.textEntityTag.getText().trim() : "";
            ArrayList<String> entiteSelected = new ArrayList<String>();
            String[] entityType = this.theGedcom.getEntitiesType();
            for (int i = 0; i < this.checkEntities.length; ++i) {
                if (!this.checkEntities[i].isSelected()) continue;
                entiteSelected.add(entityType[i]);
            }
            if (!StringUtils.isEmpty((String)tag) || entiteSelected.size() < entityType.length) {
                FilterByType fbt = FilterByType.get(entiteSelected, this.checkEntityInclude.isSelected(), tag);
                result.add(fbt);
            }
        }
        if (this.textTags != null && this.textValues != null && (fp = FilterProperties.get(this.textTags.getText(), this.textValues.getText())) != null) {
            result.add(fp);
        }
        if (this.dateEventsAfter != null && (eventsAfter = this.dateEventsAfter.getValue()) != null && eventsAfter.isValid()) {
            result.add(new FilterEventsAfter(eventsAfter));
        }
        if (this.dateBirthsAfter != null && (birthsAfter = this.dateBirthsAfter.getValue()) != null && birthsAfter.isValid()) {
            result.add(new FilterIndividualsBornAfter(birthsAfter));
        }
        if (this.checkFilterLiving != null && this.checkFilterLiving.isSelected()) {
            result.add(new FilterLivingIndividuals());
        }
        if (this.checkFilterEmpties != null && this.checkFilterEmpties.isSelected()) {
            result.add(new FilterEmpties());
        }
        if (this.filters != null) {
            for (int f = 0; f < this.filters.length; ++f) {
                if (!this.checkFilters[f].isSelected()) continue;
                result.add(this.filters[f]);
            }
        }
        return result;
    }

    public void addFilter(Filter filter) {
        if (filter != null) {
            Filter[] filtersCopy = new Filter[this.filters.length + 1];
            System.arraycopy(this.filters, 0, filtersCopy, 0, this.filters.length);
            filtersCopy[this.filters.length] = filter;
            this.filters = filtersCopy;
            JCheckBox[] checkFiltersCopy = new JCheckBox[this.filters.length + 1];
            System.arraycopy(this.checkFilters, 0, checkFiltersCopy, 0, this.checkFilters.length);
            checkFiltersCopy[this.checkFilters.length] = new JCheckBox(filter.getFilterName(), true);
            this.checkFilters = checkFiltersCopy;
        }
    }

    public boolean getSort() {
        if (this.sort != null) {
            return this.sort.isSelected();
        }
        return false;
    }

    public void setSort(boolean mySort) {
        if (this.sort != null) {
            this.sort.setSelected(mySort);
        }
    }

    private void loadPreferences() {
        PointInTime pit;
        if (this.saveType == OptionsSaveType.NONE) {
            return;
        }
        String prefix = this.saveType.name() + '.';
        for (JCheckBox cb : this.checkEntities) {
            cb.setSelected(this.registry.get(prefix + cb.getText(), true));
        }
        this.checkEntityNone.setSelected(this.registry.get(prefix + "save.options.entities.none", false));
        this.checkEntityInclude.setSelected(this.registry.get(prefix + "save.options.entities.include", false));
        this.checkEntityExclude.setSelected(this.registry.get(prefix + "save.options.entities.exclude", false));
        this.textEntityTag.setText(this.registry.get(prefix + "save.options.entities.tag", ""));
        if (!"".equals(this.registry.get(prefix + "save.options.exclude.tags", ""))) {
            this.textTags.setText(this.registry.get(prefix + "save.options.exclude.tags", ""));
        }
        if (!"".equals(this.registry.get(prefix + "save.options.exclude.values", ""))) {
            this.textValues.setText(this.registry.get(prefix + "save.options.exclude.values", ""));
        }
        if (!"".equals(this.registry.get(prefix + "save.options.exclude.events", ""))) {
            try {
                pit = new PointInTime(this.registry.get(prefix + "save.options.exclude.events", ""));
                this.dateEventsAfter.setValue(pit);
            }
            catch (GedcomException ex) {
                LOG.info("Unable to convert date : " + this.registry.get(prefix + "save.options.exclude.events", ""));
            }
        }
        if (!"".equals(this.registry.get(prefix + "save.options.exclude.indis", ""))) {
            try {
                pit = new PointInTime(this.registry.get(prefix + "save.options.exclude.indis", ""));
                this.dateBirthsAfter.setValue(pit);
            }
            catch (GedcomException ex) {
                LOG.info("Unable to convert date : " + this.registry.get(prefix + "save.options.exclude.indis", ""));
            }
        }
        this.checkFilterLiving.setSelected(this.registry.get(prefix + "save.options.exclude.living", false));
        this.checkFilterEmpties.setSelected(this.registry.get(prefix + "save.options.exclude.empties", false));
        for (JCheckBox cb : this.checkFilters) {
            cb.setSelected(this.registry.get(prefix + cb.getText(), false));
        }
        if (this.theGedcom != null) {
            this.checkMediaDirectory.setSelected(this.registry.get(prefix + "save.options.files.check", false));
            this.comboEncodings.setSelectedItem((Object)this.registry.get(prefix + "save.options.encoding", this.theGedcom.getEncoding()));
            this.textPassword.setText(this.registry.get(prefix + "save.options.password", this.theGedcom.hasPassword() ? this.theGedcom.getPassword() : ""));
            this.sort.setSelected(this.registry.get(prefix + "save.options.sort", false));
        }
    }

    public void saveOptions() {
        PointInTime pit;
        if (this.saveType == OptionsSaveType.NONE) {
            return;
        }
        String prefix = this.saveType.name() + '.';
        for (JCheckBox cb : this.checkEntities) {
            if (!cb.isSelected()) {
                this.registry.put(prefix + cb.getText(), false);
                continue;
            }
            this.registry.remove(prefix + cb.getText());
        }
        if (this.checkEntityNone.isSelected()) {
            this.registry.put(prefix + "save.options.entities.none", true);
        } else {
            this.registry.remove(prefix + "save.options.entities.none");
        }
        if (this.checkEntityInclude.isSelected()) {
            this.registry.put(prefix + "save.options.entities.include", true);
        } else {
            this.registry.remove(prefix + "save.options.entities.include");
        }
        if (this.checkEntityExclude.isSelected()) {
            this.registry.put(prefix + "save.options.entities.exclude", true);
        } else {
            this.registry.remove(prefix + "save.options.entities.exclude");
        }
        if (!"".equals(this.textEntityTag.getText())) {
            this.registry.put(prefix + "save.options.entities.tag", this.textEntityTag.getText());
        } else {
            this.registry.remove(prefix + "save.options.entities.tag");
        }
        if (!"".equals(this.textTags.getText())) {
            this.registry.put(prefix + "save.options.exclude.tags", this.textTags.getText());
        } else {
            this.registry.remove(prefix + "save.options.exclude.tags");
        }
        if (!"".equals(this.textValues.getText())) {
            this.registry.put(prefix + "save.options.exclude.values", this.textValues.getText());
        } else {
            this.registry.remove(prefix + "save.options.exclude.values");
        }
        if (!this.dateEventsAfter.getValue().isEmpty()) {
            pit = this.dateEventsAfter.getValue();
            String value = String.format("%04d%02d%02d", pit.getYear(), pit.getMonth() + 1, pit.getDay() + 1);
            this.registry.put(prefix + "save.options.exclude.events", value);
        } else {
            this.registry.remove(prefix + "save.options.exclude.events");
        }
        if (!this.dateBirthsAfter.getValue().isEmpty()) {
            pit = this.dateBirthsAfter.getValue();
            String value = String.format("%04d%02d%02d", pit.getYear(), pit.getMonth() + 1, pit.getDay() + 1);
            this.registry.put(prefix + "save.options.exclude.indis", value);
        } else {
            this.registry.remove(prefix + "save.options.exclude.indis");
        }
        if (this.checkFilterLiving.isSelected()) {
            this.registry.put(prefix + "save.options.exclude.living", true);
        } else {
            this.registry.remove(prefix + "save.options.exclude.living");
        }
        if (this.checkFilterEmpties.isSelected()) {
            this.registry.put(prefix + "save.options.exclude.empties", true);
        } else {
            this.registry.remove(prefix + "save.options.exclude.empties");
        }
        for (JCheckBox cb : this.checkFilters) {
            if (cb.isSelected()) {
                this.registry.put(prefix + cb.getText(), true);
                continue;
            }
            this.registry.remove(prefix + cb.getText());
        }
        if (this.theGedcom != null) {
            if (this.checkMediaDirectory.isSelected()) {
                this.registry.put(prefix + "save.options.files.check", true);
            } else {
                this.registry.remove(prefix + "save.options.files.check");
            }
            if (!this.theGedcom.getEncoding().equals(this.comboEncodings.getSelectedItem())) {
                this.registry.put(prefix + "save.options.encoding", this.comboEncodings.getSelectedItem().toString());
            } else {
                this.registry.remove(prefix + "save.options.encoding");
            }
            if (this.theGedcom.hasPassword() && !this.theGedcom.getPassword().equals(this.textPassword.getText())) {
                this.registry.put(prefix + "save.options.encoding", this.textPassword.getText());
            } else {
                this.registry.remove(prefix + "save.options.password");
            }
            if (this.sort.isSelected()) {
                this.registry.put(prefix + "save.options.sort", true);
            } else {
                this.registry.remove(prefix + "save.options.sort");
            }
        }
    }

    private static class FilterByType
    implements Filter {
        private Set<String> types = new HashSet<String>();
        private String tag = new String();
        private boolean includes = true;
        private Set<Indi> indis = new HashSet<Indi>();

        private FilterByType() {
        }

        protected static FilterByType get(List<String> entities, boolean includes, String tag) {
            FilterByType result = new FilterByType();
            result.types.addAll(entities);
            result.includes = includes;
            result.tag = tag;
            return result;
        }

        @Override
        public boolean veto(Entity ent) {
            if (ent.getGedcom().getSubmitter() == ent) {
                return false;
            }
            if (!this.types.contains(ent.getTag())) {
                return true;
            }
            if (!this.tag.isEmpty()) {
                if (ent instanceof Indi) {
                    return !this.keepIndi(ent);
                }
                if (ent instanceof Fam) {
                    Fam fam = (Fam)ent;
                    boolean father = this.keepIndi(fam.getHusband());
                    boolean mother = this.keepIndi(fam.getWife());
                    boolean child = false;
                    Indi[] children = fam.getChildren();
                    for (int i = 0; !child && i < children.length; ++i) {
                        if (!this.keepIndi(children[i])) continue;
                        child = true;
                    }
                    return !(father && mother || father && child || mother && child);
                }
                ArrayList<Entity> allreadyVisited = new ArrayList<Entity>();
                allreadyVisited.add(ent);
                boolean hasTag = this.hasTag(ent, allreadyVisited);
                return !(hasTag && this.includes || !hasTag && !this.includes);
            }
            return false;
        }

        private boolean hasTag(Entity root, List<Entity> allreadyVisited) {
            Entity[] refs = PropertyXRef.getReferences(root);
            ArrayList<Entity> ents = new ArrayList<Entity>(refs.length);
            for (Entity ref2 : refs) {
                if (ref2 instanceof Indi) {
                    if (ref2.getAllProperties(this.tag).isEmpty()) continue;
                    return true;
                }
                if (allreadyVisited.contains(ref2)) continue;
                ents.add(ref2);
                allreadyVisited.add(ref2);
            }
            return ents.stream().anyMatch(ref -> this.hasTag((Entity)ref, allreadyVisited));
        }

        @Override
        public String getFilterName() {
            return this.toString();
        }

        @Override
        public String getSelectionName() {
            return "";
        }

        @Override
        public int getIndividualsCount() {
            return 0;
        }

        @Override
        public boolean veto(Property property) {
            return false;
        }

        @Override
        public boolean canApplyTo(Gedcom gedcom) {
            return true;
        }

        private boolean keepIndi(Entity ent) {
            if (ent == null) {
                return false;
            }
            boolean hasTag = !ent.getAllProperties(this.tag).isEmpty();
            return hasTag && this.includes || !hasTag && !this.includes;
        }
    }

    private static class FilterProperties
    implements Filter {
        private final Set tags;
        private final Set paths;
        private final String[] values;

        private FilterProperties(Set tags, Set paths, List<String> values) {
            this.tags = tags;
            this.paths = paths;
            this.values = values.toArray(new String[0]);
        }

        protected static FilterProperties get(String sTags, String sValues) {
            HashSet<String> tags = new HashSet<String>();
            HashSet<TagPath> paths = new HashSet<TagPath>();
            StringTokenizer tokens = new StringTokenizer(sTags, ",");
            while (tokens.hasMoreTokens()) {
                String s = tokens.nextToken().trim();
                if (s.indexOf(58) > 0) {
                    try {
                        paths.add(new TagPath(s));
                    }
                    catch (IllegalArgumentException illegalArgumentException) {}
                    continue;
                }
                tags.add(s);
            }
            ArrayList<String> values = new ArrayList<String>();
            tokens = new StringTokenizer(sValues, ",");
            while (tokens.hasMoreTokens()) {
                values.add(tokens.nextToken().trim());
            }
            return tags.isEmpty() && paths.isEmpty() && values.isEmpty() ? null : new FilterProperties(tags, paths, values);
        }

        @Override
        public boolean veto(Property property) {
            if (this.tags.contains(property.getTag())) {
                return true;
            }
            if (this.paths.contains(property.getPath())) {
                return true;
            }
            return !this.accept(property.getValue());
        }

        @Override
        public boolean veto(Entity entity) {
            if (entity instanceof Note) {
                return !this.accept(entity.getValue());
            }
            return false;
        }

        private boolean accept(String value) {
            if (value == null) {
                return true;
            }
            for (String value1 : this.values) {
                if (!value.contains(value1)) continue;
                return false;
            }
            return true;
        }

        @Override
        public String getFilterName() {
            return this.toString();
        }

        @Override
        public String getSelectionName() {
            return "";
        }

        @Override
        public int getIndividualsCount() {
            return 0;
        }

        @Override
        public boolean canApplyTo(Gedcom gedcom) {
            return true;
        }
    }

    private static class FilterEventsAfter
    implements Filter {
        private final PointInTime after;

        private FilterEventsAfter(PointInTime after) {
            this.after = after;
        }

        @Override
        public boolean veto(Property property) {
            PropertyDate when = property.getWhen();
            return when != null && when.getStart().compareTo(this.after) > 0;
        }

        @Override
        public String getFilterName() {
            return this.toString();
        }

        @Override
        public String getSelectionName() {
            return "";
        }

        @Override
        public int getIndividualsCount() {
            return 0;
        }

        @Override
        public boolean veto(Entity entity) {
            return false;
        }

        @Override
        public boolean canApplyTo(Gedcom gedcom) {
            return true;
        }
    }

    private static class FilterLivingIndividuals
    implements Filter {
        private FilterLivingIndividuals() {
        }

        @Override
        public boolean veto(Entity indi) {
            if (indi instanceof Indi) {
                return !((Indi)indi).isDeceased();
            }
            return false;
        }

        @Override
        public String getFilterName() {
            return this.toString();
        }

        @Override
        public String getSelectionName() {
            return "";
        }

        @Override
        public int getIndividualsCount() {
            return 0;
        }

        @Override
        public boolean veto(Property property) {
            return false;
        }

        @Override
        public boolean canApplyTo(Gedcom gedcom) {
            return true;
        }
    }

    private static class FilterIndividualsBornAfter
    implements Filter {
        private final PointInTime after;

        private FilterIndividualsBornAfter(PointInTime after) {
            this.after = after;
        }

        @Override
        public boolean veto(Entity entity) {
            Indi indi;
            PropertyDate birth;
            if (entity instanceof Indi && (birth = (indi = (Indi)entity).getBirthDate()) != null) {
                return birth.getStart().compareTo(this.after) >= 0;
            }
            return false;
        }

        @Override
        public String getFilterName() {
            return this.toString();
        }

        @Override
        public String getSelectionName() {
            return "";
        }

        @Override
        public int getIndividualsCount() {
            return 0;
        }

        @Override
        public boolean veto(Property property) {
            return false;
        }

        @Override
        public boolean canApplyTo(Gedcom gedcom) {
            return true;
        }
    }

    private static class FilterEmpties
    implements Filter {
        private FilterEmpties() {
        }

        @Override
        public boolean veto(Property property) {
            for (int i = 0; i < property.getNoOfProperties(); ++i) {
                if (this.veto(property.getProperty(i))) continue;
                return false;
            }
            return property.getValue().trim().length() == 0;
        }

        @Override
        public String getFilterName() {
            return this.toString();
        }

        @Override
        public String getSelectionName() {
            return "";
        }

        @Override
        public boolean veto(Entity entity) {
            return false;
        }

        @Override
        public boolean canApplyTo(Gedcom gedcom) {
            return true;
        }

        @Override
        public int getIndividualsCount() {
            return 0;
        }
    }

    public static enum OptionsSaveType {
        GENEANET,
        SAVE_AS,
        NONE;

    }
}

