/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.gedcomcompare.tools;

import ancestris.modules.gedcomcompare.communication.UserProfile;
import ancestris.modules.gedcomcompare.options.GedcomCompareOptionsPanel;
import ancestris.modules.gedcomcompare.tools.TechInfoPanel;
import ancestris.util.swing.DialogManager;
import genj.io.FileAssociation;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import org.openide.awt.Mnemonics;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

public class ProfilePanel
extends JPanel {
    private static final SimpleDateFormat formatter = new SimpleDateFormat("d-MMM-yyyy HH:mm");
    private static final ImageIcon nophoto = new ImageIcon(ImageUtilities.loadImage((String)"ancestris/modules/gedcomcompare/resources/nophotobig.png"));
    private UserProfile memberProfile;
    private UserProfile myProfile;
    private JButton jButton1;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel2;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JPanel jPanel1;

    public ProfilePanel(UserProfile mp, UserProfile myP, int connections, Date startDate, Date endDate) {
        this.memberProfile = mp;
        this.myProfile = myP;
        this.initComponents();
        this.jLabel1.setText(this.getDescription(mp));
        this.jLabel10.setText("" + connections);
        this.jLabel7.setText(formatter.format(startDate));
        this.jLabel9.setText(formatter.format(endDate));
        ImageIcon icon = GedcomCompareOptionsPanel.getPhoto(3, mp.photoBytes);
        if (icon != null) {
            this.jLabel8.setIcon(icon);
        } else {
            this.jLabel8.setIcon(nophoto);
        }
        this.jButton1.setVisible(!mp.pseudo.equals(myP.pseudo));
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jLabel8 = new JLabel();
        this.jLabel1 = new JLabel();
        this.jButton1 = new JButton();
        this.jLabel2 = new JLabel();
        this.jLabel5 = new JLabel();
        this.jLabel6 = new JLabel();
        this.jLabel7 = new JLabel();
        this.jLabel9 = new JLabel();
        this.jLabel10 = new JLabel();
        this.jPanel1.setBorder(BorderFactory.createEtchedBorder());
        this.jLabel8.setHorizontalAlignment(0);
        this.jLabel8.setBorder(null);
        this.jLabel8.setIconTextGap(0);
        this.jLabel8.setPreferredSize(new Dimension(155, 186));
        this.jLabel8.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                ProfilePanel.this.jLabel8MouseClicked(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel8, GroupLayout.Alignment.TRAILING, -1, -1, -2));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel8, -2, -1, -2));
        this.jLabel8.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ProfilePanel.class, (String)"ProfilePanel.jLabel8.AccessibleContext.accessibleDescription"));
        this.jLabel1.setFont(new Font("DejaVu Sans", 1, 12));
        this.jLabel1.setHorizontalAlignment(0);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(ProfilePanel.class, (String)"ProfilePanel.jLabel1.text"));
        this.jLabel1.setVerticalAlignment(1);
        this.jButton1.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/gedcomcompare/resources/email32.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.jButton1, (String)NbBundle.getMessage(ProfilePanel.class, (String)"ProfilePanel.jButton1.text"));
        this.jButton1.setToolTipText(NbBundle.getMessage(ProfilePanel.class, (String)"ProfilePanel.jButton1.toolTipText", (Object)(this.memberProfile != null ? this.memberProfile.name : "")));
        this.jButton1.setIconTextGap(0);
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProfilePanel.this.jButton1ActionPerformed(evt);
            }
        });
        this.jLabel2.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/gedcomcompare/resources/connm.png")));
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(ProfilePanel.class, (String)"ProfilePanel.jLabel2.text"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel5, (String)NbBundle.getMessage(ProfilePanel.class, (String)"ProfilePanel.jLabel5.text"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel6, (String)NbBundle.getMessage(ProfilePanel.class, (String)"ProfilePanel.jLabel6.text"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel7, (String)NbBundle.getMessage(ProfilePanel.class, (String)"ProfilePanel.jLabel7.text"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel9, (String)NbBundle.getMessage(ProfilePanel.class, (String)"ProfilePanel.jLabel9.text"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel10, (String)NbBundle.getMessage(ProfilePanel.class, (String)"ProfilePanel.jLabel10.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(15, 15, 15).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jButton1, -2, 42, -2).addGroup(layout.createSequentialGroup().addComponent(this.jPanel1, -1, -1, -2).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel2).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel5).addComponent(this.jLabel6)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel9).addComponent(this.jLabel7)))).addGap(18, 18, 18).addComponent(this.jLabel10, -2, 22, -2)).addComponent(this.jLabel1, -2, 272, -2)))).addGap(18, 18, 18)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(layout.createSequentialGroup().addGap(20, 20, 20).addComponent(this.jLabel1, -2, 94, -2).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.jLabel10, -2, 16, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel5).addComponent(this.jLabel7)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel6).addComponent(this.jLabel9))).addComponent(this.jPanel1, -1, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton1, -2, 37, -2).addGap(15, 15, 15)));
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        this.sendMail(this.memberProfile.email);
    }

    private void jLabel8MouseClicked(MouseEvent evt) {
        if (evt.getButton() == 1 && evt.getClickCount() == 2 && evt.isAltDown() && evt.isAltGraphDown()) {
            this.displayTecInfo();
        }
    }

    public void sendMail(String to) {
        String uriStr = String.format("mailto:%s?subject=%s&body=%s", to, ProfilePanel.urlEncode(NbBundle.getMessage(ProfilePanel.class, (String)"MailSubject")), ProfilePanel.urlEncode(NbBundle.getMessage(ProfilePanel.class, (String)"MailContent", (Object)this.memberProfile.name, (Object)this.myProfile.name)));
        try {
            FileAssociation.getDefault().execute(new URL(uriStr));
        }
        catch (MalformedURLException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private static final String urlEncode(String str) {
        try {
            return URLEncoder.encode(str, "UTF-8").replace("+", "%20");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private String getDescription(UserProfile mp) {
        String str = "";
        str = mp.name.isEmpty() ? "<html><center><font size=14px>" + NbBundle.getMessage(ProfilePanel.class, (String)"NoProfileAvailable") + "</font></center></html>" : "<html><center><font size=14px>" + mp.name + "<br><br>" + mp.city + ", " + mp.country + "<br><br>" + mp.email + "</font></center></html>";
        return str;
    }

    private void displayTecInfo() {
        TechInfoPanel tip = new TechInfoPanel(this.memberProfile);
        DialogManager.create((String)"Information technique", (JComponent)tip).setMessageType(-1).setOptionType(10).show();
    }
}

