/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.stream.file;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Locale;
import org.graphstream.stream.file.FileSinkBase;
import org.graphstream.stream.file.FileSinkDGSUtility;

public class FileSinkDGS
extends FileSinkBase {
    protected PrintWriter out;
    protected String graphName = "";

    @Override
    protected void outputHeader() throws IOException {
        this.out = (PrintWriter)this.output;
        this.out.printf("DGS004%n", new Object[0]);
        if (this.graphName.length() <= 0) {
            this.out.printf("null 0 0%n", new Object[0]);
        } else {
            this.out.printf("\"%s\" 0 0%n", FileSinkDGSUtility.formatStringForQuoting(this.graphName));
        }
    }

    @Override
    protected void outputEndOfFile() throws IOException {
    }

    @Override
    public void edgeAttributeAdded(String graphId, long timeId, String edgeId, String attribute, Object value) {
        this.edgeAttributeChanged(graphId, timeId, edgeId, attribute, null, value);
    }

    @Override
    public void edgeAttributeChanged(String graphId, long timeId, String edgeId, String attribute, Object oldValue, Object newValue) {
        this.out.printf("ce \"%s\" %s%n", FileSinkDGSUtility.formatStringForQuoting(edgeId), FileSinkDGSUtility.attributeString(attribute, newValue, false));
    }

    @Override
    public void edgeAttributeRemoved(String graphId, long timeId, String edgeId, String attribute) {
        this.out.printf("ce \"%s\" %s%n", FileSinkDGSUtility.formatStringForQuoting(edgeId), FileSinkDGSUtility.attributeString(attribute, null, true));
    }

    @Override
    public void graphAttributeAdded(String graphId, long timeId, String attribute, Object value) {
        this.graphAttributeChanged(graphId, timeId, attribute, null, value);
    }

    @Override
    public void graphAttributeChanged(String graphId, long timeId, String attribute, Object oldValue, Object newValue) {
        this.out.printf("cg %s%n", FileSinkDGSUtility.attributeString(attribute, newValue, false));
    }

    @Override
    public void graphAttributeRemoved(String graphId, long timeId, String attribute) {
        this.out.printf("cg %s%n", FileSinkDGSUtility.attributeString(attribute, null, true));
    }

    @Override
    public void nodeAttributeAdded(String graphId, long timeId, String nodeId, String attribute, Object value) {
        this.nodeAttributeChanged(graphId, timeId, nodeId, attribute, null, value);
    }

    @Override
    public void nodeAttributeChanged(String graphId, long timeId, String nodeId, String attribute, Object oldValue, Object newValue) {
        this.out.printf("cn \"%s\" %s%n", FileSinkDGSUtility.formatStringForQuoting(nodeId), FileSinkDGSUtility.attributeString(attribute, newValue, false));
    }

    @Override
    public void nodeAttributeRemoved(String graphId, long timeId, String nodeId, String attribute) {
        this.out.printf("cn \"%s\" %s%n", FileSinkDGSUtility.formatStringForQuoting(nodeId), FileSinkDGSUtility.attributeString(attribute, null, true));
    }

    @Override
    public void edgeAdded(String graphId, long timeId, String edgeId, String fromNodeId, String toNodeId, boolean directed) {
        edgeId = FileSinkDGSUtility.formatStringForQuoting(edgeId);
        fromNodeId = FileSinkDGSUtility.formatStringForQuoting(fromNodeId);
        toNodeId = FileSinkDGSUtility.formatStringForQuoting(toNodeId);
        this.out.printf("ae \"%s\" \"%s\" %s \"%s\"%n", edgeId, fromNodeId, directed ? ">" : "", toNodeId);
    }

    @Override
    public void edgeRemoved(String graphId, long timeId, String edgeId) {
        this.out.printf("de \"%s\"%n", FileSinkDGSUtility.formatStringForQuoting(edgeId));
    }

    @Override
    public void graphCleared(String graphId, long timeId) {
        this.out.printf("cl%n", new Object[0]);
    }

    @Override
    public void nodeAdded(String graphId, long timeId, String nodeId) {
        this.out.printf("an \"%s\"%n", FileSinkDGSUtility.formatStringForQuoting(nodeId));
    }

    @Override
    public void nodeRemoved(String graphId, long timeId, String nodeId) {
        this.out.printf("dn \"%s\"%n", FileSinkDGSUtility.formatStringForQuoting(nodeId));
    }

    @Override
    public void stepBegins(String graphId, long timeId, double step) {
        this.out.printf(Locale.US, "st %f%n", step);
    }
}

