/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.stream;

import org.graphstream.graph.Graph;
import org.graphstream.stream.Source;
import org.graphstream.stream.SourceBase;

public class GraphReplay
extends SourceBase
implements Source {
    public GraphReplay(String id) {
        super(id);
    }

    public void replay(Graph graph) {
        graph.attributeKeys().forEach(key -> this.sendGraphAttributeAdded(this.sourceId, (String)key, graph.getAttribute((String)key)));
        graph.nodes().forEach(node -> {
            String nodeId = node.getId();
            this.sendNodeAdded(this.sourceId, nodeId);
            if (node.getAttributeCount() > 0) {
                node.attributeKeys().forEach(key -> this.sendNodeAttributeAdded(this.sourceId, nodeId, (String)key, node.getAttribute((String)key)));
            }
        });
        graph.edges().forEach(edge -> {
            String edgeId = edge.getId();
            this.sendEdgeAdded(this.sourceId, edgeId, edge.getNode0().getId(), edge.getNode1().getId(), edge.isDirected());
            if (edge.getAttributeCount() > 0) {
                edge.attributeKeys().forEach(key -> this.sendEdgeAttributeAdded(this.sourceId, edgeId, (String)key, edge.getAttribute((String)key)));
            }
        });
    }
}

