# Spice vdagent changelog

All notable changes to this project will be documented in this file.
The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.1.0/),

Gitlab markdown format support linking to Issues (#) and Merge requests (!) and more, see below:

https://gitlab.freedesktop.org/spice/linux/vd_agent/-/blob/master/CHANGELOG.md

## [Unreleased]

### Added

- !49 - systemd services: add Documentation key (point to manpage)

### Changed

- !47 - Switch to spice-vdagent.service by default
- !54 - Improve integration with systemd service manager

### Fixed

- !44 - Makefile.am: don't create /var/run/spice-vdagentd
- !46 - vdagent: remove callback on destroy()
- !48 - Fix minor spelling errors
- !51 - Fix VDAGentMonitorConfig size calculation

## [0.22.1] - 2022-02-14

- !42 - Fix crash on startup of session agent

## [0.22.0] - 2022-02-07

- !40 - Handle side mouse buttons
- !39 - Set retry limit to connect to vdagentd and improve logging error
- !35 - Fix deprecation warning
- !37 - Provide systemd spice-vdagent.service

## [0.21.0] - 2021-01-13

- Security fixes:
  CVE-2020-25650, CVE-2020-25651, CVE-2020-25652, CVE-2020-25653
- Fix shutdown issue due to incompatible thread/fork uses with GLib
- Fix mouse pointer issues under Wayland
- Fix a crash when running without dbus (e.g: within containers)
- !9  - Introduce optional GTK4 support for monitor management
- !13 - Enable copying files from client using webdav
- Bump spice-protocol dependency to v0.14.3

## [0.20.0] - 2020-03-10

- Add gio-unix and gobject dependency >= 2.50
- Bump gtk+ >= 3.22 (optional dependency)
- Last release with gtk+ being optional
- !4 - Race fixes between client and guest clipboard
- !2 - Fix session lookup for new GNOME versions
- !3 - Now using GMainLoop and GIO to handle I/O of messages
- Several minor covscan fixes

## [0.19.0] - 2019-04-12

- Add libdrm dependency
- Fix file descriptor leak on failed connections
- Handle new VD_AGENT_GRAPHICS_DEVICE_INFO message advertised by
  VD_AGENT_CAP_GRAPHICS_DEVICE_INFO capability
- Session agent autostart changed to WindowManager ([rhbz#1623947])
  This fixes possible race with xdg-user-dirs
- Fix of sending empty screen resolution messages ([rhbz#1641723])
- Fix 'Dependency failed for Activation socket' with systemd ([rhbz#1545212])
- Fix error messages about on selecting text on host ([rhbz#1594876])
  this was also fixed with Gtk backend
- Update paths from /var/run → /run
- Fix Session agent restart
- Add test for file creation
- Prefer GLib memory functions stdlib.h ones
- Several code and logs improvements

[rhbz#1623947]: https://bugzilla.redhat.com/show_bug.cgi?id=1623947
[rhbz#1641723]: https://bugzilla.redhat.com/show_bug.cgi?id=1641723
[rhbz#1545212]: https://bugzilla.redhat.com/show_bug.cgi?id=1545212
[rhbz#1594876]: https://bugzilla.redhat.com/show_bug.cgi?id=1594876

## [0.18.0] - 2018-06-06

- Add GTK+ framework to handle x11 backend such as clipboard
- Deprecate X11 backend in favor of GTK+ framework
- Ask pkg-config to appropriate directory to install udev rules
- Fix leak of udscs's file descriptor
- Better quote directory path when calling xdg-open to save file transfer
- Bump GLib to 2.34
- Add systemd socket activation (rhbz#1340160)
- Add support to detailed errors on file transfers
- Add check for available free space in guest before starting a file transfer
- Use better names for duplicated files on file transfer
- Improve support on big endian guests (#5)
- Use IdleHint to check if a session is locked over console-kit (rhbz#1412673)
- Fixes double free on errors over udscs by improving memory ownership
- Hide autostart file on Unity
- Improve command line messages for vdagentd
- Fix typo in --enable-static-uinput configure option
- Code repository moved to gitlab.freedesktop.org

## [0.17.0] - 2016-06-10

- Denies file-transfer in locked sessions
  - systems under systemd (rhbz#1323623)
  - systems under console-kit (rhbz#1323630)
- Denies file-transfer in login screen
  - systems under systemd (rhbz#1328761)
  - systems under console-kit (rhbz#1323640)
- Bump glib version to 2.28
- Set exit code to 1 instead of 0 when virtio device cannot be opened
- Fix double-free on uinput->screen_info (rhbz#1262635)
- Code improvement over unix domain client server support (udcs)
- Fix build compatibility with different libsystemd versions (fdo#94209)

## [0.16.0] - 2015-06-30

- Add audio volume synchronization support
- Add support for maximum clipboard size
- Add support for more clipboard targets (STRING and TIMESTAMP)
- Improve handling of transfers of multiple files
- Fix transfer of >2GB files on 32 bit systems
- XSpice improvements
- Various bug fixes related to resolution changes

## [0.15.0] - 2013-10-14

- Xspice support
- Release clipboard on client disconnect if owned by client (rhbz#1003977)
- Turn some error messages into debugging messages (rhbz#918310)
- Not having the virtio channel is not an error; instead silently do nothing

## [0.14.0] - 2013-04-12

- More multi-monitor and arbitrary resolution support bugfixes
- Add support for file transfers from client to guest
- Add support for setups with multiple Screens (multiple qxl devices each
  mapped to their own screen), limitations:
  - Max one monitor per Screen / qxl device
  - All monitors / Screens must have the same resolution
  - No client -> guest resolution syncing
- Add spice-vdagent -X cmdline option, which runtime disables console-kit /
  systemd-logind integration for setups where these are not used
- Add manpages for spice-vdagent and spice-vdagentd

## [0.12.1] - 2013-01-08

- Various bugfixes for multi-monitor and arbitrary resolution support
- Requires libXrandr >= 1.3, Note 0.12.0 also required this, but did not
  check for it. For older distributions use 0.10.1

## [0.12.0] - 2012-09-01

- Full multi-monitor and arbitrary resolution support, this requires a new
  enough xorg-x11-drv-qxl driver, as well as a new enough host
- systemd service support, using systemd hardware activation
- Use syslog for logging, rather then logging to private log files

## [0.10.1] - 2012-03-27

- Fix a race condition when opening the vdagent virtio serial port, which
  caused it to get opened / closed in rapid succession a number of times
  on vm boot

## [0.10.0] - 2012-03-20

- Add limited support for multiple displays, see README
- Add support for RHEL-5 (and other distributions with a non hotplug
  capable Xorg and/or no console-kit), see README.RHEL-5
- Add support for using libsystemd-logind as session information source
  instead of console-kit

## [0.8.1] - 2011-07-18

- In daemon mode the session vdagent now retries connecting to the system
  vdagentd every second, once a connection is made a version check is done,
  if the version differs (which only happens on an upgrade from one version
  to the next) the session vdagent re-execs itself (Marc-André Lureau)

## [0.8.0] - 2011-04-19

- Add support for copy and paste using the primary selection, to use this
  you need a spice-gtk widget based client and the latest spice-gtk code
  (Marc-André Lureau and Hans de Goede)
- Autotoolized (Christophe Fergeau)
- Allow building without consolekit, for systems which don't have ck, such
  as RHEL-5 (Christophe Fergeau)
- Various small bugfixes (Hans de Goede)

## [0.6.3] - 2010-11-01

- Initial release, starting with version nr 0.6.3, to indicate that it
  more or less supports all parts of the cdagent protocol in spice-protocol
  and spice 0.6.3

[unreleased]: https://gitlab.freedesktop.org/spice/linux/vd_agent/-/compare/spice-vdagent-0.22.1...master
[0.22.1]: https://gitlab.freedesktop.org/spice/linux/vd_agent/-/compare/spice-vdagent-0.22.0...spice-vdagent-0.22.1
[0.22.0]: https://gitlab.freedesktop.org/spice/linux/vd_agent/-/compare/spice-vdagent-0.21.0...spice-vdagent-0.22.0
[0.21.0]: https://gitlab.freedesktop.org/spice/linux/vd_agent/-/compare/spice-vdagent-0.20.0...spice-vdagent-0.21.0
[0.20.0]: https://gitlab.freedesktop.org/spice/linux/vd_agent/-/compare/spice-vdagent-0.19.0...spice-vdagent-0.20.0
[0.19.0]: https://gitlab.freedesktop.org/spice/linux/vd_agent/-/compare/spice-vdagent-0.18.0...spice-vdagent-0.19.0
[0.18.0]: https://gitlab.freedesktop.org/spice/linux/vd_agent/-/compare/spice-vdagent-0.17.0...spice-vdagent-0.18.0
[0.17.0]: https://gitlab.freedesktop.org/spice/linux/vd_agent/-/compare/spice-vdagent-0.16.0...spice-vdagent-0.17.0
[0.16.0]: https://gitlab.freedesktop.org/spice/linux/vd_agent/-/compare/spice-vdagent-0.15.0...spice-vdagent-0.16.0
[0.15.0]: https://gitlab.freedesktop.org/spice/linux/vd_agent/-/compare/spice-vdagent-0.14.0...spice-vdagent-0.15.0
[0.14.0]: https://gitlab.freedesktop.org/spice/linux/vd_agent/-/compare/spice-vdagent-0.12.1...spice-vdagent-0.14.0
[0.12.1]: https://gitlab.freedesktop.org/spice/linux/vd_agent/-/compare/spice-vdagent-0.12.0...spice-vdagent-0.12.1
[0.12.0]: https://gitlab.freedesktop.org/spice/linux/vd_agent/-/compare/spice-vdagent-0.10.1...spice-vdagent-0.12.0
[0.10.1]: https://gitlab.freedesktop.org/spice/linux/vd_agent/-/compare/spice-vdagent-0.10.0...spice-vdagent-0.10.1
[0.10.0]: https://gitlab.freedesktop.org/spice/linux/vd_agent/-/compare/spice-vdagent-0.8.1...spice-vdagent-0.10.0
[0.8.1]: https://gitlab.freedesktop.org/spice/linux/vd_agent/-/compare/spice-vdagent-0.8.0...spice-vdagent-0.8.1
[0.8.0]: https://gitlab.freedesktop.org/spice/linux/vd_agent/-/compare/spice-vdagent-0.6.3...spice-vdagent-0.8.0
[0.6.3]: https://gitlab.freedesktop.org/spice/linux/vd_agent/-/tags/spice-vdagent-0.6.3
