# Code of Conduct

To err is human - please remember this when engaging in the community.

Contribution and discussion to Waterfox should be a harassment-free experience for everyone. We do not tolerate harassment of community in any form.

## Summary

* be friendly and patient,
* be welcoming,
* be considerate,
* be respectful,
* be careful in the words that you choose and be kind to others,
* when we disagree, try to understand why.

---

This isn’t an exhaustive list of things that you can’t do. Rather, take it in the spirit in which it’s intended - a guide to make it easier to communicate and participate in the community.

* **Be friendly and patient**.
* **Be welcoming**. We strive to be a community that welcomes and supports people of all backgrounds and identities. This includes, but is not limited to members of any race, ethnicity, culture, national origin, color, immigration status, social and economic class, educational level, sex, sexual orientation, gender identity and expression, age, size, family status, political belief, religion or lack thereof, and mental and physical ability.
* **Be considerate**. Your work will be used by other people, and you in turn will depend on the work of others. Any decision you take will affect users and colleagues, and you should take those consequences into account. Remember that we’re a world-wide community, so you might not be communicating in someone else’s primary language.
* **Be respectful**. Not all of us will agree all the time, but disagreement is no excuse for poor behavior and poor manners. We might all experience some frustration now and then, but we cannot allow that frustration to turn into a personal attack. It’s important to remember that a community where people feel uncomfortable or threatened is not a productive one. Members of the Waterfox community should be respectful when dealing with other members as well as with people outside the Waterfox community.
* **Be careful in the words that you choose and be kind to others**. Do not insult or put down other participants. Harassment and other exclusionary behavior aren’t acceptable. This includes, but is not limited to:
  * Violent threats or language directed against another person.
  * Discriminatory jokes and language.
  * Posting sexually explicit or violent material.
  * Posting (or threatening to post) other people’s personally identifying information ("doxing").
  * Personal insults, especially those using racist or sexist terms.
  * Unwelcome sexual attention.
  * Advocating for, or encouraging, any of the above behavior.
* **In general, if someone asks you to stop, then stop**. Persisting in such behavior after being asked to stop is considered harassment.
* **When we disagree, try to understand why**. Disagreements, both social and technical, happen all the time and Waterfox is no exception. It is important that we resolve disagreements and differing views constructively. Remember that we’re different. The strength of Waterfox comes from its varied community, people from a wide range of backgrounds. Different people have different perspectives on issues. Being unable to understand why someone holds a viewpoint doesn’t mean that they’re wrong. Don’t forget that it is human to err and blaming each other doesn’t get us anywhere. Instead, focus on helping to resolve issues and learning from mistakes.

## Scope

This code of conduct applies to all spaces managed by Waterfox. This includes online chat, mailing lists, bug trackers, events such as the developer meetings and socials, and any other forums created by the project that the community uses for communication. It applies to all of your communication and conduct in these spaces, including emails, chats, things you say, slides, videos, posters, signs, or even t-shirts you display in these spaces. In addition, violations of this code outside these spaces may, in rare cases, affect a person’s ability to participate within them, when the conduct amounts to an egregious violation of this code.

## Enforcement Responsibilities

Community leaders are responsible for clarifying and enforcing our standards of
acceptable behavior and will take appropriate and fair corrective action in
response to any behavior that they deem inappropriate, threatening, offensive,
or harmful.

Community leaders have the right and responsibility to remove, edit, or reject
comments, commits, code, wiki edits, issues, and other contributions that are
not aligned to this Code of Conduct, and will communicate reasons for moderation
decisions when appropriate.

## Enforcement

Instances of abusive, harassing, or otherwise unacceptable behavior may be
reported to the community leaders responsible for enforcement at
MrAlex94@users.noreply.github.com.
All complaints will be reviewed and investigated promptly and fairly.

All community leaders are obligated to respect the privacy and security of the
reporter of any incident.

## Enforcement Guidelines

Community leaders will follow these Community Impact Guidelines in determining
the consequences for any action they deem in violation of this Code of Conduct:

### 1. Warning

**Community Impact**: A violation through a single incident or series
of actions.

**Consequence**: A warning with consequences for continued behavior. No
interaction with the people involved, including unsolicited interaction with
those enforcing the Code of Conduct, for a specified period of time. This
includes avoiding interactions in community spaces as well as external channels
like social media. Violating these terms may lead to a temporary or
permanent ban.

### 2. Temporary Ban

**Community Impact**: A serious violation of community standards, including
sustained inappropriate behavior.

**Consequence**: A temporary ban from any sort of interaction or public
communication with the community for a specified period of time. No public or
private interaction with the people involved, including unsolicited interaction
with those enforcing the Code of Conduct, is allowed during this period.
Violating these terms may lead to a permanent ban.

### 3. Permanent Ban

**Community Impact**: Demonstrating a pattern of violation of community
standards, including sustained inappropriate behavior,  harassment of an
individual, or aggression toward or disparagement of classes of individuals.

**Consequence**: A permanent ban from any sort of public interaction within
the community.

## Acknowledgments

This article is based partly on FreeBSD's Code of Conduct (CoC) which is based on LLVM Project’s draft CoC, which in turn is based on the Django Project Code of Conduct, which is in turn based on wording from the Speak Up! project. It is also partly based on the [Contributor Covenant](https://www.contributor-covenant.org/version/2/0/code_of_conduct.html), version 2.0.
