.TH "ZIP_FDOPEN" "3" "February 13, 2012" "NiH" "Library Functions Manual"
.SH "NAME"
\fBzip_fdopen\fP
\- open zip archive using open file descriptor
.SH "LIBRARY"
libzip (-lzip)
.SH "SYNOPSIS"
zip.h
zip_t *
zip_fdopen int fd int flags int *errorp
.SH "DESCRIPTION"
The zip archive specified by the open file descriptor
\fIfd\fP
is opened and a pointer to a
struct zip,
used to manipulate the archive, is returned.
In contrast to
zip_open(3),
using
\fBzip_fdopen\fP
the archive can only be opened in read-only mode.
The
\fIfd\fP
argument may not be used any longer after calling
\fBzip_fdopen\fP.
The
flags
are specified by
\fIor\fP'ing
the following values, or 0 for none of them.
.TP ZIP_CHECKCONS
\fRZIP_CHECKCONS\fP
Perform additional stricter consistency checks on the archive, and
error if they fail.
.PP
If an error occurs and
\fIerrorp\fP
is
non-\fRNULL\fP,
it will be set to the corresponding error code.
.SH "RETURN VALUES"
Upon successful completion
zip_fdopen
returns a
struct zip
pointer, and
\fIfd\fP
should not be used any longer, nor passed to
close(2).
Otherwise,
\fRNULL\fP
is returned and
\fI*errorp\fP
is set to indicate the error.
In the error case,
\fIfd\fP
remains unchanged.
.SH "ERRORS"
The file specified by
\fIfd\fP
is prepared for use by
libzip(3)
unless:
.TP 17n
[\fRZIP_ER_INCONS\fP]
Inconsistencies were found in the file specified by
\fIpath\fP.
This error is often caused by specifying
\fRZIP_CHECKCONS\fP
but can also happen without it.
.TP 17n
[\fRZIP_ER_INVAL\fP]
The
\fIflags\fP
argument is invalid.
Not all
zip_open(3)
flags are allowed for
\fBzip_fdopen\fP,
see
\fIDESCRIPTION\fP.
.TP 17n
[\fRZIP_ER_MEMORY\fP]
Required memory could not be allocated.
.TP 17n
[\fRZIP_ER_NOZIP\fP]
The file specified by
\fIfd\fP
is not a zip archive.
.TP 17n
[\fRZIP_ER_OPEN\fP]
The file specified by
\fIfd\fP
could not be prepared for use by
libzip(3).
.TP 17n
[\fRZIP_ER_READ\fP]
A read error occurred; see
errno
for details.
.TP 17n
[\fRZIP_ER_SEEK\fP]
The file specified by
\fIfd\fP
does not allow seeks.
.SH "SEE ALSO"
libzip(3),
zip_close(3),
zip_error_to_str(3),
zip_open(3)
.SH "AUTHORS"
Dieter Baron <dillo@nih.at>
and
Thomas Klausner <tk@giga.or.at>
