#!/bin/sh -xe
## -----------------------------------------------------------------------
##   
##   Copyright 2000-2001 H. Peter Anvin - All Rights Reserved
##
##   This program is free software; you can redistribute it and/or modify
##   it under the terms of the GNU General Public License as published by
##   the Free Software Foundation, Inc., 675 Mass Ave, Cambridge MA 02139,
##   USA; either version 2 of the License, or (at your option) any later
##   version; incorporated herein by reference.
##
## -----------------------------------------------------------------------
## $Id: makeinit.sh,v 1.7 2002/02/11 00:44:58 hpa Exp $

##
## initrd make script for SuperRescue CD
##

rm -f work/initrd work/initrd.gz
rm -rf work/im work/ir work/irtree
mkdir -p work/ir
find irtree -type f -name \*~ -print0 | xargs -0r rm -f

dd if=/dev/zero of=work/initrd bs=1024 count=4096
mke2fs -F work/initrd
tune2fs -c 0 -i 0 work/initrd
mount -t ext2 -o loop work/initrd work/ir
cp -a irtree work/irtree
rm -rf work/irtree/RCS
cp -a work/irtree/. work/ir/.
umount work/ir
sync
gzip -9 work/initrd
