/*
 * Decompiled with CFR 0.152.
 */
package com.maltego.cloud.ui.auth;

import com.maltego.cloud.CloudAuth;
import com.maltego.cloud.ui.save.SaveToCloudAction;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.sendopts.CommandException;
import org.netbeans.spi.sendopts.Env;
import org.netbeans.spi.sendopts.Option;
import org.netbeans.spi.sendopts.OptionProcessor;
import org.openide.util.Exceptions;
import org.openide.util.actions.SystemAction;

public class CloudSyncDebugOptionProcessor
extends OptionProcessor {
    private static final Logger LOG = Logger.getLogger(CloudSyncDebugOptionProcessor.class.getName());
    private static final Option CLOUD_DEBUG = Option.requiredArgument((char)'z', (String)"cloudDebug");
    private final CloudAuth cloudAuth = CloudAuth.getDefault();

    protected Set<Option> getOptions() {
        return Collections.singleton(CLOUD_DEBUG);
    }

    protected void process(Env env, Map<Option, String[]> map) throws CommandException {
        try {
            String[] args = map.get(CLOUD_DEBUG);
            if (args != null && args.length > 0) {
                String cloudDebugString = args[0];
                LOG.log(Level.INFO, "Cloud graphs enabled: {0}", cloudDebugString);
                boolean cloudDebugEnabled = Boolean.parseBoolean(cloudDebugString);
                this.cloudAuth.setCloudAuthEnabled(cloudDebugEnabled);
                SaveToCloudAction saveAction = (SaveToCloudAction)SystemAction.get(SaveToCloudAction.class);
                saveAction.putValue("visible", cloudDebugEnabled);
            }
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }
}

