/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.collab.graph.state;

import com.paterva.maltego.chatapi.msg.LogMessageLevel;
import com.paterva.maltego.collab.CollaborationException;
import com.paterva.maltego.collab.PayloadCollection;
import com.paterva.maltego.collab.graph.state.StateApplyLiveQueue;
import com.paterva.maltego.collab.graph.state.StateConnecting;
import com.paterva.maltego.collab.graph.state.TxQueue;

class StateGotGraph
extends StateConnecting {
    private final PayloadCollection _graph;

    public StateGotGraph(PayloadCollection graph) {
        this._graph = graph;
    }

    @Override
    protected void run() {
        try {
            if (this.graphProvider().hasGraph()) {
                this.graphProvider().resetResolver();
                if (this.isReconnect()) {
                    this.progress(LogMessageLevel.Info, "Replacing local graph with remote", 75);
                    this.debug("replacing local graph with remote");
                    this.graphProvider().replace(this._graph);
                    this.debug("replaying local changes");
                    this.sendLocalQueue();
                } else {
                    this.progress(LogMessageLevel.Info, "Merging local graph with remote", 75);
                    this.debug("merging local graph with remote");
                    this.graphProvider().merge(this._graph);
                }
            } else {
                this.progress(LogMessageLevel.Info, "Received remote graph", 75);
                this.debug("received remote graph");
                this.rx().payloadsReceived(this._graph);
            }
            this.setNextState(new StateApplyLiveQueue());
        }
        catch (CollaborationException ex) {
            this.handleError("Error applying received graph", (Exception)((Object)ex));
        }
    }

    private void sendLocalQueue() throws CollaborationException {
        for (TxQueue.Entry entry : this.localQueue().getPayloads()) {
            this.tx().sendPayload(entry.getTo(), entry.getBody());
        }
        this.localQueue().clear();
    }
}

