/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.collab.graph.state;

import com.paterva.maltego.chatapi.conn.ConnectionInitiationCallback;
import com.paterva.maltego.chatapi.msg.LogMessageLevel;
import com.paterva.maltego.collab.graph.state.AbstractStateMachine;

public abstract class AbstractState<TStateMachine extends AbstractStateMachine> {
    private AbstractStateMachine _states;
    private final boolean _isEndState;

    public AbstractState() {
        this(false);
    }

    public AbstractState(boolean isEndState) {
        this._isEndState = isEndState;
    }

    void setStateMachine(AbstractStateMachine sm) {
        this._states = sm;
    }

    protected final TStateMachine getStateMachine() {
        return (TStateMachine)this._states;
    }

    protected void setNextState(AbstractState state) {
        ((AbstractStateMachine)this.getStateMachine()).setNextState((AbstractState)state);
    }

    protected abstract void run();

    protected void deinit() {
    }

    final boolean isEndState() {
        return this._isEndState;
    }

    protected final ConnectionInitiationCallback getCallback() {
        return this._states.getCallback();
    }

    protected final boolean isCancelled() {
        return this.getCallback().isCancelled();
    }

    protected final void progress(LogMessageLevel level, String message, int percent) {
        this.getCallback().progress(level, message, percent);
    }

    protected final void progress(LogMessageLevel level, String message) {
        this.getCallback().progress(level, message);
    }

    protected final void debug(String message) {
        this._states.debug(message);
    }

    protected final void handleError(Exception e, AbstractState fallback) {
        this._states.handleError(e, fallback);
    }
}

