/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.collab.graph.serialization;

import com.paterva.maltego.collab.graph.serialization.CollaborationSerializationException;
import com.paterva.maltego.collab.graph.serialization.GraphTransactionStub;
import com.paterva.maltego.collab.graph.serialization.TransactionBatchStub;
import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.core.LinkID;
import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.core.MaltegoLink;
import com.paterva.maltego.entity.api.EntityRegistry;
import com.paterva.maltego.entity.api.LinkRegistry;
import com.paterva.maltego.serializers.GraphConnectionSource;
import com.paterva.maltego.serializers.GraphSerializationException;
import com.paterva.maltego.serializers.ViewPositionSource;
import com.paterva.maltego.serializers.compact.CompactGraphReader;
import com.paterva.maltego.serializers.compact.CompactGraphWriter;
import com.paterva.maltego.serializers.compact.DeserializedGraph;
import com.paterva.maltego.serializers.compact.SerializedGraph;
import com.paterva.maltego.serializers.compact.stubs.DynamicPropertyStub;
import com.paterva.maltego.serializers.compact.stubs.EntityStub;
import com.paterva.maltego.serializers.compact.stubs.GraphSnippetStub;
import com.paterva.maltego.serializers.compact.stubs.LinkStub;
import com.paterva.maltego.serializers.compact.stubs.PartStub;
import com.paterva.maltego.serializers.compact.stubs.PropertyStub;
import com.paterva.maltego.typing.DisplayDescriptor;
import com.paterva.maltego.typing.PropertyDescriptor;
import com.paterva.maltego.ui.graph.ModifiedHelper;
import com.paterva.maltego.ui.graph.transactions.GraphOperation;
import com.paterva.maltego.ui.graph.transactions.GraphTransaction;
import com.paterva.maltego.ui.graph.transactions.GraphTransactionBatch;
import com.paterva.maltego.ui.graph.transactions.GraphTransactions;
import com.paterva.maltego.util.NormalException;
import com.paterva.maltego.util.SimilarStrings;
import com.paterva.maltego.util.XMLEscapeUtils;
import java.awt.Point;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.simpleframework.xml.core.Persister;

public class GraphTransactionSerializer {
    private static final String ADD = "add";
    private static final String UPDATE = "update";
    private static final String DELETE = "delete";
    private static final String ADD_PROPERTY = "addprop";
    private static final String DELETE_PROPERTY = "delprop";
    private final CompactGraphWriter _writer = new CompactGraphWriter();
    private final CompactGraphReader _reader = new CompactGraphReader();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString(GraphTransactionBatch batch, GraphID graphID) throws CollaborationSerializationException {
        String str;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            this.write(batch, graphID, (OutputStream)bos);
        }
        finally {
            try {
                bos.close();
            }
            catch (IOException ex) {
                throw new CollaborationSerializationException(ex, true);
            }
        }
        try {
            str = bos.toString("UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new CollaborationSerializationException(ex, true);
        }
        return str;
    }

    public void write(GraphTransactionBatch batch, GraphID graphID, OutputStream os) throws CollaborationSerializationException {
        if (batch != null && !batch.isEmpty()) {
            try {
                TransactionBatchStub stub = new TransactionBatchStub();
                stub.setForwardDescription(XMLEscapeUtils.escapeUnicode((String)batch.getDescription().getStringOne()));
                stub.setReverseDescription(XMLEscapeUtils.escapeUnicode((String)batch.getDescription().getStringTwo()));
                stub.setSequenceNumber(batch.getSequenceNumber());
                stub.setSignificant(batch.isSignificant());
                for (GraphTransaction transaction : batch.getTransactions()) {
                    GraphTransactionStub gts = this.translate(transaction, graphID);
                    if (gts == null) continue;
                    stub.getTransactions().add(gts);
                }
                Persister persister = new Persister();
                persister.write((Object)stub, os, "UTF-8");
            }
            catch (Exception ex) {
                throw new CollaborationSerializationException(ex, true);
            }
        }
    }

    public void write(GraphTransaction transaction, GraphID graphID, OutputStream os) throws CollaborationSerializationException {
        if (transaction != null) {
            try {
                GraphTransactionStub stub = this.translate(transaction, graphID);
                Persister persister = new Persister();
                persister.write((Object)stub, os, "UTF-8");
            }
            catch (Exception ex) {
                throw new CollaborationSerializationException(ex, true);
            }
        }
    }

    private GraphTransactionStub translate(GraphTransaction transaction, GraphID graphID) throws CollaborationSerializationException {
        try {
            GraphTransactionStub stub = new GraphTransactionStub(this.translate(transaction.getOperation()));
            SerializedGraph serializedGraph = new SerializedGraph();
            serializedGraph.setGraph((GraphSnippetStub)stub);
            TransactionSourceWrapper wrapper = new TransactionSourceWrapper(transaction);
            List<MaltegoEntity> entities = this.getEntities(transaction);
            List<MaltegoLink> links = this.getLinks(transaction);
            EntityRegistry entityRegistry = EntityRegistry.forGraphID((GraphID)graphID);
            LinkRegistry linkRegistry = LinkRegistry.forGraphID((GraphID)graphID);
            Map pinned = transaction.getPinned();
            this._writer.copy(entities, links, (ViewPositionSource)wrapper, (GraphConnectionSource)wrapper, entityRegistry, linkRegistry, serializedGraph, transaction.getOperation() == GraphOperation.Add, pinned);
            if (transaction.needsLayout()) {
                stub.setNeedsLayout(Boolean.TRUE);
            }
            this.convertToStatic(stub, this.getCreatedAndModifiedProperties());
            return stub;
        }
        catch (GraphSerializationException ex) {
            throw new CollaborationSerializationException((NormalException)ex);
        }
    }

    private List<MaltegoEntity> getEntities(GraphTransaction transaction) {
        Set entityIDs = transaction.getEntityIDs();
        ArrayList<MaltegoEntity> entities = new ArrayList<MaltegoEntity>(entityIDs.size());
        for (EntityID entityID : entityIDs) {
            entities.add(transaction.getEntity(entityID));
        }
        return entities;
    }

    private List<MaltegoLink> getLinks(GraphTransaction transaction) {
        Set linkIDs = transaction.getLinkIDs();
        ArrayList<MaltegoLink> links = new ArrayList<MaltegoLink>(linkIDs.size());
        for (LinkID linkID : linkIDs) {
            links.add(transaction.getLink(linkID));
        }
        return links;
    }

    private String translate(GraphOperation gop) throws CollaborationSerializationException {
        switch (gop) {
            case Add: {
                return ADD;
            }
            case Delete: {
                return DELETE;
            }
            case Update: {
                return UPDATE;
            }
            case AddProperties: {
                return ADD_PROPERTY;
            }
            case DeleteProperties: {
                return DELETE_PROPERTY;
            }
        }
        throw new CollaborationSerializationException("Unknown graph operation: " + gop, true);
    }

    public GraphTransactionBatch readBatch(String xml, GraphID graphID) throws CollaborationSerializationException {
        try {
            xml = xml.trim();
            if (xml.isEmpty()) {
                return null;
            }
            Persister serializer = new Persister();
            TransactionBatchStub stub = (TransactionBatchStub)serializer.read(TransactionBatchStub.class, xml);
            String fwdDesc = XMLEscapeUtils.unescapeUnicode((String)stub.getForwardDescription());
            String revDesc = XMLEscapeUtils.unescapeUnicode((String)stub.getReverseDescription());
            GraphTransactionBatch batch = new GraphTransactionBatch(new SimilarStrings(fwdDesc, revDesc), stub.isSignificant(), new GraphTransaction[0]);
            batch.setSequenceNumber(stub.getSequenceNumber());
            for (GraphTransactionStub gts : stub.getTransactions()) {
                GraphTransaction transaction = this.translate(gts, graphID);
                if (transaction == null) continue;
                batch.add(transaction);
            }
            return batch;
        }
        catch (Exception ex) {
            throw new CollaborationSerializationException(ex, true);
        }
    }

    private GraphTransaction translate(GraphTransactionStub from, GraphID graphID) throws CollaborationSerializationException {
        GraphOperation operation = this.createOperation(from.getOperation());
        this.convertToDynamic(from, this.getCreatedAndModifiedProperties());
        boolean createUpdateParts = operation != GraphOperation.Add;
        Boolean needsLayout = from.needsLayout();
        if (needsLayout == null) {
            needsLayout = false;
        }
        try {
            DeserializedGraph deserializedGraph = this._reader.translate((GraphSnippetStub)from, graphID, createUpdateParts, true);
            return GraphTransactions.create((GraphOperation)operation, (Collection)deserializedGraph.getEntities(), (Collection)deserializedGraph.getLinks(), (Map)deserializedGraph.getCenters(), (Map)deserializedGraph.getPaths(), (Map)deserializedGraph.getConnections(), (Map)deserializedGraph.getGraphSnippet().getPinned(), (boolean)needsLayout);
        }
        catch (GraphSerializationException e) {
            throw new CollaborationSerializationException((NormalException)e);
        }
    }

    private GraphOperation createOperation(String op) throws CollaborationSerializationException {
        if (ADD.equals(op)) {
            return GraphOperation.Add;
        }
        if (UPDATE.equals(op)) {
            return GraphOperation.Update;
        }
        if (DELETE.equals(op)) {
            return GraphOperation.Delete;
        }
        if (ADD_PROPERTY.equals(op)) {
            return GraphOperation.AddProperties;
        }
        if (DELETE_PROPERTY.equals(op)) {
            return GraphOperation.DeleteProperties;
        }
        throw new CollaborationSerializationException("Unknown graph operation: " + op, true);
    }

    private void convertToStatic(GraphTransactionStub stub, List<DisplayDescriptor> properties) {
        for (EntityStub entityStub : stub.getEntities()) {
            this.convertToStatic((PartStub)entityStub, properties);
        }
        for (LinkStub linkStub : stub.getLinks()) {
            this.convertToStatic((PartStub)linkStub, properties);
        }
    }

    private void convertToStatic(PartStub partStub, List<DisplayDescriptor> properties) {
        List dprops = partStub.getDynamicProperties();
        ArrayList<DynamicPropertyStub> toRemove = new ArrayList<DynamicPropertyStub>();
        block0: for (DynamicPropertyStub dynPropStub : dprops) {
            String propName = dynPropStub.getName();
            for (DisplayDescriptor dd : properties) {
                if (!dd.getName().equals(propName)) continue;
                partStub.add(new PropertyStub(propName, dynPropStub.getValue()));
                toRemove.add(dynPropStub);
                continue block0;
            }
        }
        partStub.removeDynamicProperties(toRemove);
    }

    private void convertToDynamic(GraphTransactionStub stub, List<DisplayDescriptor> properties) {
        for (EntityStub entityStub : stub.getEntities()) {
            this.convertToDynamic((PartStub)entityStub, properties);
        }
        for (LinkStub linkStub : stub.getLinks()) {
            this.convertToDynamic((PartStub)linkStub, properties);
        }
    }

    private void convertToDynamic(PartStub partStub, List<DisplayDescriptor> properties) {
        ArrayList<PropertyStub> toRemove = new ArrayList<PropertyStub>();
        block0: for (PropertyStub propStub : partStub.getProperties()) {
            String propName = propStub.getName();
            for (DisplayDescriptor dd : properties) {
                if (!dd.getName().equals(propName)) continue;
                DynamicPropertyStub dynPropStub = this._writer.translateDynamic((PropertyDescriptor)dd, propStub.getValue());
                partStub.add(dynPropStub);
                toRemove.add(propStub);
                continue block0;
            }
        }
        partStub.removeProperties(toRemove);
    }

    private List<DisplayDescriptor> getCreatedAndModifiedProperties() {
        ArrayList<DisplayDescriptor> properties = new ArrayList<DisplayDescriptor>();
        properties.add(ModifiedHelper.getEntityUserCreatedProperty());
        properties.add(ModifiedHelper.getEntityUserModifiedProperty());
        properties.add(ModifiedHelper.getEntityDateCreatedProperty());
        properties.add(ModifiedHelper.getEntityDateModifiedProperty());
        properties.add(ModifiedHelper.getLinkUserCreatedProperty());
        properties.add(ModifiedHelper.getLinkUserModifiedProperty());
        properties.add(ModifiedHelper.getLinkDateCreatedProperty());
        properties.add(ModifiedHelper.getLinkDateModifiedProperty());
        return properties;
    }

    private static class TransactionSourceWrapper
    implements ViewPositionSource,
    GraphConnectionSource {
        private final GraphTransaction _transaction;

        public TransactionSourceWrapper(GraphTransaction transaction) {
            this._transaction = transaction;
        }

        public Collection<String> getViews() {
            return this._transaction.getViews();
        }

        public Point getCenter(String view, EntityID entityID) {
            return this._transaction.getCenter(view, entityID);
        }

        public List<Point> getPath(String view, LinkID linkID) {
            return this._transaction.getPath(view, linkID);
        }

        public EntityID getSource(LinkID linkID) {
            return this._transaction.getSourceID(linkID);
        }

        public EntityID getTarget(LinkID linkID) {
            return this._transaction.getTargetID(linkID);
        }
    }
}

