/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.collab;

import com.paterva.maltego.collab.Participant;
import com.paterva.maltego.collab.ParticipantPresence;
import com.paterva.maltego.collab.RoomStatusCode;

public class ParticipantEvent {
    public static final int CHANGED = 0;
    public static final int JOINED = 1;
    public static final int LEFT = 2;
    private Participant _participant;
    private int _eventType;
    private ParticipantPresence _presence;
    private RoomStatusCode _roomStatusCode;

    public ParticipantEvent(int type, Participant participant) {
        this(type, participant, null, RoomStatusCode.None);
    }

    public ParticipantEvent(int type, Participant participant, ParticipantPresence presence, RoomStatusCode code) {
        this._eventType = type;
        this._participant = participant;
        this._presence = presence;
        this._roomStatusCode = code;
    }

    public Participant getParticipant() {
        return this._participant;
    }

    public int getEventType() {
        return this._eventType;
    }

    public ParticipantPresence getPresence() {
        return this._presence;
    }

    public static ParticipantEvent getJoined(Participant participant, ParticipantPresence presence, RoomStatusCode status) {
        return new ParticipantEvent(1, participant, presence, status);
    }

    public static ParticipantEvent getLeft(Participant participant) {
        return new ParticipantEvent(2, participant);
    }

    public static ParticipantEvent getChanged(Participant participant, ParticipantPresence presence, RoomStatusCode status) {
        return new ParticipantEvent(0, participant, presence, status);
    }

    public RoomStatusCode getRoomStatusCode() {
        return this._roomStatusCode;
    }
}

