/*
 * Decompiled with CFR 0.152.
 */
package org.xlightweb;

import java.io.IOException;
import java.nio.BufferUnderflowException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xlightweb.BodyDataSink;
import org.xlightweb.HttpUtils;
import org.xlightweb.IBodyCloseListener;
import org.xlightweb.IBodyDataHandler;
import org.xlightweb.NonBlockingBodyDataSource;
import org.xsocket.Execution;

public class BodyForwarder
implements IBodyDataHandler {
    private static final Logger LOG = Logger.getLogger(BodyForwarder.class.getName());
    public static final int DEFAULT_EXECUTION_MODE = 1;
    private final ForwardTask forwardTask = new ForwardTask();
    private final DataSinkCloseHandler dataSinkCloseHandler = new DataSinkCloseHandler();
    private final NonBlockingBodyDataSource bodyDataSource;
    private final BodyDataSink bodyDataSink;
    private AtomicBoolean isComplete = new AtomicBoolean(false);

    public BodyForwarder(NonBlockingBodyDataSource bodyDataSource, BodyDataSink bodyDataSink) {
        this.bodyDataSource = bodyDataSource;
        this.bodyDataSink = bodyDataSink;
        bodyDataSink.addCloseListener(this.dataSinkCloseHandler);
    }

    @Execution(value=0)
    public final boolean onData(NonBlockingBodyDataSource bodyDataSource) throws BufferUnderflowException {
        try {
            if (HttpUtils.isMutlithreaded(this)) {
                bodyDataSource.processMultithreaded(this.forwardTask);
            } else {
                bodyDataSource.processNonthreaded(this.forwardTask);
            }
        }
        catch (Exception e) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("[" + bodyDataSource.getId() + "] error occured by writing data sink " + bodyDataSource + " " + e.toString() + " destroying data source and data sink");
            }
            this.handleException(e);
        }
        return true;
    }

    private void handleEndOfSourceStream() {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("[" + this.bodyDataSource.getId() + "] end of stream reached. dettach data source (" + this.bodyDataSource.getId() + ") and closing data sink (" + this.bodyDataSink.getId() + ")");
        }
        this.isComplete.set(true);
        this.detachBodyDataSource();
        this.callOnComplete();
        this.closeDataSink();
    }

    private void detachBodyDataSource() {
        this.bodyDataSource.setDataHandler(null);
    }

    private void handleException(final Exception e) {
        this.destroy();
        Runnable task = new Runnable(){

            public void run() {
                BodyForwarder.this.onException(e);
            }
        };
        this.bodyDataSource.processMultithreaded(task);
    }

    private void destroy() {
        this.bodyDataSink.destroy();
        this.bodyDataSource.destroy();
        this.isComplete.set(true);
    }

    private void closeDataSink() {
        this.isComplete.set(true);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("[" + this.bodyDataSource.getId() + "] data source " + this.bodyDataSource.getClass().getSimpleName() + " is closed. Closing data sink " + this.bodyDataSink.getClass().getSimpleName());
        }
        try {
            this.bodyDataSink.close();
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public void onData(NonBlockingBodyDataSource bodyDataSource, BodyDataSink bodyDataSink) throws BufferUnderflowException, IOException {
        bodyDataSource.transferTo(bodyDataSink);
    }

    private void callOnComplete() {
        try {
            this.onComplete();
        }
        catch (Exception e) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("error occured by calling onComplete " + e.toString());
            }
            throw new RuntimeException(e.toString());
        }
    }

    public void onComplete() {
    }

    public void onException(Exception e) {
    }

    private final class ForwardTask
    implements Runnable {
        private ForwardTask() {
        }

        public void run() {
            try {
                while (BodyForwarder.this.bodyDataSource.available() > 0) {
                    int version = BodyForwarder.this.bodyDataSource.getReadBufferVersion();
                    BodyForwarder.this.onData(BodyForwarder.this.bodyDataSource, BodyForwarder.this.bodyDataSink);
                    if (version != BodyForwarder.this.bodyDataSource.getReadBufferVersion()) continue;
                    break;
                }
                if (BodyForwarder.this.bodyDataSource.available() == -1) {
                    BodyForwarder.this.handleEndOfSourceStream();
                }
            }
            catch (IOException e) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("[" + BodyForwarder.this.bodyDataSource.getId() + "] error by reading body source or forwarding data to " + BodyForwarder.this.bodyDataSink.getId() + " " + e);
                }
                BodyForwarder.this.handleException(e);
            }
        }
    }

    private final class DataSinkCloseHandler
    implements IBodyCloseListener {
        private DataSinkCloseHandler() {
        }

        public void onClose() throws IOException {
            if (!BodyForwarder.this.isComplete.get()) {
                BodyForwarder.this.destroy();
            }
        }
    }
}

