/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.graph.table.io.impl;

import com.paterva.maltego.graph.table.HeaderTypeOptions;
import com.paterva.maltego.graph.table.TabularGraph;
import com.paterva.maltego.graph.table.TabularGraphEntity;
import com.paterva.maltego.graph.table.TabularGraphLink;
import com.paterva.maltego.graph.table.io.impl.DefaultTabularGraphEntity;
import com.paterva.maltego.graph.table.io.impl.DefaultTabularGraphLink;
import com.paterva.maltego.graph.table.io.impl.TabularGraphUtils;
import com.paterva.maltego.typing.PropertyDescriptor;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class DefaultTabularGraph
extends TabularGraph {
    private final EntityListener _entityListener;
    private final List<TabularGraphEntity> _entities = new ArrayList<TabularGraphEntity>();
    private final List<TabularGraphLink> _links;
    private final Map<String, Set<String>> _typeStrictProperties;
    private boolean _existing = false;
    private boolean _hasHeaderRow;
    private boolean _hasTypeRow;
    private int _columnCount = 0;
    private int _headerRowIndex;
    private int _typeRowIndex;
    private Date _savedDate = null;
    private String _description = "A new mapping configuration.";
    private String _name = "New mapping";
    private String[] _columnNames = null;
    private boolean _readonly = false;

    public DefaultTabularGraph() {
        this._entityListener = new EntityListener();
        this._links = new ArrayList<TabularGraphLink>();
        this._typeStrictProperties = new HashMap<String, Set<String>>();
    }

    public DefaultTabularGraph(TabularGraph tabularGraph) {
        this();
        this._name = tabularGraph.getName();
        this._description = tabularGraph.getDescription();
        this._hasHeaderRow = tabularGraph.hasHeaderRow();
        this._headerRowIndex = tabularGraph.getHeaderRowIndex();
        this._hasTypeRow = tabularGraph.hasTypeRow();
        this._typeRowIndex = tabularGraph.getTypeRowIndex();
        this._columnCount = tabularGraph.getColumnCount();
        if (this._columnCount > 0) {
            this._columnNames = new String[this._columnCount];
            System.arraycopy(tabularGraph.getColumnNames(), 0, this._columnNames, 0, this._columnCount);
        }
        this._readonly = tabularGraph.isReadOnly();
        this.copyEntitiesFrom(tabularGraph);
        this.copyLinksFrom(tabularGraph);
        this.copyStrictPropertiesFrom(tabularGraph);
    }

    private void copyEntitiesFrom(TabularGraph tabularGraph) {
        for (TabularGraphEntity tbge : tabularGraph.getEntities()) {
            DefaultTabularGraphEntity tempEntity = new DefaultTabularGraphEntity(tbge);
            this.putEntity(tempEntity);
        }
    }

    private void copyLinksFrom(TabularGraph tabularGraph) {
        for (TabularGraphLink tbli : tabularGraph.getLinks()) {
            TabularGraphEntity source = tbli.getSource();
            TabularGraphEntity sourceCopy = null;
            TabularGraphEntity target = tbli.getTarget();
            TabularGraphEntity targetCopy = null;
            boolean sourceFound = false;
            boolean targetFound = false;
            for (int i = 0; !(i >= this.getEntities().size() || sourceFound && targetFound); ++i) {
                if (!sourceFound && source == tabularGraph.getEntities().get(i)) {
                    sourceFound = true;
                    sourceCopy = this.getEntities().get(i);
                }
                if (targetFound || target != tabularGraph.getEntities().get(i)) continue;
                targetFound = true;
                targetCopy = this.getEntities().get(i);
            }
            this.putLink(new DefaultTabularGraphLink(tbli, sourceCopy, targetCopy));
        }
    }

    private void copyStrictPropertiesFrom(TabularGraph tabularGraph) {
        for (Map.Entry entrySet : tabularGraph.getTypeStrictProperties().entrySet()) {
            String typeName = (String)entrySet.getKey();
            Set props = (Set)entrySet.getValue();
            this._typeStrictProperties.put(typeName, new HashSet(props));
        }
    }

    public List<TabularGraphEntity> getEntities() {
        return Collections.unmodifiableList(this._entities);
    }

    public List<TabularGraphLink> getLinks() {
        return Collections.unmodifiableList(this._links);
    }

    public void putEntityWithProperty(String entitySpecName, int[] columns, PropertyDescriptor[] props) {
        if (columns.length != props.length) {
            return;
        }
        this.removeColumnsFromEntities(columns);
        DefaultTabularGraphEntity entity = new DefaultTabularGraphEntity(entitySpecName);
        for (int i = 0; i < columns.length; ++i) {
            entity.put(columns[i], props[i]);
        }
        this._entities.add(entity);
        entity.addPropertyChangeListener(this._entityListener);
        this.firePropertyChanged("entityAdded", null, entity);
    }

    public void putEntity(String entitySpecName, int ... columns) {
        this.removeColumnsFromEntities(columns);
        DefaultTabularGraphEntity entity = new DefaultTabularGraphEntity(entitySpecName);
        for (int column : columns) {
            entity.put(column, TabularGraphUtils.getNextUnusedProperty(entity));
            this.firePropertyChanged("columnAdded", null, column);
        }
        this._entities.add(entity);
        entity.addPropertyChangeListener(this._entityListener);
        this.firePropertyChanged("entityAdded", null, entity);
    }

    public void putEntity(TabularGraphEntity entity) {
        this._entities.add(entity);
        entity.addPropertyChangeListener((PropertyChangeListener)this._entityListener);
        this.firePropertyChanged("entityAdded", null, entity);
    }

    public void putLink(TabularGraphLink link) {
        this._links.add(link);
        this.firePropertyChanged("linkAdded", null, link);
    }

    public void addColumns(TabularGraphLink link, int ... columns) {
        boolean updated = false;
        for (TabularGraphLink l : this._links) {
            if (link.equals(l)) continue;
            l.remove(columns);
            updated = true;
        }
        for (Object column : (Object)columns) {
            if (link.contains((int)column)) continue;
            PropertyDescriptor pd = TabularGraphUtils.getNextUnusedProperty(link);
            link.put((int)column, pd);
            updated = true;
        }
        if (updated) {
            this.firePropertyChanged("linkUpdated", null, link);
        }
    }

    public void removeLink(TabularGraphLink link) {
        this._links.remove(link);
        this.firePropertyChanged("linkRemoved", link, null);
    }

    public void removeColumnsFromEntities(int ... columns) {
        for (int column : columns) {
            TabularGraphEntity entity = TabularGraphUtils.getEntity(this, column);
            if (entity == null) continue;
            this.removeColumnFromEntity(entity, column);
        }
    }

    private void removeColumnFromEntity(TabularGraphEntity entity, int column) {
        entity.remove(new int[]{column});
        this.firePropertyChanged("columnRemoved", new Object[]{entity, column}, null);
        if (entity.getColumnCount() == 0) {
            this._entities.remove(entity);
            Iterator<TabularGraphLink> it = this._links.iterator();
            while (it.hasNext()) {
                TabularGraphLink link = it.next();
                if (!link.getSource().equals(entity) && !link.getTarget().equals(entity)) continue;
                it.remove();
            }
            entity.removePropertyChangeListener((PropertyChangeListener)this._entityListener);
            this.firePropertyChanged("entityRemoved", entity, null);
        } else {
            this.firePropertyChanged("entityUpdated", null, entity);
        }
    }

    public void removeColumnsFromLinks(int ... columns) {
        for (int column : columns) {
            TabularGraphLink link = TabularGraphUtils.getLink(this, column);
            if (link == null) continue;
            link.remove(new int[]{column});
            this.firePropertyChanged("columnRemoved", new Object[]{link, column}, null);
            this.firePropertyChanged("linkUpdated", null, link);
        }
    }

    public int getColumnCount() {
        return this._columnCount;
    }

    public void setColumnCount(int columns) {
        this._columnCount = columns;
    }

    public String[] getColumnNames() {
        return this._columnNames;
    }

    public void setColumnNames(String[] columnNames) {
        if (columnNames.length != this._columnCount) {
            throw new IllegalArgumentException();
        }
        this._columnNames = columnNames;
        this.firePropertyChanged("columnNamesChanged", null, this._columnNames);
    }

    public boolean hasHeaderRow() {
        return this._hasHeaderRow;
    }

    public int getHeaderRowIndex() {
        return this._headerRowIndex;
    }

    private void setHasHeaderRow(boolean hasHeaders) {
        this.setHasHeaderRow(hasHeaders, 0);
    }

    private void setHasHeaderRow(boolean hasHeaders, int headerRowIndex) {
        this._hasHeaderRow = hasHeaders;
        this._headerRowIndex = headerRowIndex;
        this.firePropertyChanged("hasHeaderRowChanged", null, null);
    }

    public boolean hasTypeRow() {
        return this._hasTypeRow;
    }

    public int getTypeRowIndex() {
        return this._typeRowIndex;
    }

    private void setHasTypeRow(boolean hasType) {
        this.setHasTypeRow(hasType, 0);
    }

    private void setHasTypeRow(boolean hasType, int typeRowIndex) {
        this._hasTypeRow = hasType;
        this._typeRowIndex = typeRowIndex;
    }

    public HeaderTypeOptions getHeaderTypeOption() {
        boolean h = this.hasHeaderRow();
        boolean t = this.hasTypeRow();
        if (h && t) {
            if (this.getHeaderRowIndex() == 0) {
                return HeaderTypeOptions.HEAD_THEN_TYPE;
            }
            return HeaderTypeOptions.TYPE_THEN_HEAD;
        }
        if (h) {
            return HeaderTypeOptions.HEAD_ONLY;
        }
        if (t) {
            return HeaderTypeOptions.TYPE_ONLY;
        }
        return HeaderTypeOptions.NO_HEAD_OR_TYPE;
    }

    public void setHeaderTypeOptions(HeaderTypeOptions hto) {
        switch (hto) {
            case NO_HEAD_OR_TYPE: {
                this.setHasTypeRow(false);
                this.setHasHeaderRow(false);
                break;
            }
            case HEAD_ONLY: {
                this.setHasTypeRow(false);
                this.setHasHeaderRow(true);
                break;
            }
            case TYPE_ONLY: {
                this.setHasTypeRow(true);
                this.setHasHeaderRow(false);
                break;
            }
            case HEAD_THEN_TYPE: {
                this.setHasTypeRow(true, 1);
                this.setHasHeaderRow(true, 0);
                break;
            }
            case TYPE_THEN_HEAD: {
                this.setHasTypeRow(true, 0);
                this.setHasHeaderRow(true, 1);
                break;
            }
        }
    }

    public TabularGraphLink findLink(TabularGraphEntity source, TabularGraphEntity target) {
        for (TabularGraphLink link : this._links) {
            if (!link.getSource().equals(source) || !link.getTarget().equals(target)) continue;
            return link;
        }
        return null;
    }

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    public String getDescription() {
        return this._description;
    }

    public void setDescription(String description) {
        this._description = description;
    }

    public Date getSavedDate() {
        return this._savedDate;
    }

    public void setSavedDate(Date savedDate) {
        this._savedDate = savedDate;
    }

    public boolean isExisting() {
        return this._existing;
    }

    public void setExisting(boolean existing) {
        this._existing = existing;
    }

    public Map<String, Set<String>> getTypeStrictProperties() {
        return this._typeStrictProperties;
    }

    public String toString() {
        return this.getName();
    }

    public boolean isCopyOf(TabularGraph graph) {
        if (graph instanceof DefaultTabularGraph) {
            return super.isCopyOf(graph);
        }
        return false;
    }

    public boolean isReadOnly() {
        return this._readonly;
    }

    public void setReadOnly(boolean readonly) {
        this._readonly = readonly;
    }

    private class EntityListener
    implements PropertyChangeListener {
        private EntityListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("mappingChanged".equals(evt.getPropertyName())) {
                DefaultTabularGraph.this.firePropertyChanged("entityUpdated", evt.getOldValue(), evt.getNewValue());
            }
        }
    }
}

