/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.graph.table.ui.wizard;

import com.paterva.maltego.graph.table.TabularGraph;
import com.paterva.maltego.graph.table.TabularGraphLink;
import com.paterva.maltego.graph.table.io.impl.TabularGraphUtils;
import com.paterva.maltego.graph.table.ui.wizard.LinkPropertyTableModel;
import com.paterva.maltego.graph.table.ui.wizard.LinkSampleTableModel;
import com.paterva.maltego.graph.table.ui.wizard.MappingPanel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class LinkMappingPanel
extends MappingPanel {
    private static final String HINT_STEP1 = "Select multiple \"Unmapped\" columns that should be mapped to a link.";
    private static final String HINT_STEP2 = "<HTML>Select the link from the \"Map to\" list.<br> Tip: to add or remove a column from the selected link hold down &lt;Ctrl&gt; and click on the column.</HTML>";
    private static final String HINT_STEP3 = "To change the property mapping change the appropriate value in the \"Property\" column.";

    public LinkMappingPanel() {
        super(new LinkSampleTableModel(), new LinkPropertyTableModel());
    }

    @Override
    protected List getMappableItems() {
        ArrayList links = new ArrayList(this.getTabularGraph().getLinks());
        Collections.sort(links, (left, right) -> left.toString().compareToIgnoreCase(right.toString()));
        return links;
    }

    @Override
    protected Object getItem(int column) {
        return TabularGraphUtils.getLink((TabularGraph)this.getTabularGraph(), (int)column);
    }

    @Override
    protected List getItems(int[] columns) {
        List links = TabularGraphUtils.getLinks((TabularGraph)this.getTabularGraph(), (int[])columns);
        return links;
    }

    @Override
    protected Object getMappedItem(Object columnItem) {
        return columnItem;
    }

    @Override
    protected void onComboChanged(Object comboItem) {
        int[] selectedColumns = this.getSelectedColumns();
        TabularGraphLink link = (TabularGraphLink)comboItem;
        this.getTabularGraph().addColumns(link, selectedColumns);
    }

    @Override
    protected void removeMapping(int[] columns) {
        this.getTabularGraph().removeColumnsFromLinks(columns);
    }

    @Override
    protected String getTooltip(int state) {
        switch (state) {
            case 0: {
                return HINT_STEP1;
            }
            case 1: {
                return HINT_STEP2;
            }
            case 2: {
                return HINT_STEP3;
            }
        }
        return "";
    }
}

