/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.graph.table.ui.exp.wizard;

import com.paterva.maltego.graph.table.io.exp.TabularGraphFileExporter;
import com.paterva.maltego.util.ui.dialog.SaveFileController;
import com.paterva.maltego.util.ui.filechooser.FileChooserUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.openide.WizardDescriptor;
import org.openide.WizardValidationException;

class TabularExportFileController
extends SaveFileController {
    private boolean fileBOMCheckbox = false;

    public TabularExportFileController() {
        super(null, null);
        this.setDescription("Choose the name, file type and location on your file system to save the table structured file.");
    }

    public void readSettings(WizardDescriptor settings) {
        super.readSettings(settings);
        TabularGraphFileExporter[] exporters = (TabularGraphFileExporter[])settings.getProperty("exporters");
        this.populateFileTypes(exporters);
    }

    private void populateFileTypes(TabularGraphFileExporter[] exporters) {
        JFileChooser component = (JFileChooser)this.component();
        component.resetChoosableFileFilters();
        component.setAcceptAllFileFilterUsed(false);
        ArrayList<String> extensions = new ArrayList<String>();
        for (TabularGraphFileExporter exporter : exporters) {
            String extension = exporter.getExtension();
            component.addChoosableFileFilter(new FileNameExtensionFilter(exporter.getFileTypeDescription(), extension));
            extensions.add(extension);
        }
        if (!this.fileBOMCheckbox) {
            this.addFileBOMCheckbox(component);
            this.fileBOMCheckbox = true;
        }
        this.setFileExtensions(extensions.toArray(new String[extensions.size()]));
    }

    private void addFileBOMCheckbox(JFileChooser component) {
        final JCheckBox checkbox = new JCheckBox();
        boolean enabled = true;
        checkbox.setEnabled(enabled);
        this.getDescriptor().putProperty("fileBomCheckbox", (Object)enabled);
        boolean selected = false;
        checkbox.setSelected(selected);
        this.getDescriptor().putProperty("fileIncludeBom", (Object)selected);
        checkbox.addItemListener(e -> {
            int state = e.getStateChange();
            if (state == 1) {
                this.getDescriptor().putProperty("fileIncludeBom", (Object)true);
            } else {
                this.getDescriptor().putProperty("fileIncludeBom", (Object)false);
            }
        });
        JPanel panel = new JPanel(new BorderLayout(10, 0));
        panel.add((Component)checkbox, "Center");
        JLabel label = new JLabel("");
        label.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/com/paterva/maltego/graph/table/ui/resources/Help.png")));
        label.setToolTipText("Some programs like Excel may need a Byte Order Mark (BOM) to properly display languages that contain special Unicode characters, but this might cause problems if the file is read by a machine.");
        panel.add((Component)label, "East");
        component.addPropertyChangeListener("fileFilterChanged", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent arg) {
                if (arg.getNewValue() == null || !(arg.getNewValue() instanceof FileNameExtensionFilter)) {
                    return;
                }
                FileNameExtensionFilter newValue = (FileNameExtensionFilter)arg.getNewValue();
                String[] extnew = newValue.getExtensions();
                if (extnew != null && extnew.length > 0 && "csv".equals(extnew[0])) {
                    checkbox.setEnabled(true);
                    TabularExportFileController.this.getDescriptor().putProperty("fileBomCheckbox", (Object)true);
                } else {
                    checkbox.setEnabled(false);
                    TabularExportFileController.this.getDescriptor().putProperty("fileBomCheckbox", (Object)false);
                }
            }
        });
        FileChooserUtil.addAdditionalFieldsToChooser((JFileChooser)component, (String[])new String[]{"Write Byte Order Mark (BOM):"}, (JComponent[])new JComponent[]{panel});
    }

    public void validate() throws WizardValidationException {
        super.validate();
        File file = this.getSelectedFile();
        TabularGraphFileExporter[] exporters = (TabularGraphFileExporter[])this.getDescriptor().getProperty("exporters");
        TabularGraphFileExporter exporter = null;
        for (TabularGraphFileExporter graphTableExporter : exporters) {
            if (!file.getName().endsWith("." + graphTableExporter.getExtension())) continue;
            exporter = graphTableExporter;
            break;
        }
        if (exporter == null) {
            String error = "No exporter found for the selected file type";
            throw new WizardValidationException((JComponent)this.component(), error, error);
        }
        this.getDescriptor().putProperty("fileExporter", exporter);
        exporter.setFile(file);
        Boolean isFileBOMCheckboxEnabled = (Boolean)this.getDescriptor().getProperty("fileBomCheckbox");
        Boolean includeFileBOM = (Boolean)this.getDescriptor().getProperty("fileIncludeBom");
        exporter.setIncludeFileBOM(isFileBOMCheckboxEnabled != false && includeFileBOM != false);
    }
}

