/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.graph.table.ui.exp.wizard;

import com.paterva.maltego.graph.table.io.exp.TabularGraphFileExporter;
import com.paterva.maltego.graph.table.ui.exp.wizard.TabularExportConfigController;
import com.paterva.maltego.graph.table.ui.exp.wizard.TabularExportFileController;
import com.paterva.maltego.graph.table.ui.exp.wizard.TabularExportProgressController;
import com.paterva.maltego.graph.table.ui.exp.wizard.TabularExportSettings;
import com.paterva.maltego.util.ui.dialog.ArrayWizardIterator;
import com.paterva.maltego.util.ui.dialog.WizardUtilities;
import java.text.MessageFormat;
import org.openide.WizardDescriptor;
import org.openide.util.NbPreferences;
import yguard.A.J.SA;

public class ExportWizard {
    private ExportWizard() {
    }

    public static WizardDescriptor create(SA viewGraph, TabularGraphFileExporter[] exporters) {
        String WIZARD_TITLE = "Graph Export Wizard";
        WizardDescriptor.Panel[] panels = new WizardDescriptor.Panel[]{new TabularExportConfigController(), new TabularExportFileController(), new TabularExportProgressController()};
        WizardUtilities.updatePanels((WizardDescriptor.Panel[])panels);
        WizardDescriptor wizardDescriptor = new WizardDescriptor((WizardDescriptor.Iterator)new ArrayWizardIterator(panels));
        wizardDescriptor.setTitleFormat(new MessageFormat("Graph Export Wizard - {0}"));
        wizardDescriptor.setTitle("Graph Export Wizard");
        wizardDescriptor.putProperty("WizardPanel_helpDisplayed", (Object)Boolean.FALSE);
        wizardDescriptor.putProperty("viewGraph", (Object)viewGraph);
        wizardDescriptor.putProperty("exporters", (Object)exporters);
        wizardDescriptor.putProperty("exportSelection", (Object)TabularExportSettings.isExportSelectionOnly());
        wizardDescriptor.putProperty("removeDuplicates", (Object)TabularExportSettings.isRemoveDuplicateRows());
        wizardDescriptor.putProperty("browseDir", (Object)NbPreferences.root().get("browseDir", ""));
        return wizardDescriptor;
    }
}

