/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.licensing.json.rest;

import com.paterva.maltego.licensing.json.rest.InvalidKeyPairException;
import com.paterva.maltego.licensing.json.rest.MaltegoIDKeyPair;
import com.paterva.maltego.licensing.serialize.M;
import com.paterva.maltego.util.MachineIDProvider;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Arrays;
import java.util.Base64;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SignatureService {
    private static final Logger LOG = Logger.getLogger(SignatureService.class.getName());
    private static SignatureService instance;
    private PrivateKey privateKey;
    private PublicKey publicKey;
    private PublicKey serverPublicKey;

    private SignatureService() {
    }

    public static SignatureService getInstance() throws IOException, GeneralSecurityException, InvalidKeyPairException {
        if (instance == null) {
            KeyFactory keyFactory;
            PublicKey serverPublicKey;
            PublicKey publicKey;
            PrivateKey privateKey;
            block10: {
                privateKey = null;
                publicKey = null;
                serverPublicKey = null;
                keyFactory = KeyFactory.getInstance("RSA");
                if (M.D()) {
                    try {
                        MaltegoIDKeyPair maltegoIDKeyPair = M.A();
                        byte[] publicKeyBytes = Base64.getDecoder().decode(maltegoIDKeyPair.getPublicKeyBase64());
                        X509EncodedKeySpec publicKeySpec = new X509EncodedKeySpec(publicKeyBytes);
                        publicKey = keyFactory.generatePublic(publicKeySpec);
                        byte[] privateKeyBytes = Base64.getDecoder().decode(maltegoIDKeyPair.getPrivateKeyBase64());
                        PKCS8EncodedKeySpec privateKeySpec = new PKCS8EncodedKeySpec(privateKeyBytes);
                        privateKey = keyFactory.generatePrivate(privateKeySpec);
                        boolean keypairVerified = SignatureService.verifyKeypair(publicKey, maltegoIDKeyPair.getSignatureBlob());
                        if (!keypairVerified) {
                            throw new InvalidKeyPairException("Keypair cannot be verified!");
                        }
                        break block10;
                    }
                    catch (InvalidKeyPairException e) {
                        LOG.log(Level.SEVERE, "Problem when reading public/private keys from file", e);
                        throw e;
                    }
                    catch (IOException | GeneralSecurityException e) {
                        LOG.log(Level.SEVERE, "Problem when reading public/private keys from file", e);
                        throw new InvalidKeyPairException(e);
                    }
                }
                LOG.log(Level.INFO, "Keypair not found, generating keypair");
                try {
                    KeyPairGenerator generator = KeyPairGenerator.getInstance("RSA");
                    generator.initialize(4096);
                    KeyPair pair = generator.generateKeyPair();
                    publicKey = pair.getPublic();
                    String publicKeyBase64 = Base64.getEncoder().encodeToString(publicKey.getEncoded());
                    privateKey = pair.getPrivate();
                    String privateKeyBase64 = Base64.getEncoder().encodeToString(privateKey.getEncoded());
                    String signature = SignatureService.createSignatureForKeypair(privateKey);
                    MaltegoIDKeyPair maltegoIDKeyPair = new MaltegoIDKeyPair(publicKeyBase64, privateKeyBase64, signature);
                    M.A(maltegoIDKeyPair);
                    LOG.log(Level.INFO, "Keypair generated successfully");
                }
                catch (IOException e) {
                    LOG.log(Level.SEVERE, "Problem when writing the generated public/private keys to file", e);
                    throw e;
                }
            }
            try {
                LOG.log(Level.INFO, "Reading server public key");
                serverPublicKey = M.A(keyFactory);
            }
            catch (IOException | GeneralSecurityException e) {
                LOG.log(Level.SEVERE, "Problem when reading server public key from file", e);
                throw e;
            }
            instance = new SignatureService();
            SignatureService.instance.privateKey = privateKey;
            SignatureService.instance.publicKey = publicKey;
            SignatureService.instance.serverPublicKey = serverPublicKey;
        }
        return instance;
    }

    private static String createSignatureForKeypair(PrivateKey privateKey) throws GeneralSecurityException, IOException {
        String[] macIdCandidatesArray = MachineIDProvider.getDefault().getIDCandidates(false);
        if (macIdCandidatesArray.length > 5) {
            macIdCandidatesArray = Arrays.copyOfRange(macIdCandidatesArray, 1, macIdCandidatesArray.length - 1);
        }
        List<String> macIdCandidatesList = Arrays.asList(macIdCandidatesArray);
        StringBuilder sb = new StringBuilder();
        Iterator<String> iterator = macIdCandidatesList.iterator();
        while (iterator.hasNext()) {
            String macIdCandidate = iterator.next();
            String signature = SignatureService.sign(macIdCandidate, privateKey);
            sb.append(signature);
            if (!iterator.hasNext()) continue;
            sb.append(".");
        }
        return sb.toString();
    }

    private static String sign(String content, PrivateKey privateKey) throws GeneralSecurityException {
        Signature signer = Signature.getInstance("SHA256WithRSA");
        signer.initSign(privateKey);
        signer.update(content.getBytes(StandardCharsets.UTF_8));
        byte[] signature = signer.sign();
        return Base64.getEncoder().encodeToString(signature);
    }

    private static boolean verifyKeypair(PublicKey publicKey, String signatureBlob) throws InvalidKeyPairException {
        String[] macIdCandidatesArray = MachineIDProvider.getDefault().getIDCandidates(false);
        String[] signatureArray = signatureBlob.split("\\.");
        int required = (signatureArray.length + 2) / 3;
        if ((required = Math.max(required, 1)) > 4) {
            required = 4;
        }
        int count = 0;
        block2: for (String signature : signatureArray) {
            for (String macIdCandidate : macIdCandidatesArray) {
                try {
                    boolean verify = SignatureService.verify(macIdCandidate, signature, publicKey);
                    if (!verify) continue;
                    if (++count < required) continue block2;
                    LOG.log(Level.INFO, "Public/private key pair verified");
                    return true;
                }
                catch (GeneralSecurityException e) {
                    throw new InvalidKeyPairException("Keypair cannot be verified!", e);
                }
            }
        }
        LOG.log(Level.WARNING, "Public/private key pair cannot be verified!");
        return false;
    }

    private static boolean verify(String content, String signature, PublicKey publicKey) throws GeneralSecurityException {
        byte[] contentBytes = content.getBytes(StandardCharsets.UTF_8);
        byte[] signatureBytes = signature.getBytes(StandardCharsets.UTF_8);
        Signature verifier = Signature.getInstance("SHA256WithRSA");
        verifier.initVerify(publicKey);
        verifier.update(contentBytes);
        return verifier.verify(Base64.getDecoder().decode(signatureBytes));
    }

    public String signMessage(String message) throws GeneralSecurityException {
        String signature = SignatureService.sign(message, this.privateKey);
        return String.format("%s.%s", message, signature);
    }

    public boolean verifyServerMessage(String messageStr, String signatureStr) throws GeneralSecurityException {
        return SignatureService.verify(messageStr, signatureStr, this.serverPublicKey);
    }

    public String getPublicKeyAsString() {
        return Base64.getEncoder().encodeToString(this.publicKey.getEncoded());
    }
}

