/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.java.config;

import com.paterva.maltego.java.config.ConfigOptions;
import com.paterva.maltego.java.config.MatteBorderLeft;
import com.paterva.maltego.java.config.MemorySlider;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class MemoryPanel
extends JPanel {
    protected JTextField _maxHeapSize;
    protected JPanel _memorySliderPanel;
    protected MemorySlider _memorySlider;
    protected JLabel _errorLabel;
    private SliderValueListener _sliderListener;
    private ChangeListener _changeListener;
    private int _min = 0;
    private int _max = Integer.MAX_VALUE;
    private boolean _textUpdating = false;
    private boolean _sliderUpdating = false;

    public MemoryPanel() {
        this.initComponents();
    }

    private void initComponents() {
        JLabel label1 = new JLabel("Max Memory");
        JLabel label2 = new JLabel("MB");
        JTextArea disclaimer = new JTextArea("Warning: It is possible that Maltego will not start up if this value is set too high.");
        disclaimer.setFont(label1.getFont());
        disclaimer.setLineWrap(true);
        disclaimer.setWrapStyleWord(true);
        disclaimer.setOpaque(false);
        disclaimer.setEditable(false);
        this._errorLabel = new JLabel("");
        this._errorLabel.setForeground(UIManager.getLookAndFeelDefaults().getColor("7-red"));
        this._maxHeapSize = new JTextField("0", 6);
        this._maxHeapSize.setHorizontalAlignment(4);
        this._maxHeapSize.setMaximumSize(new Dimension(100, this._maxHeapSize.getPreferredSize().height));
        this._maxHeapSize.getDocument().addDocumentListener(new MemoryTextListener());
        JPanel disclaimerPanel = new JPanel(new BorderLayout());
        disclaimerPanel.setBorder(BorderFactory.createEmptyBorder(3, 10, 3, 10));
        disclaimerPanel.add(disclaimer);
        disclaimerPanel.setAlignmentX(0.0f);
        JPanel maxMemPanel = new JPanel();
        maxMemPanel.setAlignmentX(0.0f);
        maxMemPanel.setLayout(new BoxLayout(maxMemPanel, 0));
        maxMemPanel.setBorder(BorderFactory.createEmptyBorder(3, 10, 6, 10));
        maxMemPanel.add(label1);
        maxMemPanel.add(Box.createRigidArea(new Dimension(10, 0)));
        maxMemPanel.add(this._maxHeapSize);
        maxMemPanel.add(Box.createRigidArea(new Dimension(10, 0)));
        maxMemPanel.add(label2);
        maxMemPanel.add(Box.createRigidArea(new Dimension(10, 0)));
        maxMemPanel.add(this._errorLabel);
        String architecture = System.getProperty("sun.arch.data.model");
        int splitLow = 512;
        int splitHigh = 1024;
        if ("64".equals(architecture)) {
            splitLow = 1024;
            splitHigh = 4096;
        }
        this._sliderListener = new SliderValueListener();
        this._memorySlider = new MemorySlider(new int[]{64, 128, 256, 512, 1024, 2048, 4096, 8192}, splitLow, splitHigh);
        this._memorySlider.addListener(this._sliderListener);
        this._memorySliderPanel = new JPanel(new BorderLayout());
        this._memorySliderPanel.setAlignmentX(0.0f);
        this._memorySliderPanel.add(this._memorySlider);
        this._min = 64;
        this._max = 8192;
        this.setLayout(new BoxLayout(this, 1));
        this.setBorder(BorderFactory.createTitledBorder(new MatteBorderLeft(UIManager.getLookAndFeelDefaults().getInt("TitledBorder.darculaMod.matteBorderWidth"), UIManager.getLookAndFeelDefaults().getColor("TitledBorder.darculaMod.matteBorderColor")), "Memory"));
        this.add(disclaimerPanel);
        this.add(maxMemPanel);
        this.add(this._memorySliderPanel);
    }

    public void set(int min, int max, int value) {
        int splitHigh;
        int splitLow;
        int powerOf2 = (int)Math.pow(2.0, Math.ceil(Math.log(min) / Math.log(2.0)));
        ArrayList<Integer> splits = new ArrayList<Integer>();
        splits.add(min);
        if (powerOf2 == min) {
            powerOf2 *= 2;
        }
        while (powerOf2 < max) {
            splits.add(powerOf2);
            powerOf2 *= 2;
        }
        splits.add(max);
        int[] intSplits = this.toPrimitiveIntArray(splits);
        if (splits.size() >= 4) {
            splitLow = intSplits[intSplits.length - 3];
            splitHigh = intSplits[intSplits.length - 2];
        } else if (splits.size() == 3) {
            splitLow = intSplits[intSplits.length - 2];
            splitHigh = intSplits[intSplits.length - 1];
        } else {
            splitLow = intSplits[intSplits.length - 1];
            splitHigh = intSplits[intSplits.length - 1];
        }
        this._memorySlider.removeListener(this._sliderListener);
        this._memorySlider = new MemorySlider(intSplits, splitLow, splitHigh);
        this._memorySlider.addListener(new SliderValueListener());
        this._memorySliderPanel.removeAll();
        this._memorySliderPanel.add(this._memorySlider);
        this._min = min;
        this._max = max;
        value = Math.min(value, max);
        value = Math.max(value, min);
        this._maxHeapSize.setText(Integer.toString(value));
    }

    public int getMaxMemory() {
        String text = this._maxHeapSize.getText();
        return text.length() > 0 ? Integer.parseInt(text) : -1;
    }

    public void store(ConfigOptions options) {
        try {
            int maxHeapSize = Integer.parseInt(this._maxHeapSize.getText());
            options.setMaxHeapSize(maxHeapSize);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public boolean valid() {
        try {
            int maxHeapSize = Integer.parseInt(this._maxHeapSize.getText());
            if (maxHeapSize < this._min) {
                this._errorLabel.setText("* Must be " + this._min + "MB or more");
                return false;
            }
            if (maxHeapSize > this._max) {
                this._errorLabel.setText("* Must be less than " + this._max + "MB");
                return false;
            }
        }
        catch (NumberFormatException ex) {
            this._errorLabel.setText("* Must be numeric");
            return false;
        }
        this._errorLabel.setText("");
        return true;
    }

    private void setTextValue(String text) {
        this._maxHeapSize.setText(text);
    }

    private void setSliderValue(String text) {
        this._memorySlider.setValue(Integer.valueOf(text));
    }

    void setChangeListener(ChangeListener listener) {
        this._changeListener = listener;
    }

    private int[] toPrimitiveIntArray(List<Integer> integers) {
        int[] ret = new int[integers.size()];
        Iterator<Integer> iterator = integers.iterator();
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = iterator.next();
        }
        return ret;
    }

    private class SliderValueListener
    implements ChangeListener {
        boolean _updating = false;

        @Override
        public void stateChanged(ChangeEvent e) {
            if (!MemoryPanel.this._textUpdating) {
                MemoryPanel.this._sliderUpdating = true;
                MemoryPanel.this.setTextValue(String.format("%d", MemoryPanel.this._memorySlider.getValue()));
                MemoryPanel.this.valid();
                MemoryPanel.this._sliderUpdating = false;
            }
        }
    }

    private class MemoryTextListener
    implements DocumentListener {
        boolean _updating = false;

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.setValue();
            this.fireChanged();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.setValue();
            this.fireChanged();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.fireChanged();
        }

        private void setValue() {
            if (!MemoryPanel.this._sliderUpdating && MemoryPanel.this.valid()) {
                MemoryPanel.this._textUpdating = true;
                MemoryPanel.this.setSliderValue(MemoryPanel.this._maxHeapSize.getText());
                MemoryPanel.this._textUpdating = false;
            }
        }

        private void fireChanged() {
            if (MemoryPanel.this._changeListener != null) {
                MemoryPanel.this._changeListener.stateChanged(null);
            }
        }
    }
}

