/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.automation.view.progress;

import com.bulenkov.darcula.ui.DarculaProgressBarUI;
import com.bulenkov.iconloader.util.GraphicsUtil;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.geom.Area;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.ComponentUI;

public class MachineRuntimeViewProgressBarUI
extends DarculaProgressBarUI {
    public static ComponentUI createUI(JComponent c) {
        c.setBorder(new BorderUIResource(new EmptyBorder(0, 0, 0, 0)));
        return new MachineRuntimeViewProgressBarUI();
    }

    protected void paintIndeterminate(Graphics g, JComponent c) {
        if (!(g instanceof Graphics2D)) {
            return;
        }
        Insets b = this.progressBar.getInsets();
        int barRectWidth = this.progressBar.getWidth() - (b.right + b.left);
        int barRectHeight = this.progressBar.getPreferredSize().height - (b.top + b.bottom);
        if (barRectWidth <= 0 || barRectHeight <= 0) {
            return;
        }
        g.setColor(this.getProgressColor(c));
        int w = barRectWidth;
        int h = barRectHeight;
        g.fillRect(0, 0, w, h);
        g.setColor(UIManager.getLookAndFeelDefaults().getColor("ProgressBar.darculaMod.IndeterminateColor2"));
        GraphicsUtil.setupAAPainting((Graphics)g);
        Path2D.Double path = new Path2D.Double();
        int ww = this.getPeriodLength() / 2;
        path.moveTo(0.0, 0.0);
        path.lineTo(ww, 0.0);
        path.lineTo(ww - h / 2, h);
        path.lineTo(-h / 2, h);
        path.lineTo(0.0, 0.0);
        path.closePath();
        for (int x = -this.offset; x < Math.max(barRectWidth, barRectHeight); x += this.getPeriodLength()) {
            g.translate(x, 0);
            ((Graphics2D)g).fill(path);
            g.translate(-x, 0);
        }
        this.offset = (this.offset + 1) % this.getPeriodLength();
        Area area = new Area(new Rectangle2D.Double(0.0, 0.0, w, h));
        area.subtract(new Area(new RoundRectangle2D.Double(1.0, 1.0, w - 2, h - 2, 0.0, 0.0)));
        ((Graphics2D)g).setPaint(UIManager.getLookAndFeelDefaults().getColor("ProgressBar.darculaMod.IndeterminateBorderColor"));
        ((Graphics2D)g).fill(area);
        area.subtract(new Area(new RoundRectangle2D.Double(0.0, 0.0, w, h, 0.0, 0.0)));
        ((Graphics2D)g).setPaint(UIManager.getLookAndFeelDefaults().getColor("ProgressBar.darculaMod.IndeterminateBackgroundColor"));
        ((Graphics2D)g).fill(area);
        g.drawRoundRect(1, 1, w - 3, h - 3, 0, 0);
        if (this.progressBar.isStringPainted()) {
            if (this.progressBar.getOrientation() == 0) {
                this.paintString(g, b.left, b.top, barRectWidth, barRectHeight, this.boxRect.x, this.boxRect.width);
            } else {
                this.paintString(g, b.left, b.top, barRectWidth, barRectHeight, this.boxRect.y, this.boxRect.height);
            }
        }
    }

    protected void paintDeterminate(Graphics g, JComponent c) {
        if (!(g instanceof Graphics2D)) {
            return;
        }
        if (this.progressBar.getOrientation() != 0 || !c.getComponentOrientation().isLeftToRight()) {
            super.paintDeterminate(g, c);
            return;
        }
        GraphicsUtil.setupAAPainting((Graphics)g);
        Insets b = this.progressBar.getInsets();
        int barRectWidth = this.progressBar.getWidth() - (b.right + b.left);
        int barRectHeight = this.progressBar.getPreferredSize().height - (b.top + b.bottom);
        int w = barRectWidth;
        int h = barRectHeight;
        if (barRectWidth <= 0 || barRectHeight <= 0) {
            return;
        }
        int amountFull = this.getAmountFull(b, barRectWidth, barRectHeight);
        Graphics2D g2 = (Graphics2D)g;
        g2.setColor(UIManager.getLookAndFeelDefaults().getColor("ProgressBar.darculaMod.DeterminateBorderColor"));
        g2.fill(new RoundRectangle2D.Double(0.0, 0.0, w - 1, h - 1, 0.0, 0.0));
        g2.setColor(UIManager.getLookAndFeelDefaults().getColor("ProgressBar.darculaMod.DeterminateBackgroundColor"));
        g2.fill(new RoundRectangle2D.Double(1.0, 1.0, w - 3, h - 3, 0.0, 0.0));
        g2.setColor(this.getProgressColor(c));
        g2.fill(new RoundRectangle2D.Double(2.0, 2.0, amountFull - 5, h - 5, 0.0, 0.0));
        if (this.progressBar.isStringPainted()) {
            this.paintString(g, b.left, b.top, barRectWidth, barRectHeight, amountFull, b);
        }
    }

    private Color getProgressColor(JComponent c) {
        Object color = c.getClientProperty("progressColor");
        if (color != null && color instanceof Color) {
            return (Color)color;
        }
        return UIManager.getLookAndFeelDefaults().getColor("ProgressBar.darculaMod.DeterminateLeftBackgroundColor");
    }
}

