/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.protocol.api.proxy;

import com.paterva.maltego.certificates.BlacklistedCertificateException;
import com.paterva.maltego.certificates.CertificateNeedValidationException;
import com.paterva.maltego.certificates.CertificateTrustHandler;
import com.paterva.maltego.certificates.CertificateUtils;
import com.paterva.maltego.certificates.HttpAgent;
import com.paterva.maltego.certificates.NoTrustedCertificateChainFoundException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;

public abstract class HttpProxy {
    private static final long BACKOFF_MILLIS = TimeUnit.HOURS.toMillis(1L);
    public static boolean ALLOW_HTTP = false;
    protected final String transformApp;
    private static final Map<String, Long> backoffHosts = new HashMap<String, Long>();
    public static final String PROTOCOL_VERSION_HEADER_KEY = "maltego-protocol-version";
    public static final String API_KEY_HEADER = "Maltego-API-Key";
    public static final String CF_KEY_HEADER = "cf-access-token";
    private final String protocolVersion;

    public HttpProxy(String transformApp, String protocolVersion) {
        this.transformApp = transformApp;
        this.protocolVersion = protocolVersion;
    }

    protected static synchronized void createExceptionFromCertificateActionIfPresent(HttpAgent agent, String url, boolean httpsOnly) throws CertificateNeedValidationException, IOException, GeneralSecurityException, NoTrustedCertificateChainFoundException, BlacklistedCertificateException {
        String host = new URL(url).getHost();
        Long backoffTime = backoffHosts.get(host);
        if (backoffTime != null && System.currentTimeMillis() - backoffTime < BACKOFF_MILLIS) {
            return;
        }
        Optional certOpt = Optional.ofNullable(null);
        CertificateTrustHandler.CertificateActions action = null;
        try {
            certOpt = agent.getServerCertificate(true);
        }
        catch (NoTrustedCertificateChainFoundException ex) {
            action = CertificateUtils.getCertActionFromException((NoTrustedCertificateChainFoundException)ex);
        }
        if (!certOpt.isPresent()) {
            if (action != null) {
                switch (action) {
                    case ALLOW: {
                        break;
                    }
                    case BLOCK: {
                        throw new NoTrustedCertificateChainFoundException("No valid certificate chain found. " + CertificateUtils.trimUrl((String)url) + " " + " URL does not match certificate Subject Alternative Names (SANs), nor subject Common Name (CN). Otherwise the certificate may be revoked, have an incomplete chain, or a cipher issue." + " Alternatively, p" + "roxy settings may be incorrect. To change them click on the options button, then rerun this wizard from the \"Maltego Data Hub\" item under the \"Transforms\" ribbon tab." + CertificateUtils.getActionString((CertificateTrustHandler.CertificateActions)action));
                    }
                    case DATE_INVALID: {
                        throw new NoTrustedCertificateChainFoundException("No valid certificate chain found. Transform certificate has invalid date." + CertificateUtils.getActionString((CertificateTrustHandler.CertificateActions)action));
                    }
                    case BLACKLISTED: {
                        throw new BlacklistedCertificateException("Certificate blacklisted in Maltego \"Certificate Manager\" (find under the \"Transforms\" ribbon tab)." + CertificateUtils.getActionString((CertificateTrustHandler.CertificateActions)action));
                    }
                    case SHOW_STORE: {
                        throw new CertificateNeedValidationException(CertificateUtils.getValidateFirstMessage((String)url) + " " + "Certificate not trusted by the Java keystore." + CertificateUtils.getActionString((CertificateTrustHandler.CertificateActions)action));
                    }
                    case SHOW_STORE_ATTACH_HOSTNAME: {
                        throw new CertificateNeedValidationException(CertificateUtils.getValidateFirstMessage((String)url) + " C" + "ertificate has no parseable Subject Alternative Names (SANs), nor subject Common Name (CN)." + CertificateUtils.getActionString((CertificateTrustHandler.CertificateActions)action));
                    }
                    case SHOW_ATTACH_HOSTNAME: {
                        throw new CertificateNeedValidationException(CertificateUtils.getValidateFirstMessage((String)url) + " " + "Certificate is trusted by the Maltego \"Certificate Manager\" (find under the \"Transforms\" ribbon tab), however the certificate has no parseable Subject Alternative Names (SANs), nor subject Common Name (CN)." + " " + CertificateUtils.trimUrl((String)url) + " URL does not match any trusted hostnames." + CertificateUtils.getActionString((CertificateTrustHandler.CertificateActions)action));
                    }
                }
            } else if (httpsOnly) {
                HttpProxy.throwNoHttps(url);
            }
        }
        backoffHosts.put(host, System.currentTimeMillis());
    }

    protected String checkValidCertificate(HttpAgent agent) throws IOException, GeneralSecurityException, NoTrustedCertificateChainFoundException {
        NoTrustedCertificateChainFoundException ntccfe = null;
        Optional certOpt = Optional.ofNullable(null);
        try {
            certOpt = agent.getServerCertificate();
        }
        catch (NoTrustedCertificateChainFoundException ex) {
            ntccfe = ex;
        }
        catch (IOException | GeneralSecurityException ex) {
            throw ex;
        }
        if (!certOpt.isPresent()) {
            if (ntccfe == null) {
                HttpProxy.throwNoHttps(this.transformApp);
            } else {
                return "Transform canceled, server not trusted";
            }
        }
        return null;
    }

    protected static void throwNoHttps(String url) throws IOException {
        if (!ALLOW_HTTP) {
            if (url.toLowerCase().startsWith("https")) {
                throw new IOException("Server did not return a trusted certificate: " + CertificateUtils.stripUrl((String)url) + "\nPlease check your SSL configuration if you are using a proxy.\n\nAlternatively, t" + "he transform certificate is blocked because of an invalid date, Subject Alternative Names (SANs) and subject Common Name (CN) that do not match the queried URL, or the certificate is blacklisted in the \"Certificate Manager\" (find under the \"Transforms\" ribbon tab).");
            }
            throw new IOException("Only HTTPS (SSL/TLS) Transform Servers are allowed, but found: " + CertificateUtils.stripUrl((String)url));
        }
    }

    protected String readResponse(HttpAgent agent) throws IOException {
        StringBuilder response;
        try (BufferedReader in = new BufferedReader(new InputStreamReader(agent.getInputStream()));){
            String inputLine;
            response = new StringBuilder();
            while ((inputLine = in.readLine()) != null) {
                response.append(inputLine);
            }
        }
        return response.toString();
    }

    public String getProtocolVersion() {
        return this.protocolVersion;
    }

    protected static String getCloudflareAccessToken() {
        return System.getenv("MALTEGO_TX_CF_TOKEN");
    }
}

