/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.wmf;

import com.twelvemonkeys.imageio.ImageReaderBase;
import com.twelvemonkeys.imageio.plugins.svg.SVGImageReader;
import com.twelvemonkeys.imageio.plugins.svg.SVGReadParam;
import com.twelvemonkeys.imageio.stream.ByteArrayImageInputStream;
import com.twelvemonkeys.imageio.util.IIOUtil;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import javax.imageio.IIOException;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;
import org.apache.batik.transcoder.TranscoderException;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.wmf.tosvg.WMFTranscoder;

public final class WMFImageReader
extends ImageReaderBase {
    private SVGImageReader reader = null;

    public WMFImageReader(ImageReaderSpi imageReaderSpi) {
        super(imageReaderSpi);
    }

    protected void resetMembers() {
        if (this.reader != null) {
            this.reader.dispose();
        }
        this.reader = null;
    }

    public BufferedImage read(int n, ImageReadParam imageReadParam) throws IOException {
        this.init();
        this.processImageStarted(n);
        BufferedImage bufferedImage = this.reader.read(n, imageReadParam);
        if (this.abortRequested()) {
            this.processReadAborted();
            return bufferedImage;
        }
        this.processImageProgress(100.0f);
        this.processImageComplete();
        return bufferedImage;
    }

    private void init() throws IOException {
        if (this.imageInput == null) {
            throw new IllegalStateException("input == null");
        }
        if (this.reader == null) {
            WMFTranscoder wMFTranscoder = new WMFTranscoder();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(8192);
            try (OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)byteArrayOutputStream, StandardCharsets.UTF_8);){
                TranscoderInput transcoderInput = new TranscoderInput(IIOUtil.createStreamAdapter((ImageInputStream)this.imageInput));
                TranscoderOutput transcoderOutput = new TranscoderOutput((Writer)outputStreamWriter);
                wMFTranscoder.transcode(transcoderInput, transcoderOutput);
            }
            catch (TranscoderException transcoderException) {
                throw new IIOException(transcoderException.getMessage(), transcoderException);
            }
            this.reader = new SVGImageReader(this.getOriginatingProvider());
            this.reader.setInput(new ByteArrayImageInputStream(byteArrayOutputStream.toByteArray()));
        }
    }

    public ImageReadParam getDefaultReadParam() {
        return new SVGReadParam();
    }

    public int getWidth(int n) throws IOException {
        this.init();
        return this.reader.getWidth(n);
    }

    public int getHeight(int n) throws IOException {
        this.init();
        return this.reader.getHeight(n);
    }

    public Iterator<ImageTypeSpecifier> getImageTypes(int n) throws IOException {
        this.init();
        return this.reader.getImageTypes(n);
    }
}

