/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.view.customization.ui.main;

import com.paterva.maltego.view.customization.api.Binding;
import com.paterva.maltego.view.customization.api.Viewlet;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;

public class ViewletImpl
implements Viewlet {
    private final String _name;
    private boolean _readOnly;
    private List<Binding> _bindings;
    private boolean _inToolbar;
    private boolean _inMenu;
    private String _icon;

    public ViewletImpl(String name) {
        this._name = name;
        this._bindings = new ArrayList<Binding>();
        this._readOnly = false;
        this._inToolbar = false;
        this._inMenu = false;
        this._icon = null;
    }

    public Object clone() throws CloneNotSupportedException {
        ViewletImpl viewletClone = (ViewletImpl)super.clone();
        ArrayList<Binding> bindings = new ArrayList<Binding>();
        for (Binding binding : this._bindings) {
            Binding bindingClone = (Binding)binding.clone();
            bindings.add(bindingClone);
        }
        viewletClone._bindings = bindings;
        return viewletClone;
    }

    public String getName() {
        return this._name;
    }

    public boolean isReadOnly() {
        return this._readOnly;
    }

    public void setReadOnly(boolean readonly) {
        this._readOnly = readonly;
    }

    public List<Binding> getBindings() {
        return this._bindings;
    }

    public boolean isInMenu() {
        return this._inMenu;
    }

    public void setInMenu(boolean inMenu) {
        this._inMenu = inMenu;
    }

    public boolean isInToolbar() {
        return this._inToolbar;
    }

    public void setInToolbar(boolean inToolbar) {
        this._inToolbar = inToolbar;
    }

    public String getIcon() {
        return this._icon;
    }

    public void setIcon(String icon) {
        this._icon = icon;
    }

    public boolean hasSimilarBindings(Viewlet other) {
        if (other == null) {
            return false;
        }
        List otherBindings = other.getBindings();
        if (this._bindings == null && otherBindings == null) {
            return true;
        }
        if (this._bindings == null || otherBindings == null) {
            return false;
        }
        if (this._bindings.size() != otherBindings.size()) {
            return false;
        }
        ListIterator<Binding> iter1 = this._bindings.listIterator();
        ListIterator iter2 = otherBindings.listIterator();
        while (iter1.hasNext()) {
            Binding binding2;
            Binding binding1 = iter1.next();
            if (binding1 == (binding2 = (Binding)iter2.next()) || binding1 != null && binding1.isSimilar(binding2)) continue;
            return false;
        }
        return true;
    }

    public int compareTo(Viewlet o) {
        return this._name.compareTo(o.getName());
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ViewletImpl other = (ViewletImpl)obj;
        return !(this._name != null ? !this._name.equals(other._name) : other._name != null);
    }

    public int hashCode() {
        int hash = 3;
        hash = 29 * hash + (this._name != null ? this._name.hashCode() : 0);
        return hash;
    }
}

