/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.view.customization.ui.binding;

import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.core.LinkEntityIDs;
import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.core.MaltegoLink;
import com.paterva.maltego.core.TypedPropertyBag;
import com.paterva.maltego.entity.api.EntityFactory;
import com.paterva.maltego.entity.api.EntityRegistry;
import com.paterva.maltego.entity.api.LinkFactory;
import com.paterva.maltego.entity.api.inheritance.InheritanceHelper;
import com.paterva.maltego.graph.GraphViewManager;
import com.paterva.maltego.graph.store.GraphStore;
import com.paterva.maltego.graph.store.GraphStoreRegistry;
import com.paterva.maltego.graph.store.data.GraphDataStoreWriter;
import com.paterva.maltego.graph.store.data.GraphStoreException;
import com.paterva.maltego.graph.wrapper.GraphStoreWriter;
import com.paterva.maltego.typing.DisplayDescriptor;
import com.paterva.maltego.typing.PropertyDescriptor;
import com.paterva.maltego.typing.descriptor.SpecRegistry;
import com.paterva.maltego.typing.descriptor.TypeInstantiationException;
import com.paterva.maltego.ui.graph.actions.TopGraphAction;
import com.paterva.maltego.util.SlownessDetector;
import com.paterva.maltego.util.StringUtilities;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.filechooser.FileFilter;
import org.openide.filesystems.FileChooserBuilder;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.windows.TopComponent;
import yguard.A.J.SA;

public class TransformDiagramTest
extends TopGraphAction {
    private static final UIDefaults LAF = UIManager.getLookAndFeelDefaults();
    private static final int COLOR_COUNT = LAF.getInt("graph-view-type-colors");
    private static final JLabel LABEL = new JLabel();
    private static final FontMetrics FM = LABEL.getFontMetrics(LABEL.getFont());

    public String getName() {
        return "TransformDiagramTest";
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected void actionPerformed(TopComponent tc) {
        SlownessDetector.setEnabled((boolean)false);
        try {
            this.createTransformDiagram();
        }
        catch (GraphStoreException | TypeInstantiationException | FileNotFoundException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private void createTransformDiagram() throws TypeInstantiationException, GraphStoreException, FileNotFoundException {
        ArrayList<String> lines = this.getCsvLines();
        List<ApiCommand> commands = this.parseCsvFile(lines);
        SA viewGraph = this.getTopViewGraph();
        GraphID graphID = GraphViewManager.getDefault().getGraphID(viewGraph);
        GraphStore graphStore = GraphStoreRegistry.getDefault().forGraphID(graphID);
        GraphDataStoreWriter writer = graphStore.getGraphDataStore().getDataStoreWriter();
        writer.beginUpdate();
        viewGraph.\u00cc();
        EntityFactory entityFactory = EntityFactory.forGraphID((GraphID)graphID);
        this.addToGraph(commands, entityFactory, graphID);
        System.out.println("Commiting...");
        viewGraph.D((Object)false);
        writer.endUpdate();
        viewGraph.\u00ff();
        System.out.println("Done");
    }

    private void addToGraph(List<ApiCommand> commands, EntityFactory entityFactory, GraphID graphID) throws TypeInstantiationException {
        int transformCount = 1;
        EntityID prevApiEntityId = null;
        for (ApiCommand loop : commands) {
            List<ApiTransform> transforms = loop.getTransforms();
            String auguryIndex = loop.getAuguryIndex();
            System.out.println(auguryIndex);
            int index = 0;
            for (ApiTransform tx : transforms) {
                EntityID apiEntityId = this.createApiCallBlock(entityFactory, graphID, auguryIndex, tx, transformCount);
                Color color = this.getColorInDefaultPalette((int)(Math.random() * (double)COLOR_COUNT));
                String function = this.createInputEntityAndLink(entityFactory, tx, graphID, color, transformCount, apiEntityId);
                this.connectApiCallBlocks(index, prevApiEntityId, apiEntityId, graphID);
                this.createOutputEntitiesAndLinks(tx, graphID, color, function, transformCount, entityFactory, apiEntityId);
                ++transformCount;
                prevApiEntityId = apiEntityId;
                ++index;
            }
        }
    }

    private String createInputEntityAndLink(EntityFactory entityFactory, ApiTransform tx, GraphID graphID, Color color, int transformCount, EntityID apiEntityId) throws TypeInstantiationException {
        String type = tx.getInputEntityType();
        MaltegoEntity input = (MaltegoEntity)entityFactory.createInstance(type, false, false);
        StringBuilder sb = new StringBuilder();
        sb.append(tx.getInputEntityType());
        sb.append(StringUtilities.newLine());
        sb.append(StringUtilities.newLine());
        if (tx.getAdditionalInputs() != null) {
            sb.append("Additional inputs: ");
            sb.append(StringUtilities.newLine());
            sb.append(StringUtilities.newLine());
            for (String additionalInput : tx.getAdditionalInputs()) {
                sb.append(additionalInput);
                sb.append(StringUtilities.newLine());
            }
        }
        this.setEntityValue(graphID, input, sb, type);
        GraphStoreWriter.addEntity((GraphID)graphID, (MaltegoEntity)input);
        EntityID source = (EntityID)input.getID();
        MaltegoLink firstLink = LinkFactory.forGraphID((GraphID)graphID).createInstance("maltego.link.manual-link", true);
        firstLink.setShowLabel(1);
        firstLink.setColor(color);
        String function = tx.getMaltegoFunction();
        LinkEntityIDs firstLinkIds = new LinkEntityIDs(source, apiEntityId);
        try {
            GraphStoreWriter.addLink((GraphID)graphID, (MaltegoLink)firstLink, (LinkEntityIDs)firstLinkIds);
        }
        catch (Exception ex) {
            System.out.println("");
        }
        return function;
    }

    private void setEntityValue(GraphID graphID, MaltegoEntity input, StringBuilder sb, String type) {
        try {
            InheritanceHelper.setValue((SpecRegistry)EntityRegistry.forGraphID((GraphID)graphID), (TypedPropertyBag)input, (Object)sb.toString());
        }
        catch (Exception ex) {
            this.setEntityValue(input, sb);
        }
        if ("maltego.URL".equals(type)) {
            this.setEntityValue(input, sb);
        }
    }

    private void setEntityValue(MaltegoEntity entity, StringBuilder sb) {
        DisplayDescriptor dd = new DisplayDescriptor(String.class, "custom.value", "Temp");
        entity.addProperty((PropertyDescriptor)dd);
        entity.setValueProperty((PropertyDescriptor)dd);
        entity.setDisplayValueExpression(dd.getName());
        entity.setValue((PropertyDescriptor)dd, (Object)sb.toString());
    }

    private EntityID createApiCallBlock(EntityFactory entityFactory, GraphID graphID, String auguryIndex, ApiTransform tx, int transformCount) throws TypeInstantiationException {
        String function = tx.getMaltegoFunction();
        StringBuilder sb = new StringBuilder();
        sb.append(auguryIndex);
        sb.append(StringUtilities.newLine());
        sb.append(StringUtilities.newLine());
        sb.append("Tx " + transformCount + ": " + (StringUtilities.isNullOrEmpty((String)function) ? "<No function>" : function));
        sb.append(StringUtilities.newLine());
        sb.append(tx.getTransformName());
        sb.append(StringUtilities.newLine());
        sb.append(StringUtilities.newLine());
        StringBuilder wrappedSB = new StringBuilder();
        StringUtilities.wrapTextInStringBuilder((StringBuilder)wrappedSB, (String)tx.getTransformDescription(), (FontMetrics)FM, (Insets)new Insets(0, 0, 0, 0), (String)StringUtilities.newLine(), (int)150, (int)200);
        sb.append(wrappedSB.toString());
        MaltegoEntity apiEntity = (MaltegoEntity)entityFactory.createInstance("maltego.hashtag", true, false);
        InheritanceHelper.setValue((SpecRegistry)EntityRegistry.forGraphID((GraphID)graphID), (TypedPropertyBag)apiEntity, (Object)sb.toString());
        GraphStoreWriter.addEntity((GraphID)graphID, (MaltegoEntity)apiEntity);
        EntityID apiEntityId = (EntityID)apiEntity.getID();
        return apiEntityId;
    }

    private void createOutputEntitiesAndLinks(ApiTransform tx, GraphID graphID, Color color, String function, int transformCount, EntityFactory entityFactory, EntityID apiEntityId) throws TypeInstantiationException {
        List<TransformOutput> transformOutputs = tx.getOutputs();
        for (TransformOutput txOut : transformOutputs) {
            MaltegoLink secondLink = LinkFactory.forGraphID((GraphID)graphID).createInstance("maltego.link.manual-link", true);
            secondLink.setShowLabel(1);
            secondLink.setColor(color);
            String type = txOut.getOutputEntity();
            MaltegoEntity output = (MaltegoEntity)entityFactory.createInstance(type, false, false);
            StringBuilder sb = new StringBuilder();
            sb.append(txOut.getOutputEntity());
            sb.append(StringUtilities.newLine());
            sb.append(StringUtilities.newLine());
            sb.append("Property: ");
            sb.append(txOut.getValueProperty());
            sb.append(StringUtilities.newLine());
            sb.append("Display: ");
            sb.append(txOut.getDisplayName());
            sb.append(StringUtilities.newLine());
            sb.append(StringUtilities.newLine());
            if (txOut.getExtraProperties() != null) {
                sb.append("Other Properties: ");
                sb.append(StringUtilities.newLine());
                sb.append(StringUtilities.newLine());
                for (String props : txOut.getExtraProperties()) {
                    sb.append(props);
                    sb.append(StringUtilities.newLine());
                }
            }
            this.setEntityValue(graphID, output, sb, type);
            GraphStoreWriter.addEntity((GraphID)graphID, (MaltegoEntity)output);
            EntityID target = (EntityID)output.getID();
            LinkEntityIDs secondLinkIds = new LinkEntityIDs(apiEntityId, target);
            try {
                GraphStoreWriter.addLink((GraphID)graphID, (MaltegoLink)secondLink, (LinkEntityIDs)secondLinkIds);
            }
            catch (Exception ex) {
                System.out.println("");
            }
        }
    }

    private void connectApiCallBlocks(int index, EntityID prevApiEntityId, EntityID apiEntityId, GraphID graphID) {
        if (index > 0 && prevApiEntityId != null) {
            LinkEntityIDs interLinkId = new LinkEntityIDs(prevApiEntityId, apiEntityId);
            MaltegoLink interLink = LinkFactory.forGraphID((GraphID)graphID).createInstance("maltego.link.manual-link", true);
            interLink.setColor(Color.RED);
            try {
                GraphStoreWriter.addLink((GraphID)graphID, (MaltegoLink)interLink, (LinkEntityIDs)interLinkId);
            }
            catch (Exception ex) {
                System.out.println("");
            }
        }
    }

    private List<ApiCommand> parseCsvFile(ArrayList<String> lines) {
        ArrayList<ApiCommand> commands = new ArrayList<ApiCommand>();
        int i = 0;
        ApiCommand command = null;
        ApiTransform transform = null;
        for (String line : lines) {
            String inputEntityType;
            if (i == 0) {
                ++i;
                continue;
            }
            String[] cols = line.split(";");
            if (cols == null || cols.length < 12) continue;
            if (!StringUtilities.isNullOrEmpty((String)cols[0])) {
                if (command != null) {
                    commands.add(command);
                }
                command = new ApiCommand(cols[0]);
            }
            if (!StringUtilities.isNullOrEmpty((String)(inputEntityType = cols[4]))) {
                String prevMaltegoFunction = cols[2];
                String prevInputEntity = inputEntityType;
                String[] prevAdditionalInputs = !StringUtilities.isNullOrEmpty((String)cols[5]) ? cols[5].split(",") : null;
                String prevTransformName = cols[7];
                String prevTransformDescription = cols[8];
                transform = new ApiTransform(prevMaltegoFunction, prevInputEntity, prevAdditionalInputs, prevTransformName, prevTransformDescription);
            }
            ArrayList<String> extraProperties = new ArrayList<String>();
            for (int j = 12; j < cols.length; ++j) {
                if (StringUtilities.isNullOrEmpty((String)cols[j])) continue;
                extraProperties.add(cols[j]);
            }
            TransformOutput output = new TransformOutput(cols[9], cols[10], cols[11], extraProperties);
            transform.addTransform(output);
            if (StringUtilities.isNullOrEmpty((String)inputEntityType)) continue;
            command.addTransform(transform);
        }
        if (command != null && !commands.contains(command)) {
            commands.add(command);
        }
        return commands;
    }

    private ArrayList<String> getCsvLines() throws FileNotFoundException {
        ArrayList<String> lines = new ArrayList<String>();
        File file = TransformDiagramTest.showFileDialog();
        if (file != null && file.exists()) {
            FileInputStream fis = new FileInputStream(file);
            BufferedReader in = new BufferedReader(new InputStreamReader(fis));
            try {
                String line;
                while ((line = in.readLine()) != null) {
                    lines.add(line);
                }
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return lines;
    }

    private static File showFileDialog() {
        FileChooserBuilder builder = new FileChooserBuilder(TransformDiagramTest.class);
        builder.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f != null && f.isFile() && "csv".equals(f.getName().substring(f.getName().length() - 3).toLowerCase());
            }

            @Override
            public String getDescription() {
                return "CSV file with ; delimiter";
            }
        });
        builder.setApproveText("Import CSV file");
        builder.setFilesOnly(true);
        builder.setTitle("Select CSV file (with ; delimiter) to add");
        File file = builder.showOpenDialog();
        return file;
    }

    private Color getColorInDefaultPalette(int position) {
        return LAF.getColor(String.format("graph-view-type-color%s", position));
    }

    private class TransformOutput {
        private final String outputEntity;
        private final String valueProperty;
        private final String displayName;
        private final List<String> extraProperties;

        public TransformOutput(String outputEntity, String valueProperty, String displayName, List<String> extraProperties) {
            this.outputEntity = outputEntity;
            this.valueProperty = valueProperty;
            this.displayName = displayName;
            this.extraProperties = extraProperties;
        }

        public String getOutputEntity() {
            return this.outputEntity;
        }

        public String getValueProperty() {
            return this.valueProperty;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public List<String> getExtraProperties() {
            return this.extraProperties;
        }
    }

    private class ApiTransform {
        private final String maltegoFunction;
        private final String inputEntityType;
        private final String[] additionalInputs;
        private final String transformName;
        private final String transformDescription;
        private final List<TransformOutput> outputs = new ArrayList<TransformOutput>();

        public ApiTransform(String maltegoFunction, String inputEntityType, String[] additionalInputs, String transformName, String transformDescription) {
            this.maltegoFunction = maltegoFunction;
            this.inputEntityType = inputEntityType;
            this.additionalInputs = additionalInputs;
            this.transformName = transformName;
            this.transformDescription = transformDescription;
        }

        public String getMaltegoFunction() {
            return this.maltegoFunction;
        }

        public String getInputEntityType() {
            return this.inputEntityType;
        }

        public String[] getAdditionalInputs() {
            return this.additionalInputs;
        }

        public String getTransformName() {
            return this.transformName;
        }

        public String getTransformDescription() {
            return this.transformDescription;
        }

        public void addTransform(TransformOutput output) {
            this.outputs.add(output);
        }

        public List<TransformOutput> getOutputs() {
            return this.outputs;
        }
    }

    private class ApiCommand {
        private final String auguryIndex;
        private final List<ApiTransform> transforms = new ArrayList<ApiTransform>();

        public ApiCommand(String auguryIndex) {
            this.auguryIndex = auguryIndex;
        }

        public void addTransform(ApiTransform transform) {
            this.transforms.add(transform);
        }

        public String getAuguryIndex() {
            return this.auguryIndex;
        }

        public List<ApiTransform> getTransforms() {
            return this.transforms;
        }
    }
}

