/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.runner.impl;

import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.entity.api.EntityFactory;
import com.paterva.maltego.entity.api.EntityRegistry;
import com.paterva.maltego.entity.api.LinkFactory;
import com.paterva.maltego.graph.undo.Command;
import com.paterva.maltego.graph.undo.UndoRedoManager;
import com.paterva.maltego.graph.undo.UndoRedoModel;
import com.paterva.maltego.licensing.A;
import com.paterva.maltego.licensing.LicenseManager;
import com.paterva.maltego.transform.descriptor.TransformDefinition;
import com.paterva.maltego.transform.descriptor.TransformServerInfo;
import com.paterva.maltego.transform.runner.TransformRequestProcessor;
import com.paterva.maltego.transform.runner.api.TransformInputProvider;
import com.paterva.maltego.transform.runner.api.TransformRunManager;
import com.paterva.maltego.transform.runner.api.TransformRunOrigin;
import com.paterva.maltego.transform.runner.api.TransformServerMap;
import com.paterva.maltego.transform.runner.api.TransformServerMapProvider;
import com.paterva.maltego.transform.runner.api.TransformsHandle;
import com.paterva.maltego.ui.graph.GraphEditorRegistry;
import com.paterva.maltego.ui.graph.data.GraphDataObject;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.windows.TopComponent;

public class DefaultTransformRequestProcessor
extends TransformRequestProcessor {
    private long _lastLicenseCheck = 0L;
    private static final int MINUTES_BETWEEN_CHECKS = 5;
    private static final int MILLIS_BETWEEN_CHECKS = 300000;

    @Override
    public void runTransforms(Collection<? extends TransformDefinition> transforms, TransformServerInfo server, GraphID graphID, Set<EntityID> entities, boolean runAll, TransformRunOrigin runOrigin) {
        if (runAll) {
            Iterator<? extends TransformDefinition> itr = transforms.iterator();
            while (itr.hasNext()) {
                TransformDefinition transform = itr.next();
                if (!transform.isRunWithAll()) {
                    itr.remove();
                    continue;
                }
                if (!"maltego.transform.WebTx".equals(transform.getName())) continue;
                transform.setRunWithAll(false);
                itr.remove();
            }
            if (transforms.isEmpty()) {
                return;
            }
        }
        com.paterva.maltego.licensing.mode.A licenseMode = LicenseManager.A().A(false);
        int maxSelectedEntities = A.E((com.paterva.maltego.licensing.mode.A)licenseMode);
        if (entities.size() > maxSelectedEntities) {
            String msg = "Transforms can only be run on at most " + maxSelectedEntities + " entities on this Maltego Plan. Proceed running transform on " + maxSelectedEntities + " entities?";
            NotifyDescriptor.Confirmation conf = new NotifyDescriptor.Confirmation((Object)msg, "Transform Input Limit Reached", 2);
            if (NotifyDescriptor.Confirmation.OK_OPTION.equals(DialogDisplayer.getDefault().notify((NotifyDescriptor)conf))) {
                HashSet<EntityID> entityIDs = new HashSet<EntityID>(maxSelectedEntities);
                for (EntityID entityID : entities) {
                    entityIDs.add(entityID);
                    if (entityIDs.size() < maxSelectedEntities) continue;
                    break;
                }
                entities = entityIDs;
            } else {
                return;
            }
        }
        if (this.validateLicense()) {
            GraphDataObject gdo = DefaultTransformRequestProcessor.getTopGraphDataObject();
            if (gdo != null) {
                TransformServerMap transformMap = TransformServerMapProvider.getDefault().get(transforms, server);
                Map inputs = TransformInputProvider.getDefault().getInputs(transformMap);
                if (!transformMap.getMap().isEmpty() && inputs != null) {
                    EntityRegistry entityRegistry = EntityRegistry.forGraphID((GraphID)graphID);
                    EntityFactory entityFactory = EntityFactory.forGraphID((GraphID)graphID);
                    LinkFactory linkFactory = LinkFactory.forGraphID((GraphID)graphID);
                    TransformRunManager runManager = TransformRunManager.getDefault();
                    TransformsHandle handle = runManager.runTransforms(graphID, transformMap.getMap(), inputs, entities, entityRegistry, entityFactory, linkFactory, true, null, runOrigin);
                    UndoRedoModel undoRedo = UndoRedoManager.getDefault().get(graphID);
                    undoRedo.store((Command)new UndoRunTransformCommand(handle));
                }
            }
        } else {
            NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)"You have to activate Maltego before you can run transforms (alternatively please check your network and proxy settings).", 0);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
        }
    }

    private static GraphDataObject getTopGraphDataObject() {
        GraphDataObject gdo = null;
        TopComponent tc = GraphEditorRegistry.getDefault().getTopmost();
        if (tc != null) {
            gdo = (GraphDataObject)tc.getLookup().lookup(GraphDataObject.class);
        }
        return gdo;
    }

    private boolean validateLicense() {
        long time = System.currentTimeMillis();
        long delta = time - this._lastLicenseCheck;
        if (delta > 300000L) {
            this._lastLicenseCheck = time;
            return LicenseManager.A().A(false, false);
        }
        return true;
    }

    private static class UndoRunTransformCommand
    extends Command {
        private final TransformsHandle _handle;

        public UndoRunTransformCommand(TransformsHandle handle) {
            this._handle = handle;
        }

        public void execute() {
        }

        public void undo() {
            TransformRunManager.getDefault().cancel(this._handle);
        }

        public String getDescription() {
            return "Run transforms";
        }

        public boolean isSignificant() {
            return TransformRunManager.getDefault().isRunning(this._handle);
        }
    }
}

